/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.palo;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.store.mysql.MysqlSessions;
import org.apache.hugegraph.backend.store.mysql.ResultSetWrapper;
import org.apache.hugegraph.backend.store.palo.PaloFile;
import org.apache.hugegraph.backend.store.palo.PaloHttpClient;
import org.apache.hugegraph.backend.store.palo.PaloLoadInfo;
import org.apache.hugegraph.backend.store.palo.PaloOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.date.SafeDateFormat;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class PaloSessions
extends MysqlSessions {
    private static final Logger LOG = Log.logger(PaloSessions.class);
    private final AtomicInteger counter = new AtomicInteger();
    private final Map<Integer, ReadWriteLock> locks = new ConcurrentHashMap<Integer, ReadWriteLock>();
    private final Timer timer;
    private final PaloLoadTask loadTask;

    public PaloSessions(HugeConfig config, String database, String store, List<String> tableDirs) {
        super(config, database, store);
        this.restoreSessionInfo(config, tableDirs);
        this.timer = new Timer(true);
        long interval = ((Integer)config.get(PaloOptions.PALO_POLL_INTERVAL)).intValue();
        this.loadTask = new PaloLoadTask(tableDirs);
        this.timer.schedule((TimerTask)this.loadTask, 0L, interval * 1000L);
    }

    private void restoreSessionInfo(HugeConfig config, List<String> tableDirs) {
        Set<Integer> sessionIds = PaloFile.scanSessionIds(config, tableDirs);
        for (Integer sessionId : sessionIds) {
            if (this.locks.containsKey(sessionId)) continue;
            this.locks.put(sessionId, new ReentrantReadWriteLock());
        }
        int maxSessionId = 0;
        for (int sessionId : sessionIds) {
            if (sessionId <= maxSessionId) continue;
            maxSessionId = sessionId;
        }
        this.counter.addAndGet(maxSessionId);
    }

    protected String buildCreateDatabase(String database) {
        return String.format("CREATE DATABASE IF NOT EXISTS %s;", database);
    }

    public final Session session() {
        return (Session)super.getOrNewSession();
    }

    protected final Session newSession() {
        int id = this.counter.incrementAndGet();
        this.locks.put(id, new ReentrantReadWriteLock());
        return new Session(id);
    }

    public boolean close() {
        this.loadTask.join();
        this.timer.cancel();
        super.close();
        return true;
    }

    public final class PaloLoadTask
    extends TimerTask {
        private static final String DF = "yyyy-MM-dd-HH-mm-ss";
        private final SafeDateFormat dateFormat = new SafeDateFormat("yyyy-MM-dd-HH-mm-ss");
        private final List<String> tableDirs;
        private List<PaloFile> lastPaloFiles;
        private final PaloHttpClient client;

        public PaloLoadTask(List<String> tableDirs) {
            this.tableDirs = tableDirs;
            this.lastPaloFiles = null;
            this.client = new PaloHttpClient(PaloSessions.this.config(), PaloSessions.this.database());
        }

        public void join() {
            Integer interval = (Integer)PaloSessions.this.config().get(PaloOptions.PALO_POLL_INTERVAL);
            while (this.lastPaloFiles != null && !this.lastPaloFiles.isEmpty()) {
                try {
                    TimeUnit.SECONDS.sleep(interval.intValue());
                }
                catch (InterruptedException e) {
                    throw new BackendException((Throwable)e);
                }
            }
        }

        @Override
        public void run() {
            LOG.debug("The Load task:{} ready to run", (Object)PaloSessions.this);
            String path = (String)PaloSessions.this.config().get(PaloOptions.PALO_TEMP_DIR);
            List<PaloFile> paloFiles = PaloFile.scan(path, this.tableDirs);
            if (paloFiles.isEmpty()) {
                return;
            }
            if (this.lastPaloFiles != null) {
                this.tryLoadBatch(paloFiles);
            }
            this.lastPaloFiles = paloFiles;
        }

        private void tryLoadBatch(List<PaloFile> files) {
            PaloFile file = this.peekFile(files);
            this.loadThenDelete(file);
            files.remove(file);
        }

        private PaloFile peekFile(List<PaloFile> files) {
            assert (!files.isEmpty());
            long limitSize = PaloFile.limitSize(PaloSessions.this.config());
            for (PaloFile file : files) {
                long fileSize = file.length();
                if (fileSize < limitSize) continue;
                return file;
            }
            return files.get(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadThenDelete(PaloFile file) {
            int sessionId = file.sessionId();
            LOG.info("Ready to load one batch from file: {}", (Object)file);
            Lock lock = ((ReadWriteLock)PaloSessions.this.locks.get(sessionId)).writeLock();
            lock.lock();
            try {
                String table = file.table();
                String data = file.readAsString();
                String label = this.formatLabel(table);
                this.client.bulkLoadAsync(table, data, label);
                file.forceDelete();
            }
            finally {
                lock.unlock();
            }
        }

        private String formatLabel(String table) {
            return table + "-" + this.dateFormat.format(new Date());
        }
    }

    public final class Session
    extends MysqlSessions.Session {
        private final int id;
        private final Map<String, Integer> parts;
        private final Multimap<String, String> batch;

        public Session(int id) {
            super((MysqlSessions)PaloSessions.this);
            this.id = id;
            this.parts = new HashMap<String, Integer>();
            this.batch = LinkedListMultimap.create();
        }

        public void add(String table, String row) {
            this.batch.put((Object)table, (Object)row);
            this.parts.putIfAbsent(table, 0);
        }

        public Integer commit() {
            int updated = 0;
            if (!this.batch.isEmpty()) {
                updated += this.writeBatch();
            }
            this.clear();
            return updated += super.commit().intValue();
        }

        public void rollback() {
            super.rollback();
            this.clear();
        }

        public void clear() {
            super.clear();
            this.batch.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int writeBatch() {
            int updated = 0;
            ((ReadWriteLock)PaloSessions.this.locks.get(this.id)).writeLock().lock();
            try {
                for (String table : this.batch.keySet()) {
                    PaloFile file = this.getOrCreate(table);
                    updated += file.writeLines(this.batch.get((Object)table));
                }
            }
            finally {
                ((ReadWriteLock)PaloSessions.this.locks.get(this.id)).writeLock().unlock();
            }
            return updated;
        }

        private PaloFile getOrCreate(String table) {
            int part;
            String tempDir = (String)this.config().get(PaloOptions.PALO_TEMP_DIR);
            long limitSize = PaloFile.limitSize(this.config());
            String path = Paths.get(tempDir, table).toString();
            PaloFile file = new PaloFile(path, this.id, part = this.parts.get(table).intValue());
            if (file.length() >= limitSize) {
                this.parts.put(table, ++part);
                file = new PaloFile(path, this.id, part);
            }
            return file;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private PaloLoadInfo getLoadInfoByLabel(String label) {
            String sql = String.format("SHOW LOAD WHERE LABEL = '%s'", label);
            try (ResultSetWrapper results = this.select(sql);){
                ResultSet rs = results.resultSet();
                if (rs.next()) {
                    PaloLoadInfo paloLoadInfo = new PaloLoadInfo(rs);
                    return paloLoadInfo;
                }
                throw new BackendException("Non-exist load label '%s'", new Object[]{label});
            }
            catch (SQLException e) {
                throw new BackendException("Failed to fetch load info for label '%s'", (Throwable)e, new Object[]{label});
            }
        }
    }
}

