/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.rocksdb;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.StringEncoding;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;

public final class RocksDBIteratorPool
implements AutoCloseable {
    private static final Logger LOG = Log.logger(RocksDBIteratorPool.class);
    private static final int ITERATOR_POOL_CAPACITY = CoreOptions.CPUS * 2;
    private final Queue<RocksIterator> pool = new ArrayBlockingQueue<RocksIterator>(ITERATOR_POOL_CAPACITY);
    private final RocksDB rocksdb;
    private final ColumnFamilyHandle cfh;
    private final String cfName;

    public RocksDBIteratorPool(RocksDB rocksdb, ColumnFamilyHandle cfh) {
        String cfName;
        this.rocksdb = rocksdb;
        this.cfh = cfh;
        try {
            cfName = StringEncoding.decode((byte[])this.cfh.getName());
        }
        catch (RocksDBException e) {
            LOG.warn("Can't get column family name", (Throwable)e);
            cfName = "CF-" + cfh.getID();
        }
        this.cfName = cfName;
    }

    public ReusedRocksIterator newIterator() {
        return new ReusedRocksIterator();
    }

    @Override
    public void close() {
        RocksIterator iter;
        LOG.debug("Close IteratorPool with pool size {} ({})", (Object)this.pool.size(), (Object)this);
        while ((iter = this.pool.poll()) != null) {
            this.closeIterator(iter);
        }
        assert (this.pool.isEmpty());
    }

    public String toString() {
        return "IteratorPool-" + this.cfName;
    }

    private RocksIterator allocIterator() {
        RocksIterator iter = this.pool.poll();
        if (iter != null) {
            if (this.refreshIterator(iter)) {
                return iter;
            }
            this.closeIterator(iter);
        }
        iter = this.createIterator();
        try {
            iter.status();
            return iter;
        }
        catch (RocksDBException e) {
            this.closeIterator(iter);
            throw new BackendException((Throwable)e);
        }
    }

    private void releaseIterator(RocksIterator iter) {
        assert (iter.isOwningHandle());
        boolean added = this.pool.offer(iter);
        if (!added) {
            LOG.debug("Really close iterator {} since the pool is full({})", (Object)iter, (Object)this.pool.size());
            this.closeIterator(iter);
        } else assert (this.refreshIterator(iter));
    }

    private boolean refreshIterator(RocksIterator iter) {
        if (iter.isOwningHandle()) {
            try {
                iter.refresh();
                return true;
            }
            catch (RocksDBException e) {
                LOG.warn("Can't refresh RocksIterator: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return false;
    }

    private RocksIterator createIterator() {
        RocksIterator iter = this.rocksdb.newIterator(this.cfh);
        LOG.debug("Create iterator: {}", (Object)iter);
        return iter;
    }

    private void closeIterator(RocksIterator iter) {
        LOG.debug("Really close iterator {}", (Object)iter);
        if (iter.isOwningHandle()) {
            iter.close();
        }
    }

    protected final class ReusedRocksIterator {
        private static final boolean REUSING_ENABLED = false;
        private final RocksIterator iterator;
        private boolean closed = false;

        public ReusedRocksIterator() {
            this.iterator = RocksDBIteratorPool.this.createIterator();
        }

        public RocksIterator iterator() {
            assert (!this.closed);
            return this.iterator;
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            RocksDBIteratorPool.this.closeIterator(this.iterator);
        }
    }
}

