/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.io.IOException;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.IO;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.RemoteGraph;
import org.apache.tinkerpop.gremlin.structure.io.IoTest;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLResourceAccess;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONResourceAccess;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoResourceAccess;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class ReadTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Object, Object> get_g_io_readXkryoX(String var1) throws IOException;

    public abstract Traversal<Object, Object> get_g_io_read_withXreader_gryoX(String var1) throws IOException;

    public abstract Traversal<Object, Object> get_g_io_readXjsonX(String var1) throws IOException;

    public abstract Traversal<Object, Object> get_g_io_read_withXreader_graphsonX(String var1) throws IOException;

    public abstract Traversal<Object, Object> get_g_io_readXxmlX(String var1) throws IOException;

    public abstract Traversal<Object, Object> get_g_io_read_withXreader_graphmlX(String var1) throws IOException;

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="IoRead")
    public void g_io_readXkryoX() throws IOException {
        String fileToRead = TestHelper.generateTempFileFromResource(ReadTest.class, GryoResourceAccess.class, (String)"tinkerpop-modern-v3d0.kryo", (String)"").getAbsolutePath().replace('\\', '/');
        Traversal<Object, Object> traversal = this.get_g_io_readXkryoX(fileToRead);
        this.printTraversalForm(traversal);
        traversal.iterate();
        if (this.graph instanceof RemoteGraph) {
            Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
            Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        } else {
            IoTest.assertModernGraph(this.graph, false, true);
        }
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="IoRead")
    public void g_io_read_withXreader_gryoX() throws IOException {
        String fileToRead = TestHelper.generateTempFileFromResource(ReadTest.class, GryoResourceAccess.class, (String)"tinkerpop-modern-v3d0.kryo", (String)"").getAbsolutePath().replace('\\', '/');
        Traversal<Object, Object> traversal = this.get_g_io_read_withXreader_gryoX(fileToRead);
        this.printTraversalForm(traversal);
        traversal.iterate();
        if (this.graph instanceof RemoteGraph) {
            Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
            Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        } else {
            IoTest.assertModernGraph(this.graph, false, true);
        }
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="IoRead")
    public void g_io_readXjsonX() throws IOException {
        String fileToRead = TestHelper.generateTempFileFromResource(ReadTest.class, GraphSONResourceAccess.class, (String)"tinkerpop-modern-v3d0.json", (String)"").getAbsolutePath().replace('\\', '/');
        Traversal<Object, Object> traversal = this.get_g_io_readXjsonX(fileToRead);
        this.printTraversalForm(traversal);
        traversal.iterate();
        if (this.graph instanceof RemoteGraph) {
            Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
            Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        } else {
            IoTest.assertModernGraph(this.graph, false, true);
        }
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="IoRead")
    public void g_io_read_withXreader_graphsonX() throws IOException {
        String fileToRead = TestHelper.generateTempFileFromResource(ReadTest.class, GraphSONResourceAccess.class, (String)"tinkerpop-modern-v3d0.json", (String)"").getAbsolutePath().replace('\\', '/');
        Traversal<Object, Object> traversal = this.get_g_io_read_withXreader_graphsonX(fileToRead);
        this.printTraversalForm(traversal);
        traversal.iterate();
        if (this.graph instanceof RemoteGraph) {
            Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
            Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        } else {
            IoTest.assertModernGraph(this.graph, false, true);
        }
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="IoRead")
    public void g_io_readXxmlX() throws IOException {
        String fileToRead = TestHelper.generateTempFileFromResource(ReadTest.class, GraphMLResourceAccess.class, (String)"tinkerpop-modern.xml", (String)"").getAbsolutePath().replace('\\', '/');
        Traversal<Object, Object> traversal = this.get_g_io_readXxmlX(fileToRead);
        this.printTraversalForm(traversal);
        traversal.iterate();
        if (this.graph instanceof RemoteGraph) {
            Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
            Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        } else {
            IoTest.assertModernGraph(this.graph, false, true);
        }
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="IoRead")
    public void g_io_read_withXreader_graphmlX() throws IOException {
        String fileToRead = TestHelper.generateTempFileFromResource(ReadTest.class, GraphMLResourceAccess.class, (String)"tinkerpop-modern.xml", (String)"").getAbsolutePath().replace('\\', '/');
        Traversal<Object, Object> traversal = this.get_g_io_read_withXreader_graphmlX(fileToRead);
        this.printTraversalForm(traversal);
        traversal.iterate();
        if (this.graph instanceof RemoteGraph) {
            Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
            Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        } else {
            IoTest.assertModernGraph(this.graph, false, true);
        }
    }

    public static class Traversals
    extends ReadTest {
        @Override
        public Traversal<Object, Object> get_g_io_readXkryoX(String fileToRead) throws IOException {
            return this.g.io(fileToRead).read();
        }

        @Override
        public Traversal<Object, Object> get_g_io_read_withXreader_gryoX(String fileToRead) throws IOException {
            return this.g.io(fileToRead).with(IO.reader, (Object)"gryo").read();
        }

        @Override
        public Traversal<Object, Object> get_g_io_readXjsonX(String fileToRead) throws IOException {
            return this.g.io(fileToRead).read();
        }

        @Override
        public Traversal<Object, Object> get_g_io_read_withXreader_graphsonX(String fileToRead) throws IOException {
            return this.g.io(fileToRead).with(IO.reader, (Object)"graphson").read();
        }

        @Override
        public Traversal<Object, Object> get_g_io_readXxmlX(String fileToRead) throws IOException {
            return this.g.io(fileToRead).read();
        }

        @Override
        public Traversal<Object, Object> get_g_io_read_withXreader_graphmlX(String fileToRead) throws IOException {
            return this.g.io(fileToRead).with(IO.reader, (Object)"graphml").read();
        }
    }
}

