/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.path;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.AbstractAlgorithm;
import org.apache.hugegraph.job.algorithm.Consumers;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.SubGraphTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.ParameterUtil;

public class RingsDetectAlgorithm
extends AbstractAlgorithm {
    public static final String ALGO_NAME = "rings";
    public static final String KEY_COUNT_ONLY = "count_only";

    @Override
    public String category() {
        return "path";
    }

    @Override
    public String name() {
        return ALGO_NAME;
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        RingsDetectAlgorithm.depth(parameters);
        RingsDetectAlgorithm.degree(parameters);
        RingsDetectAlgorithm.eachLimit(parameters);
        RingsDetectAlgorithm.limit(parameters);
        RingsDetectAlgorithm.sourceLabel(parameters);
        RingsDetectAlgorithm.sourceCLabel(parameters);
        RingsDetectAlgorithm.direction(parameters);
        RingsDetectAlgorithm.edgeLabel(parameters);
        this.countOnly(parameters);
        RingsDetectAlgorithm.workers(parameters);
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        int workers = RingsDetectAlgorithm.workers(parameters);
        try (Traverser traverser = new Traverser(job, workers);){
            Object object = traverser.rings(RingsDetectAlgorithm.sourceLabel(parameters), RingsDetectAlgorithm.sourceCLabel(parameters), RingsDetectAlgorithm.direction(parameters), RingsDetectAlgorithm.edgeLabel(parameters), RingsDetectAlgorithm.depth(parameters), RingsDetectAlgorithm.degree(parameters), RingsDetectAlgorithm.eachLimit(parameters), RingsDetectAlgorithm.limit(parameters), this.countOnly(parameters));
            return object;
        }
    }

    protected boolean countOnly(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_COUNT_ONLY)) {
            return false;
        }
        return ParameterUtil.parameterBoolean(parameters, KEY_COUNT_ONLY);
    }

    private static class Traverser
    extends AbstractAlgorithm.AlgoTraverser {
        public Traverser(UserJob<Object> job, int workers) {
            super(job, RingsDetectAlgorithm.ALGO_NAME, workers);
        }

        public Object rings(String sourceLabel, String sourceCLabel, Directions dir, String label, int depth, long degree, long eachLimit, long limit, boolean countOnly) {
            AbstractAlgorithm.JsonMap ringsJson = new AbstractAlgorithm.JsonMap();
            ringsJson.startObject();
            if (countOnly) {
                ringsJson.appendKey("rings_count");
            } else {
                ringsJson.appendKey(RingsDetectAlgorithm.ALGO_NAME);
                ringsJson.startList();
            }
            SubGraphTraverser traverser = new SubGraphTraverser(this.graph());
            AtomicLong count = new AtomicLong(0L);
            this.traverse(sourceLabel, sourceCLabel, v -> {
                Id source = (Id)v.id();
                HugeTraverser.PathSet rings = traverser.rings(source, dir, label, depth, true, degree, 100000000L, eachLimit);
                assert (eachLimit == -1L || (long)rings.size() <= eachLimit);
                for (HugeTraverser.Path ring : rings) {
                    if (eachLimit == -1L && !ring.ownedBy(source)) continue;
                    if (count.incrementAndGet() > limit && limit != -1L) {
                        throw new Consumers.StopExecution("exceed limit %s", limit);
                    }
                    if (countOnly) continue;
                    String ringJson = JsonUtil.toJson(ring.vertices());
                    AbstractAlgorithm.JsonMap jsonMap = ringsJson;
                    synchronized (jsonMap) {
                        ringsJson.appendRaw(ringJson);
                    }
                }
            });
            if (countOnly) {
                long counted = count.get();
                if (limit != -1L && counted > limit) {
                    counted = limit;
                }
                ringsJson.append(counted);
            } else {
                ringsJson.endList();
            }
            ringsJson.endObject();
            return ringsJson.asJson();
        }
    }
}

