/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.OltpTraverser;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class JaccardSimilarTraverser
extends OltpTraverser {
    public JaccardSimilarTraverser(HugeGraph graph) {
        super(graph);
    }

    private static void reachCapacity(long count, long capacity) {
        if (capacity != -1L && count > capacity) {
            throw new HugeException("Reach capacity '%s'", capacity);
        }
    }

    public double jaccardSimilarity(Id vertex, Id other, Directions dir, String label, long degree) {
        E.checkNotNull((Object)vertex, (String)"vertex id");
        E.checkNotNull((Object)other, (String)"the other vertex id");
        this.checkVertexExist(vertex, "vertex");
        this.checkVertexExist(other, "other vertex");
        E.checkNotNull((Object)dir, (String)"direction");
        JaccardSimilarTraverser.checkDegree(degree);
        Id labelId = this.getEdgeLabelIdOrNull(label);
        Set sourceNeighbors = IteratorUtils.set(this.adjacentVertices(vertex, dir, labelId, degree));
        Set targetNeighbors = IteratorUtils.set(this.adjacentVertices(other, dir, labelId, degree));
        this.vertexIterCounter.addAndGet(2L);
        this.edgeIterCounter.addAndGet(sourceNeighbors.size());
        this.edgeIterCounter.addAndGet(targetNeighbors.size());
        return this.jaccardSimilarity(sourceNeighbors, targetNeighbors);
    }

    public double jaccardSimilarity(Set<Id> set1, Set<Id> set2) {
        int interNum = CollectionUtil.intersect(set1, set2).size();
        int unionNum = CollectionUtil.union(set1, set2).size();
        if (unionNum == 0) {
            return 0.0;
        }
        return (double)interNum / (double)unionNum;
    }

    public Map<Id, Double> jaccardSimilars(Id source, EdgeStep step, int top, long capacity) {
        E.checkNotNull((Object)source, (String)"source vertex id");
        this.checkVertexExist(source, "source vertex");
        JaccardSimilarTraverser.checkCapacity(capacity);
        int maxDepth = 3;
        Map<Id, Double> results = maxDepth >= this.concurrentDepth() ? this.jaccardSimilarsConcurrent(source, step, capacity) : this.jaccardSimilarsSingle(source, step, capacity);
        if (top > 0) {
            results = HugeTraverser.topN(results, true, top);
        }
        return results;
    }

    public Map<Id, Double> jaccardSimilarsConcurrent(Id source, EdgeStep step, long capacity) {
        AtomicLong count = new AtomicLong(0L);
        ConcurrentHashMap.KeySetView accessed = ConcurrentHashMap.newKeySet();
        accessed.add(source);
        JaccardSimilarTraverser.reachCapacity(count.incrementAndGet(), capacity);
        Set<Id> layer1s = this.adjacentVertices(source, step);
        this.vertexIterCounter.addAndGet(1L);
        this.edgeIterCounter.addAndGet(layer1s.size());
        JaccardSimilarTraverser.reachCapacity(count.get() + (long)layer1s.size(), capacity);
        count.addAndGet(layer1s.size());
        if (layer1s.isEmpty()) {
            return ImmutableMap.of();
        }
        ConcurrentHashMap<Id, Double> results = new ConcurrentHashMap<Id, Double>();
        ConcurrentHashMap.KeySetView layer2All = ConcurrentHashMap.newKeySet();
        this.traverseIds(layer1s.iterator(), id -> {
            if (accessed.contains(id)) {
                return;
            }
            Set<Id> layer2s = this.adjacentVertices((Id)id, step);
            this.vertexIterCounter.addAndGet(1L);
            this.edgeIterCounter.addAndGet(layer2s.size());
            if (layer2s.isEmpty()) {
                results.put((Id)id, 0.0);
            }
            layer2All.addAll(layer2s);
            JaccardSimilarTraverser.reachCapacity(count.get() + (long)layer2All.size(), capacity);
            double jaccardSimilarity = this.jaccardSimilarity(layer1s, layer2s);
            results.put((Id)id, jaccardSimilarity);
            accessed.add(id);
        });
        count.addAndGet(layer2All.size());
        this.traverseIds(layer2All.iterator(), id -> {
            if (accessed.contains(id)) {
                return;
            }
            Set<Id> layer3s = this.adjacentVertices((Id)id, step);
            this.vertexIterCounter.addAndGet(1L);
            this.edgeIterCounter.addAndGet(layer3s.size());
            JaccardSimilarTraverser.reachCapacity(count.get() + (long)layer3s.size(), capacity);
            if (layer3s.isEmpty()) {
                results.put((Id)id, 0.0);
            }
            double jaccardSimilarity = this.jaccardSimilarity(layer1s, layer3s);
            results.put((Id)id, jaccardSimilarity);
            accessed.add(id);
        });
        return results;
    }

    public Map<Id, Double> jaccardSimilarsSingle(Id source, EdgeStep step, long capacity) {
        double jaccardSimilarity;
        long count = 0L;
        Set<Id> accessed = JaccardSimilarTraverser.newIdSet();
        accessed.add(source);
        JaccardSimilarTraverser.reachCapacity(++count, capacity);
        Set<Id> layer1s = this.adjacentVertices(source, step);
        this.vertexIterCounter.addAndGet(1L);
        this.edgeIterCounter.addAndGet(layer1s.size());
        JaccardSimilarTraverser.reachCapacity(count + (long)layer1s.size(), capacity);
        count += (long)layer1s.size();
        if (layer1s.isEmpty()) {
            return ImmutableMap.of();
        }
        Map<Id, Double> results = JaccardSimilarTraverser.newMap();
        Set<Id> layer2All = JaccardSimilarTraverser.newIdSet();
        for (Id neighbor : layer1s) {
            if (accessed.contains(neighbor)) continue;
            Set<Id> layer2s = this.adjacentVertices(neighbor, step);
            this.vertexIterCounter.addAndGet(1L);
            this.edgeIterCounter.addAndGet(layer2s.size());
            if (layer2s.isEmpty()) {
                results.put(neighbor, 0.0);
                continue;
            }
            layer2All.addAll(layer2s);
            JaccardSimilarTraverser.reachCapacity(count + (long)layer2All.size(), capacity);
            jaccardSimilarity = this.jaccardSimilarity(layer1s, layer2s);
            results.put(neighbor, jaccardSimilarity);
            accessed.add(neighbor);
        }
        count += (long)layer2All.size();
        for (Id neighbor : layer2All) {
            if (accessed.contains(neighbor)) continue;
            Set<Id> layer3s = this.adjacentVertices(neighbor, step);
            this.vertexIterCounter.addAndGet(1L);
            this.edgeIterCounter.addAndGet(layer3s.size());
            JaccardSimilarTraverser.reachCapacity(count + (long)layer3s.size(), capacity);
            if (layer3s.isEmpty()) {
                results.put(neighbor, 0.0);
                continue;
            }
            jaccardSimilarity = this.jaccardSimilarity(layer1s, layer3s);
            results.put(neighbor, jaccardSimilarity);
            accessed.add(neighbor);
        }
        return results;
    }
}

