/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.optimize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.traversal.optimize.QueryHolder;
import org.apache.hugegraph.traversal.optimize.TraversalUtil;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.slf4j.Logger;

public class HugeVertexStep<E extends Element>
extends VertexStep<E>
implements QueryHolder {
    private static final long serialVersionUID = -7850636388424382454L;
    private static final Logger LOG = Log.logger(HugeVertexStep.class);
    private final List<HasContainer> hasContainers = new ArrayList<HasContainer>();
    private final Query queryInfo = new Query(null);
    private Iterator<E> iterator = QueryResults.emptyIterator();

    public HugeVertexStep(VertexStep<E> originVertexStep) {
        super(originVertexStep.getTraversal(), originVertexStep.getReturnClass(), originVertexStep.getDirection(), originVertexStep.getEdgeLabels());
        originVertexStep.getLabels().forEach(arg_0 -> ((HugeVertexStep)this).addLabel(arg_0));
    }

    protected Iterator<E> flatMap(Traverser.Admin<Vertex> traverser) {
        boolean queryVertex = this.returnsVertex();
        boolean queryEdge = this.returnsEdge();
        assert (queryVertex || queryEdge);
        if (queryVertex) {
            this.iterator = this.vertices(traverser);
        } else {
            assert (queryEdge);
            this.iterator = this.edges(traverser);
        }
        return this.iterator;
    }

    private Iterator<Vertex> vertices(Traverser.Admin<Vertex> traverser) {
        Iterator<Edge> edges = this.edges(traverser);
        Iterator<Vertex> vertices = this.queryAdjacentVertices(edges);
        if (LOG.isDebugEnabled()) {
            Vertex vertex = (Vertex)traverser.get();
            LOG.debug("HugeVertexStep.vertices(): is there adjacent vertices of {}: {}, has={}", new Object[]{vertex.id(), vertices.hasNext(), this.hasContainers});
        }
        return vertices;
    }

    private Iterator<Edge> edges(Traverser.Admin<Vertex> traverser) {
        ConditionQuery query = this.constructEdgesQuery(traverser);
        return this.queryEdges(query);
    }

    protected Iterator<Vertex> queryAdjacentVertices(Iterator<Edge> edges) {
        HugeGraph graph = TraversalUtil.getGraph(this);
        Iterator<Vertex> vertices = graph.adjacentVertices(edges);
        if (!this.withVertexCondition()) {
            return vertices;
        }
        return TraversalUtil.filterResult(this.hasContainers, vertices);
    }

    protected Iterator<Edge> queryEdges(Query query) {
        HugeGraph graph = TraversalUtil.getGraph(this);
        Iterator<Edge> edges = graph.edges(query);
        if (!this.withEdgeCondition()) {
            return edges;
        }
        return TraversalUtil.filterResult(this.hasContainers, edges);
    }

    protected ConditionQuery constructEdgesQuery(Traverser.Admin<Vertex> traverser) {
        HugeGraph graph = TraversalUtil.getGraph(this);
        boolean withEdgeCond = this.withEdgeCondition();
        boolean withVertexCond = this.withVertexCondition();
        Id vertex = (Id)((Vertex)traverser.get()).id();
        Directions direction = Directions.convert(this.getDirection());
        Id[] edgeLabels = graph.mapElName2Id(this.getEdgeLabels());
        LOG.debug("HugeVertexStep.edges(): vertex={}, direction={}, edgeLabels={}, has={}", new Object[]{vertex, direction, edgeLabels, this.hasContainers});
        ConditionQuery query = GraphTransaction.constructEdgesQuery(vertex, direction, edgeLabels);
        if (withEdgeCond && edgeLabels.length == 1) {
            TraversalUtil.fillConditionQuery(query, this.hasContainers, graph);
            if (!GraphTransaction.matchPartialEdgeSortKeys(query, graph)) {
                query.resetUserpropConditions();
            } else if (GraphTransaction.matchFullEdgeSortKeys(query, graph)) {
                withEdgeCond = false;
            } else assert (!query.userpropKeys().isEmpty());
        }
        if (query.idsSize() > 0) {
            query.resetConditions();
            LOG.warn("It's not recommended to query by has(id)");
        }
        if (withEdgeCond || withVertexCond) {
            E.checkArgument((!this.queryInfo().paging() ? 1 : 0) != 0, (String)"Can't query by paging and filtering", (Object[])new Object[0]);
            this.queryInfo().limit(Long.MAX_VALUE);
        }
        query = (ConditionQuery)this.injectQueryInfo(query);
        return query;
    }

    protected boolean withVertexCondition() {
        return this.returnsVertex() && !this.hasContainers.isEmpty();
    }

    protected boolean withEdgeCondition() {
        return this.returnsEdge() && !this.hasContainers.isEmpty();
    }

    public String toString() {
        if (this.hasContainers.isEmpty()) {
            return super.toString();
        }
        return StringFactory.stepString((Step)this, (Object[])new Object[]{this.getDirection(), Arrays.asList(this.getEdgeLabels()), this.getReturnClass().getSimpleName(), this.hasContainers});
    }

    public List<HasContainer> getHasContainers() {
        return Collections.unmodifiableList(this.hasContainers);
    }

    public void addHasContainer(HasContainer has) {
        if ("~page".equals(has.getKey())) {
            this.setPage((String)has.getValue());
            return;
        }
        this.hasContainers.add(has);
    }

    @Override
    public Query queryInfo() {
        return this.queryInfo;
    }

    @Override
    public Iterator<?> lastTimeResults() {
        return this.iterator;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HugeVertexStep)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        HugeVertexStep other = (HugeVertexStep)obj;
        return this.hasContainers.equals(other.hasContainers) && this.queryInfo.equals(other.queryInfo) && this.iterator.equals(other.iterator);
    }

    public int hashCode() {
        return super.hashCode() ^ this.queryInfo.hashCode() ^ this.hasContainers.hashCode();
    }
}

