/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class Reflection {
    private static final Logger LOG = Log.logger(Reflection.class);
    private static final Class<?> REFLECTION_CLAZZ;
    private static final Method REGISTER_FILEDS_TO_FILTER_METHOD;
    private static final Method REGISTER_METHODS_TO_FILTER_METHOD;
    public static final String JDK_INTERNAL_REFLECT_REFLECTION = "jdk.internal.reflect.Reflection";
    public static final String SUN_REFLECT_REFLECTION = "sun.reflect.Reflection";

    public static void registerFieldsToFilter(Class<?> containingClass, String ... fieldNames) {
        if (REGISTER_FILEDS_TO_FILTER_METHOD == null) {
            throw new NotSupportException("Reflection.registerFieldsToFilter()");
        }
        try {
            REGISTER_FILEDS_TO_FILTER_METHOD.setAccessible(true);
            REGISTER_FILEDS_TO_FILTER_METHOD.invoke(REFLECTION_CLAZZ, containingClass, fieldNames);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new HugeException("Failed to register class '%s' fields to filter: %s", containingClass, Arrays.toString(fieldNames));
        }
    }

    public static void registerMethodsToFilter(Class<?> containingClass, String ... methodNames) {
        if (REGISTER_METHODS_TO_FILTER_METHOD == null) {
            throw new NotSupportException("Reflection.registerMethodsToFilterMethod()");
        }
        try {
            REGISTER_METHODS_TO_FILTER_METHOD.setAccessible(true);
            REGISTER_METHODS_TO_FILTER_METHOD.invoke(REFLECTION_CLAZZ, containingClass, methodNames);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new HugeException("Failed to register class '%s' methods to filter: %s", containingClass, Arrays.toString(methodNames));
        }
    }

    public static Class<?> loadClass(String clazz) {
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new HugeException(e.getMessage(), e);
        }
    }

    static {
        Method registerFieldsToFilterMethodTemp = null;
        Method registerMethodsToFilterMethodTemp = null;
        Class<?> reflectionClazzTemp = null;
        try {
            reflectionClazzTemp = Class.forName(JDK_INTERNAL_REFLECT_REFLECTION);
        }
        catch (ClassNotFoundException e) {
            try {
                reflectionClazzTemp = Class.forName(SUN_REFLECT_REFLECTION);
            }
            catch (ClassNotFoundException ex) {
                LOG.error("Can't find Reflection class", (Throwable)ex);
            }
        }
        REFLECTION_CLAZZ = reflectionClazzTemp;
        if (REFLECTION_CLAZZ != null) {
            try {
                registerFieldsToFilterMethodTemp = REFLECTION_CLAZZ.getMethod("registerFieldsToFilter", Class.class, String[].class);
            }
            catch (Throwable e) {
                LOG.error("Can't find registerFieldsToFilter method", e);
            }
            try {
                registerMethodsToFilterMethodTemp = REFLECTION_CLAZZ.getMethod("registerMethodsToFilter", Class.class, String[].class);
            }
            catch (NoSuchMethodException e) {
                LOG.error("Can't find registerMethodsToFilter method", (Throwable)e);
            }
        }
        REGISTER_FILEDS_TO_FILTER_METHOD = registerFieldsToFilterMethodTemp;
        REGISTER_METHODS_TO_FILTER_METHOD = registerMethodsToFilterMethodTemp;
    }
}

