/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import org.caffinitas.ohc.OHCacheBuilder;
import org.caffinitas.ohc.linked.HashEntries;
import org.caffinitas.ohc.linked.LongArrayList;
import org.caffinitas.ohc.linked.OffHeapLinkedMap;

class OffHeapLinkedLRUMap
extends OffHeapLinkedMap {
    private long lruHead;
    private long lruTail;
    private long freeCapacity;
    private long capacity;

    OffHeapLinkedLRUMap(OHCacheBuilder builder, long freeCapacity) {
        super(builder);
        this.freeCapacity = freeCapacity;
        this.capacity = freeCapacity;
    }

    @Override
    void addToLruAndUpdateCapacity(long hashEntryAdr) {
        long h = this.lruHead;
        HashEntries.setLRUNext(hashEntryAdr, h);
        if (h != 0L) {
            HashEntries.setLRUPrev(h, hashEntryAdr);
        }
        HashEntries.setLRUPrev(hashEntryAdr, 0L);
        this.lruHead = hashEntryAdr;
        if (this.lruTail == 0L) {
            this.lruTail = hashEntryAdr;
        }
        this.freeCapacity -= HashEntries.getAllocLen(hashEntryAdr);
    }

    @Override
    void removeFromLruAndUpdateCapacity(long hashEntryAdr) {
        long next = HashEntries.getLRUNext(hashEntryAdr);
        long prev = HashEntries.getLRUPrev(hashEntryAdr);
        if (this.lruHead == hashEntryAdr) {
            this.lruHead = next;
        }
        if (this.lruTail == hashEntryAdr) {
            this.lruTail = prev;
        }
        if (next != 0L) {
            HashEntries.setLRUPrev(next, prev);
        }
        if (prev != 0L) {
            HashEntries.setLRUNext(prev, next);
        }
        this.freeCapacity += HashEntries.getAllocLen(hashEntryAdr);
    }

    @Override
    void replaceSentinelInLruAndUpdateCapacity(long hashEntryAdr, long newHashEntryAdr, long bytes) {
        long next = HashEntries.getLRUNext(hashEntryAdr);
        long prev = HashEntries.getLRUPrev(hashEntryAdr);
        HashEntries.setLRUNext(newHashEntryAdr, next);
        HashEntries.setLRUPrev(newHashEntryAdr, prev);
        if (this.lruHead == hashEntryAdr) {
            this.lruHead = newHashEntryAdr;
        }
        if (this.lruTail == hashEntryAdr) {
            this.lruTail = newHashEntryAdr;
        }
        if (next != 0L) {
            HashEntries.setLRUPrev(next, newHashEntryAdr);
        }
        if (prev != 0L) {
            HashEntries.setLRUNext(prev, newHashEntryAdr);
        }
        this.freeCapacity -= bytes;
    }

    @Override
    void clearLruAndCapacity() {
        this.lruTail = 0L;
        this.lruHead = 0L;
        this.freeCapacity = this.capacity;
    }

    @Override
    void touch(long hashEntryAdr) {
        long head = this.lruHead;
        if (head == hashEntryAdr) {
            return;
        }
        long next = HashEntries.getAndSetLRUNext(hashEntryAdr, head);
        long prev = HashEntries.getAndSetLRUPrev(hashEntryAdr, 0L);
        long tail = this.lruTail;
        if (tail == hashEntryAdr) {
            this.lruTail = prev == 0L ? hashEntryAdr : prev;
        } else if (tail == 0L) {
            this.lruTail = hashEntryAdr;
        }
        if (next != 0L) {
            HashEntries.setLRUPrev(next, prev);
        }
        if (prev != 0L) {
            HashEntries.setLRUNext(prev, next);
        }
        if (head != 0L) {
            HashEntries.setLRUPrev(head, hashEntryAdr);
        }
        this.lruHead = hashEntryAdr;
    }

    @Override
    long freeCapacity() {
        return this.freeCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateFreeCapacity(long diff) {
        boolean wasFirst = this.lock();
        try {
            this.freeCapacity += diff;
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    @Override
    LongArrayList ensureFreeSpaceForNewEntry(long bytes) {
        long eldestHashAdr;
        if (this.freeCapacity < bytes) {
            this.removeExpired();
        }
        LongArrayList derefList = null;
        while (this.freeCapacity < bytes && (eldestHashAdr = this.removeEldest()) != 0L) {
            if (derefList == null) {
                derefList = new LongArrayList();
            }
            derefList.add(eldestHashAdr);
        }
        return derefList;
    }

    @Override
    boolean hasFreeSpaceForNewEntry(long bytes) {
        return this.freeCapacity >= bytes;
    }

    private long removeEldest() {
        long hashEntryAdr = this.lruTail;
        if (hashEntryAdr == 0L) {
            return 0L;
        }
        this.removeInternal(hashEntryAdr, -1L, true);
        --this.size;
        ++this.evictedEntries;
        return hashEntryAdr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long[] hotN(int n) {
        boolean wasFirst = this.lock();
        try {
            long[] r = new long[n];
            int i = 0;
            long hashEntryAdr = this.lruHead;
            while (hashEntryAdr != 0L && i < n) {
                r[i++] = hashEntryAdr;
                HashEntries.reference(hashEntryAdr);
                hashEntryAdr = HashEntries.getLRUNext(hashEntryAdr);
            }
            long[] lArray = r;
            return lArray;
        }
        finally {
            this.unlock(wasFirst);
        }
    }
}

