/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import org.gridkit.jvmtool.event.SimpleTagCollection;
import org.gridkit.jvmtool.event.TagCollection;
import org.gridkit.jvmtool.stacktrace.CounterArray;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.StackTraceReader;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;

public class ThreadRecord
implements ThreadSnapshot {
    private long threadId = -1L;
    private String threadName;
    private long timestamp = -1L;
    private StackFrameList stackTrace;
    private Thread.State threadState;

    public ThreadRecord() {
    }

    public ThreadRecord(StackFrameList trace) {
        this.stackTrace = trace;
    }

    public ThreadRecord(StackFrameList trace, Thread.State state) {
        this.stackTrace = trace;
        this.threadState = state;
    }

    public void reset() {
        this.threadId = -1L;
        this.threadName = null;
        this.timestamp = -1L;
        this.stackTrace = null;
        this.threadState = null;
    }

    public void load(StackTraceReader reader) {
        this.reset();
        this.threadId = reader.getThreadId();
        this.threadName = reader.getThreadName();
        this.stackTrace = reader.getStackTrace();
        this.threadState = reader.getThreadState();
    }

    @Override
    public long threadId() {
        return this.threadId;
    }

    @Override
    public String threadName() {
        return this.threadName;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public StackFrameList stackTrace() {
        return this.stackTrace;
    }

    @Override
    public Thread.State threadState() {
        return this.threadState;
    }

    @Override
    public CounterCollection counters() {
        return CounterArray.EMPTY;
    }

    @Override
    public TagCollection tags() {
        return SimpleTagCollection.EMPTY;
    }
}

