/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.recognition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apdplat.word.util.AutoDetector;
import org.apdplat.word.util.ResourceLoader;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Quantifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(Quantifier.class);
    private static final Set<Character> quantifiers = new HashSet<Character>();

    public static void reload() {
        AutoDetector.loadAndWatch(new ResourceLoader(){

            @Override
            public void clear() {
                quantifiers.clear();
            }

            @Override
            public void load(List<String> list) {
                LOGGER.info("\u521d\u59cb\u5316\u6570\u91cf\u8bcd");
                for (String string : list) {
                    if (string.length() == 1) {
                        char c = string.charAt(0);
                        if (quantifiers.contains(Character.valueOf(c))) {
                            LOGGER.info("\u914d\u7f6e\u6587\u4ef6\u6709\u91cd\u590d\u9879\uff1a" + string);
                            continue;
                        }
                        quantifiers.add(Character.valueOf(c));
                        continue;
                    }
                    LOGGER.info("\u5ffd\u7565\u4e0d\u5408\u6cd5\u6570\u91cf\u8bcd\uff1a" + string);
                }
                LOGGER.info("\u6570\u91cf\u8bcd\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u6570\u91cf\u8bcd\u4e2a\u6570\uff1a" + quantifiers.size());
            }

            @Override
            public void add(String string) {
                if (string.length() == 1) {
                    char c = string.charAt(0);
                    quantifiers.add(Character.valueOf(c));
                } else {
                    LOGGER.info("\u5ffd\u7565\u4e0d\u5408\u6cd5\u6570\u91cf\u8bcd\uff1a" + string);
                }
            }

            @Override
            public void remove(String string) {
                if (string.length() == 1) {
                    char c = string.charAt(0);
                    quantifiers.remove(Character.valueOf(c));
                } else {
                    LOGGER.info("\u5ffd\u7565\u4e0d\u5408\u6cd5\u6570\u91cf\u8bcd\uff1a" + string);
                }
            }
        }, WordConfTools.get("quantifier.path", "classpath:quantifier.txt"));
    }

    public static boolean is(char c) {
        return quantifiers.contains(Character.valueOf(c));
    }

    public static void main(String[] stringArray) {
        int n = 1;
        for (char c : quantifiers) {
            LOGGER.info(n++ + " : " + c);
        }
    }

    static {
        Quantifier.reload();
    }
}

