/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation;

import java.util.HashMap;
import java.util.Map;
import org.apdplat.word.segmentation.Segmentation;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentationFactory.class);
    private static final Map<String, Segmentation> pool = new HashMap<String, Segmentation>();

    private SegmentationFactory() {
    }

    public static synchronized Segmentation getSegmentation(SegmentationAlgorithm segmentationAlgorithm) {
        String string = "org.apdplat.word.segmentation.impl." + segmentationAlgorithm.name();
        Segmentation segmentation = pool.get(string);
        if (segmentation == null) {
            LOGGER.info("\u6784\u9020\u5206\u8bcd\u5b9e\u73b0\u7c7b\uff1a" + string);
            try {
                segmentation = (Segmentation)Class.forName(string).newInstance();
                pool.put(string, segmentation);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                LOGGER.info("\u6784\u9020\u5206\u8bcd\u5b9e\u73b0\u7c7b\u5931\u8d25\uff1a", (Throwable)reflectiveOperationException);
            }
        }
        return segmentation;
    }
}

