/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation.impl;

import java.util.List;
import java.util.Map;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.segmentation.impl.AbstractSegmentation;

public class BidirectionalMaximumMinimumMatching
extends AbstractSegmentation {
    private static final AbstractSegmentation MM = (AbstractSegmentation)SegmentationFactory.getSegmentation(SegmentationAlgorithm.MaximumMatching);
    private static final AbstractSegmentation RMM = (AbstractSegmentation)SegmentationFactory.getSegmentation(SegmentationAlgorithm.ReverseMaximumMatching);
    private static final AbstractSegmentation MIM = (AbstractSegmentation)SegmentationFactory.getSegmentation(SegmentationAlgorithm.MinimumMatching);
    private static final AbstractSegmentation RMIM = (AbstractSegmentation)SegmentationFactory.getSegmentation(SegmentationAlgorithm.ReverseMinimumMatching);

    @Override
    public SegmentationAlgorithm getSegmentationAlgorithm() {
        return SegmentationAlgorithm.BidirectionalMaximumMinimumMatching;
    }

    @Override
    public List<Word> segImpl(String string) {
        List<Word> list = RMM.seg(string);
        if (!this.ngramEnabled()) {
            return list;
        }
        List<Word> list2 = MM.seg(string);
        List<Word> list3 = RMIM.seg(string);
        List<Word> list4 = MIM.seg(string);
        if (list.size() == list2.size() && list.size() == list3.size() && list.size() == list4.size() && list.equals(list2) && list.equals(list3) && list.equals(list4)) {
            return list;
        }
        Map<List<Word>, Float> map = this.ngram(list, list2, list3, list4);
        float f = map.get(list).floatValue();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u9006\u5411\u6700\u5927\u5339\u914d\uff1a" + list.toString() + " : ngram\u5206\u503c=" + f);
        }
        List<Word> list5 = list;
        float f2 = f;
        f = map.get(list2).floatValue();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u6b63\u5411\u6700\u5927\u5339\u914d\uff1a" + list2.toString() + " : ngram\u5206\u503c=" + f);
        }
        if (f > f2) {
            list5 = list2;
            f2 = f;
        }
        f = map.get(list3).floatValue();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u9006\u5411\u6700\u5c0f\u5339\u914d\uff1a" + list3.toString() + " : ngram\u5206\u503c=" + f);
        }
        if (f > f2) {
            list5 = list3;
            f2 = f;
        }
        f = map.get(list4).floatValue();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u6b63\u5411\u6700\u5c0f\u5339\u914d\uff1a" + list4.toString() + " : ngram\u5206\u503c=" + f);
        }
        if (f > f2) {
            list5 = list4;
            f2 = f;
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u6700\u5927\u5206\u503c\uff1a" + f2 + ", \u6d88\u6b67\u7ed3\u679c\uff1a" + list5);
        }
        return list5;
    }

    public static void main(String[] stringArray) {
        String string = "Hadoop\u662f\u5927\u6570\u636e\u7684\u6838\u5fc3\u6280\u672f\u4e4b\u4e00\uff0c\u800cNutch\u96c6Hadoop\u4e4b\u5927\u6210\uff0c\u662fHadoop\u7684\u6e90\u5934\u3002\u5b66\u4e60Hadoop\uff0c\u6ca1\u6709\u6570\u636e\u600e\u4e48\u529e\uff1f\u7528Nutch\u6293\uff01\u5b66\u4e86Hadoop\u7684Map Reduce\u4ee5\u53caHDFS\uff0c\u6ca1\u6709\u5b9e\u7528\u6848\u4f8b\u600e\u4e48\u529e\uff1f\u5b66\u4e60Nutch\uff01Nutch\u7684\u5f88\u591a\u4ee3\u7801\u662f\u7528Map Reduce\u548cHDFS\u5199\u7684\uff0c\u54ea\u91cc\u8fd8\u80fd\u627e\u5230\u6bd4Nutch\u66f4\u597d\u7684Hadoop\u5e94\u7528\u6848\u4f8b\u5462\uff1f";
        if (stringArray != null && stringArray.length == 1) {
            string = stringArray[0];
        }
        BidirectionalMaximumMinimumMatching bidirectionalMaximumMinimumMatching = new BidirectionalMaximumMinimumMatching();
        System.out.println(bidirectionalMaximumMinimumMatching.seg(string).toString());
    }
}

