/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.solr;

import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.apdplat.word.lucene.ChineseWordTokenizer;
import org.apdplat.word.segmentation.Segmentation;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChineseWordTokenizerFactory
extends TokenizerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChineseWordTokenizerFactory.class);
    private Segmentation segmentation = null;

    public ChineseWordTokenizerFactory(Map<String, String> map) {
        super(map);
        if (map != null) {
            String string = map.get("conf");
            if (string != null) {
                WordConfTools.forceOverride(string);
            } else {
                LOGGER.info("\u6ca1\u6709\u6307\u5b9aconf\u53c2\u6570");
            }
            String string2 = map.get("segAlgorithm");
            if (string2 != null) {
                try {
                    SegmentationAlgorithm segmentationAlgorithm = SegmentationAlgorithm.valueOf(string2);
                    this.segmentation = SegmentationFactory.getSegmentation(segmentationAlgorithm);
                    LOGGER.info("\u4f7f\u7528\u6307\u5b9a\u5206\u8bcd\u7b97\u6cd5\uff1a" + string2);
                }
                catch (Exception exception) {
                    LOGGER.error("\u53c2\u6570segAlgorithm\u6307\u5b9a\u7684\u503c\u9519\u8bef\uff1a" + string2);
                    LOGGER.error("\u53c2\u6570segAlgorithm\u53ef\u6307\u5b9a\u7684\u503c\u6709\uff1a");
                    for (SegmentationAlgorithm segmentationAlgorithm : SegmentationAlgorithm.values()) {
                        LOGGER.error("\t" + segmentationAlgorithm.name());
                    }
                }
            } else {
                LOGGER.info("\u6ca1\u6709\u6307\u5b9asegAlgorithm\u53c2\u6570");
            }
        }
        if (this.segmentation == null) {
            this.segmentation = SegmentationFactory.getSegmentation(SegmentationAlgorithm.BidirectionalMaximumMatching);
            LOGGER.info("\u4f7f\u7528\u9ed8\u8ba4\u5206\u8bcd\u7b97\u6cd5\uff1a" + (Object)((Object)SegmentationAlgorithm.BidirectionalMaximumMatching));
        }
    }

    public Tokenizer create(AttributeFactory attributeFactory) {
        return new ChineseWordTokenizer(this.segmentation);
    }
}

