/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.controller;

import com.alipay.sofa.jraft.option.RpcOptions;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.hugegraph.store.HgStoreEngine;
import org.apache.hugegraph.store.PartitionEngine;
import org.apache.hugegraph.store.node.entry.PartitionRequest;
import org.apache.hugegraph.store.node.entry.RestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/raft"})
public class RaftAPI {
    private static final Logger log = LoggerFactory.getLogger(RaftAPI.class);

    @PostMapping(value={"/options"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public RestResult options(@RequestBody PartitionRequest body, HttpServletRequest request) {
        RestResult result = new RestResult();
        try {
            if (body.getId() == null) {
                result.setState("ERR");
                result.setMessage("partition id could not be null");
                return result;
            }
            PartitionEngine pe = HgStoreEngine.getInstance().getPartitionEngine(body.getId());
            if (pe == null) {
                result.setState("ERR");
                result.setMessage("partition engine is null!");
                return result;
            }
            RpcOptions options = pe.getRaftGroupService().getNodeOptions();
            result.setData((Serializable)((Object)options.toString()));
            result.setState("OK");
        }
        catch (Exception e) {
            result.setState("ERR");
            result.setMessage(e.getMessage());
        }
        return result;
    }
}

