/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc;

import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hugegraph.rocksdb.access.ScanIterator;
import org.apache.hugegraph.store.buffer.ByteBufferAllocator;
import org.apache.hugegraph.store.buffer.KVByteBuffer;
import org.apache.hugegraph.store.grpc.stream.KvStream;
import org.apache.hugegraph.store.grpc.stream.ScanQueryRequest;
import org.apache.hugegraph.store.grpc.stream.ScanStreamBatchReq;
import org.apache.hugegraph.store.node.grpc.HgStoreWrapperEx;
import org.apache.hugegraph.store.node.grpc.ParallelScanIterator;
import org.apache.hugegraph.store.node.grpc.ScanBatchResponse;
import org.apache.hugegraph.store.node.grpc.ScanBatchResponseFactory;
import org.apache.hugegraph.store.node.grpc.ScanUtil;
import org.apache.hugegraph.store.node.util.HgGrpc;
import org.apache.hugegraph.store.node.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanBatchResponse
implements StreamObserver<ScanStreamBatchReq> {
    private static final Logger log = LoggerFactory.getLogger(ScanBatchResponse.class);
    static ByteBufferAllocator bfAllocator = new ByteBufferAllocator(ParallelScanIterator.maxBodySize * 3 / 2, 1000);
    static ByteBufferAllocator alloc = new ByteBufferAllocator(ParallelScanIterator.maxBodySize * 3 / 2, 1000);
    private final int maxInFlightCount = PropertyUtil.getInt((String)"app.scan.stream.inflight", (int)16);
    private final StreamObserver<KvStream> sender;
    private final int activeTimeout = PropertyUtil.getInt((String)"app.scan.stream.timeout", (int)60);
    private final HgStoreWrapperEx wrapper;
    private final ThreadPoolExecutor executor;
    private final Object stateLock = new Object();
    private final Lock iteratorLock = new ReentrantLock();
    private ScanIterator iterator;
    private volatile int seqNo;
    private volatile int clientSeqNo;
    private volatile long count;
    private volatile long limit;
    private ScanQueryRequest query;
    private long activeTime;
    private volatile State state;

    public ScanBatchResponse(StreamObserver<KvStream> response, HgStoreWrapperEx wrapper, ThreadPoolExecutor executor) {
        this.sender = response;
        this.wrapper = wrapper;
        this.executor = executor;
        this.iterator = null;
        this.seqNo = 1;
        this.state = State.IDLE;
        this.activeTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(ScanStreamBatchReq request) {
        switch (1.$SwitchMap$org$apache$hugegraph$store$grpc$stream$ScanStreamBatchReq$QueryCase[request.getQueryCase().ordinal()]) {
            case 1: {
                this.executor.execute(() -> this.startQuery(request.getHeader().getGraph(), request.getQueryRequest()));
                break;
            }
            case 2: {
                this.clientSeqNo = request.getReceiptRequest().getTimes();
                if (this.seqNo - this.clientSeqNo >= this.maxInFlightCount) break;
                Object object = this.stateLock;
                synchronized (object) {
                    if (this.state == State.IDLE) {
                        this.state = State.DOING;
                        this.executor.execute(() -> this.sendEntries());
                    } else if (this.state == State.DONE) {
                        this.sendNoDataEntries();
                    }
                    break;
                }
            }
            case 3: {
                this.closeQuery();
                break;
            }
            default: {
                this.sender.onError((Throwable)HgGrpc.toErr((String)("Unsupported sub-request: [ " + String.valueOf(request) + " ]")));
            }
        }
    }

    public void onError(Throwable t) {
        log.error("onError ", t);
        this.closeQuery();
    }

    public void onCompleted() {
        this.closeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startQuery(String graphName, ScanQueryRequest request) {
        this.query = request;
        this.limit = request.getLimit();
        this.count = 0L;
        this.iterator = ScanUtil.getParallelIterator((String)graphName, (ScanQueryRequest)request, (HgStoreWrapperEx)this.wrapper, (ThreadPoolExecutor)this.executor);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.IDLE) {
                this.state = State.DOING;
                this.executor.execute(() -> this.sendEntries());
            }
        }
    }

    private void closeQuery() {
        this.setStateDone();
        try {
            this.closeIter();
            this.sender.onCompleted();
        }
        catch (Exception e) {
            log.error("exception ", (Throwable)e);
        }
        int active = ScanBatchResponseFactory.getInstance().removeStreamObserver((StreamObserver)this);
        log.info("ScanBatchResponse closeQuery, active count is {}", (Object)active);
    }

    private void closeIter() {
        try {
            if (this.iterator != null) {
                this.iterator.close();
                this.iterator = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEntries() {
        if (this.state == State.DONE || this.iterator == null) {
            this.setStateIdle();
            return;
        }
        this.iteratorLock.lock();
        try {
            if (this.state == State.DONE || this.iterator == null) {
                this.setStateIdle();
                return;
            }
            KvStream.Builder dataBuilder = KvStream.newBuilder().setVersion(1);
            while (this.state != State.DONE && this.iterator.hasNext() && this.seqNo - this.clientSeqNo < this.maxInFlightCount && this.count < this.limit) {
                KVByteBuffer buffer = new KVByteBuffer(alloc.get());
                List dataList = (List)this.iterator.next();
                dataList.forEach(kv -> {
                    kv.write(buffer);
                    ++this.count;
                });
                dataBuilder.setStream(buffer.flip().getBuffer());
                dataBuilder.setSeqNo(this.seqNo++);
                dataBuilder.complete(e -> alloc.release(buffer.getBuffer()));
                this.sender.onNext((Object)dataBuilder.build());
                this.activeTime = System.currentTimeMillis();
            }
            if (!this.iterator.hasNext() || this.count >= this.limit || this.state == State.DONE) {
                this.closeIter();
                this.sender.onNext((Object)KvStream.newBuilder().setOver(true).build());
                this.setStateDone();
            } else {
                this.setStateIdle();
            }
        }
        catch (Throwable e2) {
            if (this.state != State.DONE) {
                log.error(" send data exception: ", e2);
                this.setStateIdle();
                if (this.sender != null) {
                    try {
                        this.sender.onError(e2);
                    }
                    catch (Exception ex) {
                        log.warn("Error when call sender.onError {}", (Object)e2.getMessage());
                    }
                }
            }
        }
        finally {
            this.iteratorLock.unlock();
        }
    }

    private void sendNoDataEntries() {
        try {
            this.sender.onNext((Object)KvStream.newBuilder().setOver(true).build());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State setStateDone() {
        Object object = this.stateLock;
        synchronized (object) {
            this.state = State.DONE;
        }
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State setStateIdle() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != State.DONE) {
                this.state = State.IDLE;
            }
        }
        return this.state;
    }

    public void checkActiveTimeout() {
        if (System.currentTimeMillis() - this.activeTime > (long)this.activeTimeout * 1000L) {
            log.warn("The stream is not closed, and the timeout is forced to close");
            this.closeQuery();
        }
    }
}

