/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc.query.stages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.store.business.itrv2.TypeTransIterator;
import org.apache.hugegraph.store.business.itrv2.io.SortShuffleSerializer;
import org.apache.hugegraph.store.node.grpc.query.MultiKeyComparator;
import org.apache.hugegraph.store.node.grpc.query.QueryStage;
import org.apache.hugegraph.store.node.grpc.query.QueryUtil;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResult;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResultType;
import org.apache.hugegraph.store.query.BaseElementComparator;
import org.apache.hugegraph.store.util.MultiKv;
import org.apache.hugegraph.store.util.SortShuffle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderByStage
implements QueryStage {
    private static final Logger log = LoggerFactory.getLogger(OrderByStage.class);
    private SortShuffle sortShuffle;
    private Iterator iterator;
    private boolean isAsc;
    private PipelineResultType resultType = PipelineResultType.HG_ELEMENT;

    public void init(Object ... objects) {
        List orderBys = QueryUtil.fromStringBytes((List)((List)objects[0]));
        List groupBys = QueryUtil.fromStringBytes((List)((List)objects[1]));
        this.isAsc = (Boolean)objects[3];
        if (((Boolean)objects[2]).booleanValue()) {
            if (orderBys == null) {
                this.sortShuffle = new SortShuffle(MultiKv::compareTo, SortShuffleSerializer.ofMultiKvSerializer());
            } else {
                ArrayList<Integer> orders = new ArrayList<Integer>();
                for (Id id : orderBys) {
                    orders.add(groupBys.indexOf(id));
                }
                this.sortShuffle = new SortShuffle((Comparator)new MultiKeyComparator(orders), SortShuffleSerializer.ofMultiKvSerializer());
            }
            this.resultType = PipelineResultType.MKV;
        } else {
            this.sortShuffle = new SortShuffle((Comparator)new BaseElementComparator(orderBys, this.isAsc), SortShuffleSerializer.ofBaseElementSerializer());
            this.resultType = PipelineResultType.HG_ELEMENT;
        }
    }

    public boolean isIterator() {
        return true;
    }

    public Iterator<PipelineResult> handleIterator(PipelineResult result) {
        if (result == null) {
            return null;
        }
        if (!result.isEmpty()) {
            try {
                if (result.getResultType() == PipelineResultType.MKV) {
                    this.sortShuffle.append((Serializable)result.getKv());
                } else if (result.getResultType() == PipelineResultType.HG_ELEMENT) {
                    this.sortShuffle.append((Serializable)result.getElement());
                }
                return null;
            }
            catch (Exception e) {
                log.info("GROUP_BY_STAGE, append: ", (Throwable)e);
            }
        } else {
            try {
                this.sortShuffle.finish();
                this.iterator = this.sortShuffle.getIterator();
            }
            catch (Exception e) {
                log.error("GROUP_BY_STAGE:", (Throwable)e);
            }
        }
        return new TypeTransIterator((Iterator)new /* Unavailable Anonymous Inner Class!! */, r -> r, () -> PipelineResult.EMPTY).toIterator();
    }

    public String getName() {
        return "ORDER_BY_STAGE";
    }

    public void close() {
        this.sortShuffle.close();
    }
}

