/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.metrics;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.hugegraph.store.node.metrics.ProcFileHandler;

class ProcFileHandler {
    private static final long CACHE_DURATION_MS = 100L;
    private static final Map<String, ProcFileHandler> handlerInstances = new HashMap();
    private static final Object handlerLock = new Object();
    private static final Map<Path, List<String>> cachedContent = new HashMap();
    private static final Object contentLock = new Object();
    private static final Path PROC_BASE_PATH = Paths.get("/proc", "self");
    private final Path filePath;
    private final boolean isOSSupported;
    private long lastReadTimestamp = -1L;

    private ProcFileHandler(String entry) {
        this(PROC_BASE_PATH, entry, false);
    }

    ProcFileHandler(Path base, String entry) {
        this(base, entry, true);
    }

    private ProcFileHandler(Path base, String entry, boolean forceOSSupport) {
        Objects.requireNonNull(base);
        Objects.requireNonNull(entry);
        this.filePath = base.resolve(entry);
        this.isOSSupported = forceOSSupport || System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("linux");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ProcFileHandler getInstance(String key) {
        Objects.requireNonNull(key);
        Object object = handlerLock;
        synchronized (object) {
            ProcFileHandler handler = (ProcFileHandler)handlerInstances.get(key);
            if (handler == null) {
                handler = new ProcFileHandler(key);
                handlerInstances.put(key, handler);
            }
            return handler;
        }
    }

    Path getFilePath() {
        return this.filePath;
    }

    ReadResult readFile() throws IOException {
        return this.readFile(this.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReadResult readFile(long currentTimeMillis) throws IOException {
        Object object = contentLock;
        synchronized (object) {
            ReadResult readResult;
            Path key = this.getFilePath().getFileName();
            if (this.lastReadTimestamp == -1L || this.lastReadTimestamp + 100L < currentTimeMillis) {
                List lines = this.readFilePath(this.filePath);
                this.cacheContent(key, lines);
                this.lastReadTimestamp = this.currentTimeMillis();
                readResult = new ReadResult(lines, this.lastReadTimestamp);
            } else {
                readResult = new ReadResult((List)cachedContent.get(key), this.lastReadTimestamp);
            }
            return readResult;
        }
    }

    List<String> readFilePath(Path path) throws IOException {
        Objects.requireNonNull(path);
        if (!this.isOSSupported) {
            return Collections.emptyList();
        }
        return Files.readAllLines(path);
    }

    void cacheContent(Path key, List<String> lines) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(lines);
        cachedContent.put(key, lines);
    }

    long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

