/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hugegraph.rocksdb.access.RocksDBFactory;
import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.store.HgStoreEngine;
import org.apache.hugegraph.store.node.metrics.RocksDBMetrics;
import org.apache.hugegraph.store.node.metrics.RocksDBMetricsConst;
import org.apache.hugegraph.store.node.util.HgAssert;
import org.rocksdb.HistogramType;
import org.rocksdb.TickerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RocksDBMetrics {
    private static final Logger log = LoggerFactory.getLogger(RocksDBMetrics.class);
    private static final RocksDBFactory rocksDBFactory = RocksDBFactory.getInstance();
    private static final AtomicInteger rocks = new AtomicInteger(0);
    private static final Set<String> graphSet = new HashSet();
    private static final HgStoreEngine storeEngine = HgStoreEngine.getInstance();
    private static final MemoryUseWrapper memoryUseWrapper = new MemoryUseWrapper();
    private static final Map<String, StatisticsWrapper> statisticsHolder = new HashMap();
    private static final Map<HistogramDataWrapper, HistogramType> histogramHolder = new HashMap();
    private static final Map<String, Set<Meter>> graphMeterMap = new ConcurrentHashMap();
    private static MeterRegistry registry;

    private RocksDBMetrics() {
    }

    public static void init(MeterRegistry meterRegistry) {
        HgAssert.isArgumentNotNull((Object)meterRegistry, (String)"meterRegistry");
        if (registry != null) {
            return;
        }
        registry = meterRegistry;
        Gauge.builder((String)"rocks.num", RocksDBMetrics::updateRocks).description("Number of instance of RocksDB running in this node").register(registry);
        RocksDBMetrics.registerMemoryUse();
    }

    private static int updateRocks() {
        int buf = RocksDBMetrics.getRocks();
        if (buf != rocks.get()) {
            rocks.set(buf);
            RocksDBMetrics.registerMeter();
        }
        return buf;
    }

    private static int getRocks() {
        return rocksDBFactory.getSessionSize();
    }

    private static Set<String> getGraphs() {
        return rocksDBFactory.getGraphNames();
    }

    private static RocksDBSession getRocksDBSession(String graph) {
        return rocksDBFactory.queryGraphDB(graph);
    }

    private static synchronized void registerMeter() {
        Set graphs = RocksDBMetrics.getGraphs();
        if (graphs == null) {
            log.error("Failed to fetch the collection of names of graph, when invoking to register RocksDB gauge.");
            return;
        }
        graphs.forEach(g -> {
            if (!graphSet.add(g)) {
                return;
            }
            StatisticsWrapper stats = new StatisticsWrapper(g);
            statisticsHolder.put(g, stats);
            for (TickerType tickerType : RocksDBMetricsConst.TICKERS) {
                String gaugeName = "rocks.stats." + tickerType.name().toLowerCase();
                RocksDBMetrics.saveGraphMeter((String)g, (Meter)Gauge.builder((String)gaugeName, () -> stats.getTickerCount(ticker)).description("RocksDB reported statistics for " + tickerType.name()).tag("graph", g).register(registry));
            }
            for (TickerType tickerType : RocksDBMetricsConst.HISTOGRAMS) {
                RocksDBMetrics.registerHistogram((String)g, (MeterRegistry)registry, (HistogramType)tickerType, (StatisticsWrapper)stats);
            }
            RocksDBMetrics.registrySessionRefNum((String)g);
        });
        graphSet.removeAll(graphSet.stream().filter(g -> !graphs.contains(g)).peek(g -> RocksDBMetrics.removeMeters((String)g)).collect(Collectors.toList()));
    }

    private static void saveGraphMeter(String g, Meter meter) {
        graphMeterMap.computeIfAbsent(g, k -> new HashSet()).add(meter);
    }

    private static void removeMeters(String g) {
        graphMeterMap.getOrDefault(g, Collections.emptySet()).forEach(e -> registry.remove(e));
    }

    private static void registerHistogram(String graph, MeterRegistry registry, HistogramType histogramType, StatisticsWrapper stats) {
        HistogramDataWrapper histogram = new HistogramDataWrapper(histogramType, () -> stats.getHistogramData(histogramType));
        histogramHolder.put(histogram, histogramType);
        String baseName = "rocks.stats." + histogramType.name().toLowerCase();
        RocksDBMetrics.saveGraphMeter((String)graph, (Meter)Gauge.builder((String)(baseName + ".max"), (Object)histogram, HistogramDataWrapper::getMax).tag("graph", graph).register(registry));
        RocksDBMetrics.saveGraphMeter((String)graph, (Meter)Gauge.builder((String)(baseName + ".mean"), (Object)histogram, HistogramDataWrapper::getAverage).tag("graph", graph).register(registry));
        RocksDBMetrics.saveGraphMeter((String)graph, (Meter)Gauge.builder((String)(baseName + ".min"), (Object)histogram, HistogramDataWrapper::getMin).tag("graph", graph).register(registry));
        baseName = baseName + ".summary";
        RocksDBMetrics.saveGraphMeter((String)graph, (Meter)Gauge.builder((String)baseName, (Object)histogram, HistogramDataWrapper::getMedian).tags(new String[]{"graph", graph, "quantile", "0.5"}).register(registry));
        RocksDBMetrics.saveGraphMeter((String)graph, (Meter)Gauge.builder((String)baseName, (Object)histogram, HistogramDataWrapper::getPercentile95).tags(new String[]{"graph", graph, "quantile", "0.95"}).register(registry));
        RocksDBMetrics.saveGraphMeter((String)graph, (Meter)Gauge.builder((String)baseName, (Object)histogram, HistogramDataWrapper::getPercentile99).tags(new String[]{"graph", graph, "quantile", "0.99"}).register(registry));
        RocksDBMetrics.saveGraphMeter((String)graph, (Meter)Gauge.builder((String)(baseName + ".sum"), (Object)histogram, HistogramDataWrapper::getSum).tags(new String[]{"graph", graph}).register(registry));
        RocksDBMetrics.saveGraphMeter((String)graph, (Meter)Gauge.builder((String)(baseName + ".count"), (Object)histogram, HistogramDataWrapper::getCount).tags(new String[]{"graph", graph}).register(registry));
    }

    private static void registerMemoryUse() {
        Gauge.builder((String)"rocks.stats.table.reader.total", (Object)memoryUseWrapper, e -> e.getTableReaderTotal().longValue()).description("The current number of threads in the pool.").register(registry);
        Gauge.builder((String)"rocks.stats.mem.table.total", (Object)memoryUseWrapper, e -> e.getMemTableTotal().longValue()).description("The current number of threads in the pool.").register(registry);
        Gauge.builder((String)"rocks.stats.mem.table.unFlushed", (Object)memoryUseWrapper, e -> e.getMemTableUnFlushed().longValue()).description("The current number of threads in the pool.").register(registry);
        Gauge.builder((String)"rocks.stats.cache.total", (Object)memoryUseWrapper, e -> e.getCacheTotal().longValue()).description("The current number of threads in the pool.").register(registry);
        Gauge.builder((String)"rocks.stats.block.cache.pinned-usage", (Object)memoryUseWrapper, e -> e.getProperty("rocksdb.block-cache-pinned-usage").longValue()).description("The current number of threads in the pool.").register(registry);
    }

    private static void registrySessionRefNum(String graph) {
        SessionWrapper sessionWrapper = new SessionWrapper(graph);
        RocksDBMetrics.saveGraphMeter((String)graph, (Meter)Gauge.builder((String)"rocks.stats.session.ref.count", (Object)sessionWrapper, e -> e.getRefCount() - 1).description("The current amount of reference of session").tag("ref", "self").tag("graph", graph).strongReference(true).register(registry));
    }

    private static <S, T> T getValue(S stat, Function<S, T> fun, T defaultValue) {
        if (stat == null) {
            return defaultValue;
        }
        return fun.apply(stat);
    }
}

