/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HgChannel<T> {
    private static final Logger log = LoggerFactory.getLogger(HgChannel.class);
    private final BlockingQueue<Supplier<T>> queue;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final long timeoutSeconds;

    private HgChannel(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        this.queue = new SynchronousQueue();
    }

    public static HgChannel of() {
        return new HgChannel(Long.MAX_VALUE);
    }

    public static HgChannel of(long timeoutSeconds) {
        return new HgChannel(timeoutSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(T t) {
        if (t == null) {
            throw new IllegalArgumentException("the argument t is null");
        }
        BlockingQueue blockingQueue = this.queue;
        synchronized (blockingQueue) {
            boolean flag;
            if (this.closed.get()) {
                return false;
            }
            try {
                flag = this.queue.offer(() -> t, this.timeoutSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error("failed to send a item to chan. cause by: ", t);
                throw new RuntimeException(e);
            }
            return flag;
        }
    }

    @CheckForNull
    public T receive() {
        return (T)this.receive(timeout -> {
            throw new RuntimeException("Timeout, max time: " + timeout + " seconds;");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public T receive(Consumer<Long> timeoutCallBack) {
        Supplier s;
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            if (this.closed.get()) {
                s = (Supplier)this.queue.poll();
            } else {
                try {
                    s = (Supplier)this.queue.poll(this.timeoutSeconds, TimeUnit.SECONDS);
                }
                catch (Throwable t) {
                    log.error("Failed to receive a item from chan. cause by: ", t);
                    throw new RuntimeException(t);
                }
                if (s == null) {
                    if (timeoutCallBack == null) {
                        throw new RuntimeException("Timeout, max time: " + this.timeoutSeconds + " seconds;");
                    }
                    timeoutCallBack.accept(this.timeoutSeconds);
                }
            }
        }
        if (s == null) {
            return null;
        }
        return s.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void close() {
        if (this.closed.get()) {
            return;
        }
        this.closed.set(true);
        this.queue.offer(() -> null);
        Thread.yield();
        this.queue.poll();
    }
}

