/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client;

import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hugegraph.store.client.type.HgNodeStatus;
import org.apache.hugegraph.store.client.util.HgAssert;

@NotThreadSafe
public class HgStoreNotice {
    private final Long nodeId;
    private final HgNodeStatus nodeStatus;
    private final String message;
    private Map<Integer, Long> partitionLeaders;
    private List<Integer> partitionIds;

    private HgStoreNotice(Long nodeId, HgNodeStatus nodeStatus, String message) {
        this.nodeId = nodeId;
        this.nodeStatus = nodeStatus;
        this.message = message;
    }

    public static HgStoreNotice of(Long nodeId, HgNodeStatus nodeStatus) {
        HgAssert.isArgumentNotNull(nodeId, "nodeId");
        HgAssert.isArgumentNotNull((Object)nodeStatus, "nodeStatus");
        return new HgStoreNotice(nodeId, nodeStatus, "");
    }

    public static HgStoreNotice of(Long nodeId, HgNodeStatus nodeStatus, String message) {
        HgAssert.isArgumentNotNull(nodeId, "nodeId");
        HgAssert.isArgumentNotNull((Object)nodeStatus, "nodeStatus");
        HgAssert.isArgumentNotNull(message, "message");
        return new HgStoreNotice(nodeId, nodeStatus, message);
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public HgNodeStatus getNodeStatus() {
        return this.nodeStatus;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<Integer, Long> getPartitionLeaders() {
        return this.partitionLeaders;
    }

    public HgStoreNotice setPartitionLeaders(Map<Integer, Long> partitionLeaders) {
        this.partitionLeaders = partitionLeaders;
        return this;
    }

    public List<Integer> getPartitionIds() {
        return this.partitionIds;
    }

    public HgStoreNotice setPartitionIds(List<Integer> partitionIds) {
        this.partitionIds = partitionIds;
        return this;
    }

    public String toString() {
        return "HgStoreNotice{nodeId=" + this.nodeId + ", nodeStatus=" + String.valueOf((Object)this.nodeStatus) + ", message='" + this.message + "', partitionLeaders=" + String.valueOf(this.partitionLeaders) + ", partitionIds=" + String.valueOf(this.partitionIds) + "}";
    }
}

