/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hugegraph.store.HgKvEntry;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.store.client.HgStoreNodeSession;
import org.apache.hugegraph.store.client.grpc.GrpcKvEntryImpl;
import org.apache.hugegraph.store.client.util.HgStoreClientConst;
import org.apache.hugegraph.store.grpc.common.Header;
import org.apache.hugegraph.store.grpc.common.Key;
import org.apache.hugegraph.store.grpc.common.Kv;
import org.apache.hugegraph.store.grpc.common.Tk;
import org.apache.hugegraph.store.grpc.common.Tkv;
import org.apache.hugegraph.store.grpc.common.Tp;
import org.apache.hugegraph.store.grpc.common.Tse;

final class GrpcUtil {
    private static final ThreadLocal<Key.Builder> keyBuilder = new ThreadLocal();

    GrpcUtil() {
    }

    static Header getHeader(HgStoreNodeSession nodeSession) {
        return Header.newBuilder().setGraph(nodeSession.getGraphName()).build();
    }

    static Tk toTk(String table, HgOwnerKey ownerKey) {
        return Tk.newBuilder().setTable(table).setKey(ByteString.copyFrom((byte[])ownerKey.getKey())).setCode(ownerKey.getKeyCode()).build();
    }

    static Key.Builder getOwnerKeyBuilder() {
        Key.Builder builder = keyBuilder.get();
        if (builder == null) {
            builder = Key.newBuilder();
            keyBuilder.set(builder);
        }
        return builder;
    }

    static Key toKey(HgOwnerKey ownerKey, Key.Builder builder) {
        if (ownerKey == null) {
            return null;
        }
        return builder.setKey(ByteString.copyFrom((byte[])ownerKey.getKey())).setCode(ownerKey.getKeyCode()).build();
    }

    static Key toKey(HgOwnerKey ownerKey) {
        if (ownerKey == null) {
            return null;
        }
        Key.Builder builder = keyBuilder.get();
        if (builder == null) {
            builder = Key.newBuilder();
            keyBuilder.set(builder);
        }
        return builder.setKey(ByteString.copyFrom((byte[])ownerKey.getKey())).setCode(ownerKey.getKeyCode()).build();
    }

    static Tkv toTkv(String table, HgOwnerKey ownerKey, byte[] value) {
        return Tkv.newBuilder().setTable(table).setKey(ByteString.copyFrom((byte[])ownerKey.getKey())).setValue(ByteString.copyFrom((byte[])value)).setCode(ownerKey.getKeyCode()).build();
    }

    static Tp toTp(String table, HgOwnerKey ownerKey) {
        return Tp.newBuilder().setTable(table).setPrefix(ByteString.copyFrom((byte[])ownerKey.getKey())).setCode(ownerKey.getKeyCode()).build();
    }

    static Tse toTse(String table, HgOwnerKey startKey, HgOwnerKey endKey) {
        return Tse.newBuilder().setTable(table).setStart(GrpcUtil.toKey(startKey)).setEnd(GrpcUtil.toKey(endKey)).build();
    }

    static List<HgKvEntry> toList(List<Kv> kvList) {
        if (kvList == null || kvList.isEmpty()) {
            return HgStoreClientConst.EMPTY_LIST;
        }
        Iterator<Kv> iter = kvList.iterator();
        ArrayList<HgKvEntry> resList = new ArrayList<HgKvEntry>(kvList.size());
        while (iter.hasNext()) {
            Kv entry = iter.next();
            resList.add(new GrpcKvEntryImpl(entry.getKey().toByteArray(), entry.getValue().toByteArray(), entry.getCode()));
        }
        return resList;
    }

    static StatusRuntimeException toErr(String msg) {
        return new StatusRuntimeException(Status.UNKNOWN.withDescription(msg));
    }

    static ByteString toBs(byte[] bytes) {
        return ByteString.copyFrom((byte[])(bytes != null ? bytes : HgStoreClientConst.EMPTY_BYTES));
    }
}

