/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import io.grpc.stub.StreamObserver;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hugegraph.store.HgPageSize;
import org.apache.hugegraph.store.HgScanQuery;
import org.apache.hugegraph.store.client.HgStoreNodeSession;
import org.apache.hugegraph.store.client.grpc.KvBatchUtil;
import org.apache.hugegraph.store.client.grpc.KvCloseableIterator;
import org.apache.hugegraph.store.client.type.HgStoreClientException;
import org.apache.hugegraph.store.client.util.Base58;
import org.apache.hugegraph.store.client.util.HgStoreClientConfig;
import org.apache.hugegraph.store.grpc.common.Kv;
import org.apache.hugegraph.store.grpc.stream.HgStoreStreamGrpc;
import org.apache.hugegraph.store.grpc.stream.KvPageRes;
import org.apache.hugegraph.store.grpc.stream.ScanCancelRequest;
import org.apache.hugegraph.store.grpc.stream.ScanReceiptRequest;
import org.apache.hugegraph.store.grpc.stream.ScanStreamBatchReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class KvBatchScanner5 {
    private static final Logger log = LoggerFactory.getLogger(KvBatchScanner5.class);
    private static final HgStoreClientConfig storeClientConfig = HgStoreClientConfig.of();
    private static final int HAVE_NEXT_TIMEOUT_SECONDS = 60;
    private static final long PAGE_SIZE = storeClientConfig.getNetKvScannerPageSize().intValue();

    KvBatchScanner5() {
    }

    public static KvCloseableIterator scan(HgStoreNodeSession nodeSession, HgStoreStreamGrpc.HgStoreStreamStub stub, HgScanQuery scanQuery) {
        return new OrderConsumer(new OrderBroker(stub, scanQuery, nodeSession));
    }

    private static class OrderConsumer
    implements KvCloseableIterator<Kv>,
    HgPageSize {
        private final OrderBroker broker;
        private final String consumerId;
        private Iterator<Kv> dataIterator;
        private long tookCount = 0L;

        OrderConsumer(OrderBroker broker) {
            this.broker = broker;
            this.consumerId = broker.brokerId;
        }

        private Iterator<Kv> getIterator() {
            List<Kv> list = this.broker.oneMore();
            if (log.isDebugEnabled() && list != null && list.isEmpty()) {
                log.debug("[ANALYSIS EMPTY] [{}] , tookCount: {}", (Object)this.consumerId, (Object)this.tookCount);
            }
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.iterator();
        }

        @Override
        public void close() {
            this.broker.finish(this.tookCount);
        }

        @Override
        public long getPageSize() {
            return PAGE_SIZE;
        }

        @Override
        public boolean hasNext() {
            if (this.dataIterator == null) {
                this.dataIterator = this.getIterator();
            } else {
                if (this.dataIterator.hasNext()) {
                    return true;
                }
                this.dataIterator = this.getIterator();
            }
            if (this.dataIterator == null) {
                if (log.isDebugEnabled()) {
                    log.debug("[ANALYSIS NULL -> FALSE] [{}] , tookCount: {}", (Object)this.consumerId, (Object)this.tookCount);
                }
                return false;
            }
            if (log.isDebugEnabled() && !this.dataIterator.hasNext()) {
                log.debug("[ANALYSIS hasNext -> FALSE] [{}] , tookCount: {}", (Object)this.consumerId, (Object)this.tookCount);
            }
            return this.dataIterator.hasNext();
        }

        @Override
        public Kv next() {
            if (this.dataIterator == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (log.isDebugEnabled()) {
                ++this.tookCount;
                if (this.tookCount % 10000L == 0L) {
                    log.debug("[ANALYSIS NEXT] [{}] , tookCount: {}", (Object)this.consumerId, (Object)this.tookCount);
                }
            }
            return this.dataIterator.next();
        }
    }

    private static class OrderBroker {
        public final OrderKeeper keeper = new OrderKeeper();
        private final HgScanQuery scanQuery;
        private final StreamObserver<ScanStreamBatchReq> requestObserver;
        private final ScanStreamBatchReq.Builder reqBuilder;
        private final ReentrantLock senderLock = new ReentrantLock();
        private final AtomicBoolean serverFinished = new AtomicBoolean();
        private final AtomicBoolean clientFinished = new AtomicBoolean();
        private final ScanReceiptRequest.Builder receiptReqBuilder = ScanReceiptRequest.newBuilder();
        private final ScanCancelRequest cancelReq = ScanCancelRequest.newBuilder().build();
        private final HgStoreNodeSession nodeSession;
        private final OrderAgent agent;
        private final AtomicLong receivedCount = new AtomicLong();
        private final AtomicInteger receivedLastTimes = new AtomicInteger();
        private final BlockingQueue<Integer> timesQueue = new LinkedBlockingQueue<Integer>();
        String brokerId = "";
        private OrderState state = OrderState.NEW;

        OrderBroker(HgStoreStreamGrpc.HgStoreStreamStub stub, HgScanQuery scanQuery, HgStoreNodeSession nodeSession) {
            if (log.isDebugEnabled() && scanQuery.getPrefixList() != null && scanQuery.getPrefixList().size() > 0) {
                this.brokerId = Base58.encode(scanQuery.getPrefixList().get(0).getKey());
                log.debug("[ANALYSIS START] [{}] firstKey: {}, keyLength: {}, table: {}, node: {}", new Object[]{this.brokerId, scanQuery.getPrefixList().get(0), scanQuery.getPrefixList().size(), scanQuery.getTable(), nodeSession.getStoreNode().getAddress()});
            }
            this.scanQuery = scanQuery;
            this.reqBuilder = KvBatchUtil.getRequestBuilder(nodeSession);
            this.nodeSession = nodeSession;
            this.agent = new OrderAgent(this.brokerId);
            this.requestObserver = stub.scanBatch((StreamObserver)this.agent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<Kv> oneMore() {
            if (this.state == OrderState.NEW) {
                OrderState orderState = this.state;
                synchronized (orderState) {
                    if (this.state == OrderState.NEW) {
                        this.makeADeal();
                        this.state = OrderState.WORKING;
                    }
                }
            } else {
                this.sendReceipt();
            }
            return this.keeper.pickUp();
        }

        void receipt(int times) {
            this.timesQueue.offer(times);
            this.receivedLastTimes.set(times);
        }

        void sendReceipt() {
            Integer buf = (Integer)this.timesQueue.poll();
            if (buf == null) {
                buf = this.receivedLastTimes.get();
            }
            AtomicInteger timesBuf = new AtomicInteger(buf);
            if (!this.clientFinished.get()) {
                this.send(() -> this.getReqBuilder().setReceiptRequest(this.receiptReqBuilder.setTimes(timesBuf.get()).build()).build());
            }
        }

        private void makeADeal() {
            this.send(() -> this.getReqBuilder().setQueryRequest(KvBatchUtil.createQueryReq(this.scanQuery, PAGE_SIZE)).build());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finish(long tookAmt) {
            this.clientFinished.set(true);
            if (log.isDebugEnabled()) {
                log.debug("[ANALYSIS END] [{}] times: {}, received: {}, took: {}", new Object[]{this.brokerId, this.receivedLastTimes.get(), this.receivedCount.get(), tookAmt});
            }
            if (this.receivedCount.get() != tookAmt && log.isDebugEnabled()) {
                log.debug("[ANALYSIS END] [{}] times: {}, received: {}, took: {}", new Object[]{this.brokerId, this.receivedLastTimes.get(), this.receivedCount.get(), tookAmt});
            }
            OrderState orderState = this.state;
            synchronized (orderState) {
                if (this.state.value < OrderState.COMPLETED.value) {
                    this.send(() -> this.getReqBuilder().setCancelRequest(this.cancelReq).build());
                    this.state = OrderState.COMPLETED;
                }
            }
        }

        private ScanStreamBatchReq.Builder getReqBuilder() {
            return this.reqBuilder.clearQueryRequest();
        }

        private void send(Supplier<ScanStreamBatchReq> supplier) {
            this.senderLock.lock();
            try {
                if (!this.serverFinished.get()) {
                    this.requestObserver.onNext((Object)supplier.get());
                }
                Thread.yield();
            }
            finally {
                this.senderLock.unlock();
            }
        }

        private class OrderKeeper {
            private final BlockingQueue<Supplier<List<Kv>>> queue = new LinkedBlockingQueue<Supplier<List<Kv>>>();
            private final ReentrantLock pickUpLock = new ReentrantLock();
            private final AtomicBoolean done = new AtomicBoolean();
            private final AtomicBoolean stop = new AtomicBoolean();
            private int timesOfOver;
            private int lastTimes;
            private Throwable serverErr;

            private OrderKeeper() {
            }

            void receive(List<Kv> data, int times) {
                OrderBroker.this.receivedCount.addAndGet(data.size());
                this.queue.offer(() -> data);
                OrderBroker.this.receipt(times);
                this.lastTimes = times;
            }

            private List<Kv> pickUp() {
                Supplier<List> res;
                block9: {
                    this.pickUpLock.lock();
                    try {
                        if (this.done.get()) {
                            if (this.stop.get()) {
                                log.warn("Invoking pickUp method after OrderKeeper has bean closing.");
                            }
                            if ((res = (Supplier<List>)this.queue.poll()) == null) {
                                res = () -> null;
                            }
                            break block9;
                        }
                        res = this.queue.poll(60L, TimeUnit.SECONDS);
                        if (res != null) break block9;
                        if (this.done.get()) {
                            res = () -> null;
                            break block9;
                        }
                        throw HgStoreClientException.of("Timeout, max time: 60 seconds, isOver: " + this.done.get() + ", isStop: " + this.stop.get() + ", last-times: " + this.lastTimes + ", over-times: " + this.timesOfOver);
                    }
                    catch (InterruptedException e) {
                        log.error("Failed to receive List<Kv> from queue because of interruption of current thread [" + Thread.currentThread().getName() + "]");
                        Thread.currentThread().interrupt();
                        throw HgStoreClientException.of("Failed to receive List<Kv> from queue, cause by:", e);
                    }
                    finally {
                        this.pickUpLock.unlock();
                    }
                }
                this.checkServerErr();
                return res.get();
            }

            void done(int times) {
                this.timesOfOver = times;
                this.done.set(true);
                this.queue.offer(() -> null);
            }

            void shout(Throwable t) {
                this.serverErr = t;
                log.error("Failed to receive from sever", t);
                this.queue.offer(() -> null);
            }

            private void checkServerErr() {
                if (this.serverErr != null) {
                    throw HgStoreClientException.of(this.serverErr);
                }
            }
        }

        private class OrderAgent
        implements StreamObserver<KvPageRes> {
            private final AtomicInteger count = new AtomicInteger(0);
            private final AtomicBoolean over = new AtomicBoolean(false);
            private final String agentId;

            OrderAgent(String agentId) {
                this.agentId = agentId;
            }

            public void onNext(KvPageRes value) {
                if (log.isDebugEnabled()) {
                    log.debug("Scan [ {} ] [ {} ] times, received: [ {} ]", new Object[]{OrderBroker.this.nodeSession.getStoreNode().getAddress(), value.getTimes(), value.getDataList().size()});
                }
                OrderBroker.this.serverFinished.set(value.getOver());
                List buffer = value.getDataList();
                this.count.addAndGet(buffer.size());
                if (log.isDebugEnabled() && value.getOver()) {
                    log.debug("[ANALYSIS OVER] [{}] count: {}", (Object)this.agentId, (Object)this.count);
                }
                OrderBroker.this.keeper.receive(buffer, value.getTimes());
                this.over.set(value.getOver());
                this.checkOver(value.getTimes());
            }

            private void checkOver(int times) {
                if (this.over.get()) {
                    OrderBroker.this.requestObserver.onCompleted();
                    OrderBroker.this.keeper.done(times);
                }
            }

            public void onError(Throwable t) {
                log.error("received server onError event, Throwable:", t);
                OrderBroker.this.keeper.shout(t);
            }

            public void onCompleted() {
                if (log.isDebugEnabled()) {
                    log.debug("received sever completed event.");
                }
                OrderBroker.this.serverFinished.set(true);
            }
        }
    }

    private static enum OrderState {
        NEW(0),
        WORKING(1),
        COMPLETED(10);

        int value;

        private OrderState(int value) {
            this.value = value;
        }
    }
}

