/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hugegraph.store.client.HgStoreNodeManager;
import org.apache.hugegraph.store.client.HgStoreNodeSession;
import org.apache.hugegraph.store.client.HgStoreNotice;
import org.apache.hugegraph.store.client.type.HgNodeStatus;
import org.apache.hugegraph.store.client.type.HgStoreClientException;
import org.apache.hugegraph.store.grpc.common.ResStatus;
import org.apache.hugegraph.store.grpc.session.FeedbackRes;
import org.apache.hugegraph.store.grpc.session.PartitionFaultResponse;
import org.apache.hugegraph.store.grpc.session.PartitionFaultType;
import org.apache.hugegraph.store.grpc.session.PartitionLeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NotifyingExecutor {
    private static final Logger log = LoggerFactory.getLogger(NotifyingExecutor.class);
    private final String graphName;
    private final HgStoreNodeManager nodeManager;
    private final HgStoreNodeSession nodeSession;
    private Map<PartitionFaultType, Consumer<PartitionFaultResponse>> partitionFaultHandlers;

    NotifyingExecutor(String graphName, HgStoreNodeManager nodeManager, HgStoreNodeSession nodeSession) {
        this.graphName = graphName;
        this.nodeManager = nodeManager;
        this.nodeSession = nodeSession;
    }

    private void initHandler() {
        this.partitionFaultHandlers = new HashMap<PartitionFaultType, Consumer<PartitionFaultResponse>>();
        this.partitionFaultHandlers.put(PartitionFaultType.PARTITION_FAULT_TYPE_NOT_LEADER, this.notifyPartitionLeaderConsumer());
    }

    <T> Optional<T> invoke(Supplier<FeedbackRes> supplier, Function<FeedbackRes, T> okFunction) {
        FeedbackRes res = null;
        try {
            res = supplier.get();
        }
        catch (Throwable t) {
            log.error("Failed to invoke: " + supplier.toString() + ", caused by:", t);
            this.handleErr(t);
            throw this.err(t);
        }
        if (log.isDebugEnabled()) {
            log.debug("gRPC [{}] status: {}", (Object)this.nodeSession.getStoreNode().getAddress(), (Object)res.getStatus().getCode());
        }
        Optional<T> option = null;
        switch (res.getStatus().getCode()) {
            case RES_CODE_OK: {
                option = Optional.of(okFunction.apply(res));
                break;
            }
            case RES_CODE_FAIL: {
                this.handleFail(res);
                break;
            }
            case RES_CODE_NOT_EXIST: {
                break;
            }
            case RES_CODE_EXCESS: {
                this.normalFail(res);
                break;
            }
            default: {
                log.error("gRPC [{}] status-msg: {}", (Object)this.nodeSession.getStoreNode().getAddress(), (Object)res.getStatus().getMsg());
            }
        }
        if (option == null) {
            option = Optional.empty();
        }
        return option;
    }

    private void handleErr(Throwable t) {
        try {
            this.notifyErrConsumer(HgNodeStatus.NOT_WORK).accept(t);
        }
        catch (Throwable tt) {
            log.error("Failed to notify error to HgStoreNodeNotifier, cause:", tt);
        }
    }

    private void handleFail(FeedbackRes feedbackRes) {
        Supplier<HgStoreClientException> exSup = this.handlePartitionFault(feedbackRes);
        if (exSup != null || (exSup = this.defaultExceptionSupplier(feedbackRes)) != null) {
            throw exSup.get();
        }
    }

    private void normalFail(FeedbackRes res) {
        HgStoreClientException ex;
        ResStatus status = res.getStatus();
        try {
            String msg = JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)res);
            ex = this.err(msg);
        }
        catch (Exception e) {
            ex = this.err(String.valueOf(status.getCode()) + ", " + status.getMsg());
        }
        throw ex;
    }

    private Supplier<HgStoreClientException> defaultExceptionSupplier(FeedbackRes feedbackRes) {
        return () -> HgStoreClientException.of(this.err(feedbackRes.getStatus().getMsg()));
    }

    private Supplier<HgStoreClientException> handlePartitionFault(FeedbackRes feedbackRes) {
        String msg;
        Consumer<PartitionFaultResponse> consumer;
        PartitionFaultResponse res = feedbackRes.getPartitionFaultResponse();
        if (res == null) {
            return null;
        }
        if (this.partitionFaultHandlers == null) {
            this.initHandler();
        }
        if ((consumer = this.partitionFaultHandlers.get(res.getFaultType())) == null) {
            consumer = this.notifyPartitionConsumer();
        }
        if ((msg = res.toString()) == null || msg.length() == 0) {
            msg = feedbackRes.getStatus().getMsg();
        }
        consumer.accept(res);
        String finalMsg = msg;
        return () -> HgStoreClientException.of(this.err(String.valueOf(res.getFaultType()) + ", " + finalMsg));
    }

    private HgStoreClientException err(String msg) {
        return this.err(msg, null);
    }

    private HgStoreClientException err(Throwable t) {
        return this.err(t.getMessage(), t);
    }

    private HgStoreClientException err(String reason, Throwable t) {
        StringBuilder builder = new StringBuilder().append("{sessionInfo: {" + this.nodeSession.toString() + "}, reason: ");
        if (reason.startsWith("{")) {
            builder.append(reason);
        } else {
            builder.append("\"").append(reason).append("\"");
        }
        String msg = builder.append("}").toString();
        if (t != null) {
            return HgStoreClientException.of(msg, t);
        }
        return HgStoreClientException.of(msg);
    }

    private Consumer<PartitionFaultResponse> notifyPartitionLeaderConsumer() {
        return res -> {
            log.info("partitions' leader have changed: [partitionId - leaderId] ");
            this.nodeManager.notifying(this.graphName, HgStoreNotice.of(this.nodeSession.getStoreNode().getNodeId(), HgNodeStatus.NOT_PARTITION_LEADER).setPartitionLeaders(res.getPartitionLeadersList().stream().peek(e -> log.info("[{} - {}]", (Object)e.getPartitionId(), (Object)e.getLeaderId())).collect(Collectors.toMap(PartitionLeader::getPartitionId, PartitionLeader::getLeaderId))));
        };
    }

    private Consumer<PartitionFaultResponse> notifyPartitionConsumer() {
        return this.notifyPartitionConsumer(HgNodeStatus.PARTITION_COMMON_FAULT);
    }

    private Consumer<PartitionFaultResponse> notifyPartitionConsumer(HgNodeStatus status) {
        return res -> this.nodeManager.notifying(this.graphName, HgStoreNotice.of(this.nodeSession.getStoreNode().getNodeId(), status).setPartitionIds(res.getPartitionIdsList()));
    }

    private Consumer<Throwable> notifyErrConsumer(HgNodeStatus status) {
        return t -> this.nodeManager.notifying(this.graphName, HgStoreNotice.of(this.nodeSession.getStoreNode().getNodeId(), status, t.getMessage()));
    }
}

