/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.rest;

import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.server.rest.SofaSynchronousDispatcher;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.core.AcceptHeaderByFileSuffixFilter;
import org.jboss.resteasy.core.AcceptParameterHttpPreprocessor;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.interceptors.RoleBasedSecurityFeature;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.providers.ServerFormUrlEncodedProvider;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.InternalDispatcher;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class SofaResteasyDeployment
extends ResteasyDeployment {
    private static final Logger LOGGER = LoggerFactory.getLogger(SofaResteasyDeployment.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.providerFactory == null) {
            this.providerFactory = new ResteasyProviderFactory();
        }
        this.providerFactory.setRegisterBuiltins(this.registerBuiltin);
        if (this.deploymentSensitiveFactoryEnabled) {
            if (!(this.providerFactory instanceof ThreadLocalResteasyProviderFactory || ResteasyProviderFactory.peekInstance() != null && ResteasyProviderFactory.peekInstance() instanceof ThreadLocalResteasyProviderFactory)) {
                this.threadLocalProviderFactory = new ThreadLocalResteasyProviderFactory(this.providerFactory);
                ResteasyProviderFactory.setInstance((ResteasyProviderFactory)this.threadLocalProviderFactory);
            }
        } else {
            ResteasyProviderFactory.setInstance((ResteasyProviderFactory)this.providerFactory);
        }
        if (this.asyncJobServiceEnabled) {
            AsynchronousDispatcher asyncDispatcher = new AsynchronousDispatcher(this.providerFactory);
            asyncDispatcher.setMaxCacheSize(this.asyncJobServiceMaxJobResults);
            asyncDispatcher.setMaxWaitMilliSeconds(this.asyncJobServiceMaxWait);
            asyncDispatcher.setThreadPoolSize(this.asyncJobServiceThreadPoolSize);
            asyncDispatcher.setBasePath(this.asyncJobServiceBasePath);
            asyncDispatcher.getUnwrappedExceptions().addAll(this.unwrappedExceptions);
            this.dispatcher = asyncDispatcher;
            asyncDispatcher.start();
        } else {
            SofaSynchronousDispatcher dis = new SofaSynchronousDispatcher(this.providerFactory);
            dis.getUnwrappedExceptions().addAll(this.unwrappedExceptions);
            this.dispatcher = dis;
        }
        this.registry = this.dispatcher.getRegistry();
        if (this.widerRequestMatching) {
            ((ResourceMethodRegistry)this.registry).setWiderMatching(this.widerRequestMatching);
        }
        this.dispatcher.getDefaultContextObjects().putAll(this.defaultContextObjects);
        this.dispatcher.getDefaultContextObjects().put(Configurable.class, this.providerFactory);
        this.dispatcher.getDefaultContextObjects().put(Providers.class, this.providerFactory);
        this.dispatcher.getDefaultContextObjects().put(Registry.class, this.registry);
        this.dispatcher.getDefaultContextObjects().put(Dispatcher.class, this.dispatcher);
        this.dispatcher.getDefaultContextObjects().put(InternalDispatcher.class, InternalDispatcher.getInstance());
        Map contextDataMap = ResteasyProviderFactory.getContextDataMap();
        contextDataMap.putAll(this.dispatcher.getDefaultContextObjects());
        try {
            if (this.injectorFactoryClass != null) {
                InjectorFactory injectorFactory;
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.injectorFactoryClass);
                    injectorFactory = (InjectorFactory)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException("Unable to find InjectorFactory implementation.", classNotFoundException);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unable to instantiate InjectorFactory implementation.", exception);
                }
                this.providerFactory.setInjectorFactory(injectorFactory);
            }
            if (this.constructedDefaultContextObjects != null && this.constructedDefaultContextObjects.size() > 0) {
                for (Map.Entry entry : this.constructedDefaultContextObjects.entrySet()) {
                    Class<?> key = null;
                    try {
                        key = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getKey());
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Unable to instantiate context object " + (String)entry.getKey(), e);
                    }
                    Object obj = SofaResteasyDeployment.createFromInjectorFactory((String)((String)entry.getValue()), (ResteasyProviderFactory)this.providerFactory);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Creating context object <" + (String)entry.getKey() + " : " + (String)entry.getValue() + ">");
                    }
                    this.defaultContextObjects.put(key, obj);
                    this.dispatcher.getDefaultContextObjects().put(key, obj);
                    contextDataMap.put(key, obj);
                }
            }
            if (this.interceptorPrecedences != null) {
                for (String string : this.interceptorPrecedences) {
                    this.providerFactory.appendInterceptorPrecedence(string.trim());
                }
            }
            if (this.interceptorBeforePrecedences != null) {
                for (Map.Entry entry : this.interceptorBeforePrecedences.entrySet()) {
                    this.providerFactory.insertInterceptorPrecedenceBefore(((String)entry.getKey()).trim(), ((String)entry.getValue()).trim());
                }
            }
            if (this.interceptorAfterPrecedences != null) {
                for (Map.Entry entry : this.interceptorAfterPrecedences.entrySet()) {
                    this.providerFactory.insertInterceptorPrecedenceAfter(((String)entry.getKey()).trim(), ((String)entry.getValue()).trim());
                }
            }
            if (this.securityEnabled) {
                this.providerFactory.register(RoleBasedSecurityFeature.class);
            }
            if (this.registerBuiltin) {
                this.providerFactory.setRegisterBuiltins(true);
                RegisterBuiltin.register((ResteasyProviderFactory)this.providerFactory);
                this.providerFactory.registerProviderInstance((Object)new ServerFormUrlEncodedProvider(this.useContainerFormParams), null, null, true);
            } else {
                this.providerFactory.setRegisterBuiltins(false);
            }
            if (this.applicationClass != null) {
                this.application = SofaResteasyDeployment.createApplication((String)this.applicationClass, (Dispatcher)this.dispatcher, (ResteasyProviderFactory)this.providerFactory);
            }
            this.registration();
            if (this.paramMapping != null) {
                this.providerFactory.getContainerRequestFilterRegistry().registerSingleton((Object)new AcceptParameterHttpPreprocessor(this.paramMapping));
            }
            AcceptHeaderByFileSuffixFilter suffixNegotiationFilter = null;
            if (this.mediaTypeMappings != null) {
                HashMap<String, MediaType> hashMap = new HashMap<String, MediaType>();
                for (Map.Entry ext : this.mediaTypeMappings.entrySet()) {
                    String value = (String)ext.getValue();
                    hashMap.put(((String)ext.getKey()).trim(), MediaType.valueOf((String)value.trim()));
                }
                if (suffixNegotiationFilter == null) {
                    suffixNegotiationFilter = new AcceptHeaderByFileSuffixFilter();
                    this.providerFactory.getContainerRequestFilterRegistry().registerSingleton((Object)suffixNegotiationFilter);
                }
                suffixNegotiationFilter.setMediaTypeMappings(hashMap);
            }
            if (this.languageExtensions != null) {
                if (suffixNegotiationFilter == null) {
                    suffixNegotiationFilter = new AcceptHeaderByFileSuffixFilter();
                    this.providerFactory.getContainerRequestFilterRegistry().registerSingleton((Object)suffixNegotiationFilter);
                }
                suffixNegotiationFilter.setLanguageMappings(this.languageExtensions);
            }
        }
        finally {
            ResteasyProviderFactory.removeContextDataLevel();
        }
    }
}

