/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputStreamPlus;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.streaming.OutgoingStream;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.messages.StreamMessage;
import org.apache.cassandra.streaming.messages.StreamMessageHeader;
import org.apache.cassandra.utils.FBUtilities;

public class OutgoingStreamMessage
extends StreamMessage {
    public static StreamMessage.Serializer<OutgoingStreamMessage> serializer = new StreamMessage.Serializer<OutgoingStreamMessage>(){

        @Override
        public OutgoingStreamMessage deserialize(DataInputPlus in, int version) {
            throw new UnsupportedOperationException("Not allowed to call deserialize on an outgoing stream");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serialize(OutgoingStreamMessage message, DataOutputStreamPlus out, int version, StreamSession session) throws IOException {
            message.startTransfer();
            try {
                message.serialize(out, version, session);
                session.streamSent(message);
            }
            finally {
                message.finishTransfer();
            }
        }

        @Override
        public long serializedSize(OutgoingStreamMessage message, int version) {
            return 0L;
        }
    };
    public final StreamMessageHeader header;
    public final OutgoingStream stream;
    private boolean completed = false;
    private boolean transferring = false;

    public OutgoingStreamMessage(TableId tableId, StreamSession session, OutgoingStream stream, int sequenceNumber) {
        super(StreamMessage.Type.STREAM);
        this.stream = stream;
        this.header = new StreamMessageHeader(tableId, FBUtilities.getBroadcastAddressAndPort(), session.planId(), session.isFollower(), session.sessionIndex(), sequenceNumber, stream.getRepairedAt(), stream.getPendingRepair());
    }

    public synchronized void serialize(DataOutputStreamPlus out, int version, StreamSession session) throws IOException {
        if (this.completed) {
            return;
        }
        StreamMessageHeader.serializer.serialize(this.header, out, version);
        this.stream.write(session, out, version);
    }

    @VisibleForTesting
    public synchronized void finishTransfer() {
        this.transferring = false;
        if (this.completed) {
            this.stream.finish();
        }
    }

    @VisibleForTesting
    public synchronized void startTransfer() {
        if (this.completed) {
            throw new RuntimeException(String.format("Transfer of stream %s already completed or aborted (perhaps session failed?).", this.stream));
        }
        this.transferring = true;
    }

    public synchronized void complete() {
        if (!this.completed) {
            this.completed = true;
            if (!this.transferring) {
                this.stream.finish();
            }
        }
    }

    public String toString() {
        return "OutgoingStreamMessage{header=" + this.header + ", stream=" + this.stream + '}';
    }

    public String getName() {
        return this.stream.getName();
    }
}

