/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.hstore;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.ConditionQueryFlatten;
import org.apache.hugegraph.backend.query.IdPrefixQuery;
import org.apache.hugegraph.backend.query.IdQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.serializer.BinaryBackendEntry;
import org.apache.hugegraph.backend.serializer.BytesBuffer;
import org.apache.hugegraph.backend.serializer.MergeIterator;
import org.apache.hugegraph.backend.store.AbstractBackendStore;
import org.apache.hugegraph.backend.store.BackendAction;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendFeatures;
import org.apache.hugegraph.backend.store.BackendMutation;
import org.apache.hugegraph.backend.store.BackendSession;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.backend.store.BackendTable;
import org.apache.hugegraph.backend.store.hstore.HstoreFeatures;
import org.apache.hugegraph.backend.store.hstore.HstoreMetrics;
import org.apache.hugegraph.backend.store.hstore.HstoreSessions;
import org.apache.hugegraph.backend.store.hstore.HstoreSessionsImpl;
import org.apache.hugegraph.backend.store.hstore.HstoreTable;
import org.apache.hugegraph.backend.store.hstore.HstoreTables;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.iterator.CIter;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.type.HugeTableType;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Action;
import org.apache.hugegraph.type.define.GraphMode;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class HstoreStore
extends AbstractBackendStore<HstoreSessions.Session> {
    private static final Logger LOG = Log.logger(HstoreStore.class);
    private static final Set<HugeType> INDEX_TYPES = ImmutableSet.of((Object)HugeType.SECONDARY_INDEX, (Object)HugeType.VERTEX_LABEL_INDEX, (Object)HugeType.EDGE_LABEL_INDEX, (Object)HugeType.RANGE_INT_INDEX, (Object)HugeType.RANGE_FLOAT_INDEX, (Object)HugeType.RANGE_LONG_INDEX, (Object[])new HugeType[]{HugeType.RANGE_DOUBLE_INDEX, HugeType.SEARCH_INDEX, HugeType.SHARD_INDEX, HugeType.UNIQUE_INDEX});
    private static final BackendFeatures FEATURES = new HstoreFeatures();
    private final String store;
    private final String namespace;
    private final BackendStoreProvider provider;
    private final Map<Integer, HstoreTable> tables = new HashMap<Integer, HstoreTable>();
    private final ReadWriteLock storeLock;
    private boolean isGraphStore;
    private HstoreSessions sessions;

    public HstoreStore(BackendStoreProvider provider, String namespace, String store) {
        this.provider = provider;
        this.namespace = namespace;
        this.store = store;
        this.sessions = null;
        this.storeLock = new ReentrantReadWriteLock();
        this.registerMetaHandlers();
        LOG.debug("Store loaded: {}", (Object)store);
    }

    private void registerMetaHandlers() {
        Supplier<List> dbsGet = () -> {
            ArrayList<HstoreSessions> dbs = new ArrayList<HstoreSessions>();
            dbs.add(this.sessions);
            return dbs;
        };
        this.registerMetaHandler("metrics", (session, meta, args) -> {
            HstoreMetrics metrics = new HstoreMetrics((List)dbsGet.get(), (HstoreSessions.Session)session);
            return metrics.metrics();
        });
        this.registerMetaHandler("mode", (session, meta, args) -> {
            E.checkArgument((args.length == 1 ? 1 : 0) != 0, (String)"The args count of %s must be 1", (Object[])new Object[]{meta});
            session.setMode((GraphMode)args[0]);
            return null;
        });
    }

    protected void registerTableManager(HugeTableType type, HstoreTable table) {
        this.tables.put(Integer.valueOf(type.code()), table);
    }

    protected final HstoreTable table(HugeType type) {
        HugeTableType table;
        assert (type != null);
        switch (type) {
            case VERTEX: {
                table = HugeTableType.VERTEX;
                break;
            }
            case EDGE_OUT: {
                table = HugeTableType.OUT_EDGE;
                break;
            }
            case EDGE_IN: {
                table = HugeTableType.IN_EDGE;
                break;
            }
            case OLAP: {
                table = HugeTableType.OLAP_TABLE;
                break;
            }
            case TASK: {
                table = HugeTableType.TASK_INFO_TABLE;
                break;
            }
            case SERVER: {
                table = HugeTableType.SERVER_INFO_TABLE;
                break;
            }
            case SEARCH_INDEX: 
            case SHARD_INDEX: 
            case SECONDARY_INDEX: 
            case RANGE_INT_INDEX: 
            case RANGE_LONG_INDEX: 
            case RANGE_FLOAT_INDEX: 
            case RANGE_DOUBLE_INDEX: 
            case EDGE_LABEL_INDEX: 
            case VERTEX_LABEL_INDEX: 
            case UNIQUE_INDEX: {
                table = HugeTableType.ALL_INDEX_TABLE;
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Invalid type: %s", type));
            }
        }
        return this.tables.get(table.code());
    }

    protected List<String> tableNames() {
        return this.tables.values().stream().map(BackendTable::table).collect(Collectors.toList());
    }

    protected HstoreSessions.Session session(HugeType type) {
        this.checkOpened();
        return this.sessions.session();
    }

    public String namespace() {
        return this.namespace;
    }

    public String store() {
        return this.store;
    }

    public String database() {
        return this.namespace;
    }

    public BackendStoreProvider provider() {
        return this.provider;
    }

    public BackendFeatures features() {
        return FEATURES;
    }

    public synchronized void open(HugeConfig config) {
        E.checkNotNull((Object)config, (String)"config");
        if (this.sessions == null) {
            this.sessions = new HstoreSessionsImpl(config, this.namespace, this.store);
        }
        String graphStore = (String)config.get((TypedOption)CoreOptions.STORE_GRAPH);
        this.isGraphStore = this.store.equals(graphStore);
        assert (this.sessions != null);
        if (!this.sessions.closed()) {
            LOG.debug("Store {} has been opened before", (Object)this.store);
            this.sessions.useSession();
            return;
        }
        try {
            this.sessions.open();
        }
        catch (Exception e) {
            LOG.error("Failed to open Hstore '{}':{}", (Object)this.store, (Object)e);
        }
        this.sessions.session();
        LOG.debug("Store opened: {}", (Object)this.store);
    }

    public void close() {
        this.checkOpened();
        this.sessions.close();
        LOG.debug("Store closed: {}", (Object)this.store);
    }

    public boolean opened() {
        this.checkConnectionOpened();
        return this.sessions.session().opened();
    }

    public void mutate(BackendMutation mutation) {
        HstoreSessions.Session session = this.sessions.session();
        assert (session.opened());
        Map mutations = mutation.mutations();
        Set entries = mutations.entrySet();
        for (Map.Entry entry : entries) {
            HugeType key = (HugeType)entry.getKey();
            boolean isEdge = key.isEdge();
            HstoreTable hTable = this.table(key);
            Map table = (Map)entry.getValue();
            Collection values = table.values();
            for (List items : values) {
                for (int i = 0; i < items.size(); ++i) {
                    BackendAction item = (BackendAction)items.get(i);
                    this.mutate(session, item, hTable, isEdge);
                }
            }
        }
    }

    private void mutate(HstoreSessions.Session session, BackendAction item, HstoreTable hTable, boolean isEdge) {
        HstoreTable table;
        BackendEntry entry = item.entry();
        if (!entry.olap()) {
            table = hTable;
        } else {
            table = entry.type().isIndex() ? this.table(entry.type()) : this.table(HugeType.OLAP);
            session = this.session(HugeType.OLAP);
        }
        if (item.action().code() == Action.INSERT.code()) {
            table.insert(session, entry, isEdge);
        } else if (item.action().code() == Action.APPEND.code()) {
            table.append(session, entry);
        } else {
            switch (item.action()) {
                case DELETE: {
                    table.delete(session, entry);
                    break;
                }
                case ELIMINATE: {
                    table.eliminate(session, entry);
                    break;
                }
                case UPDATE_IF_PRESENT: {
                    table.updateIfPresent((BackendSession)session, entry);
                    break;
                }
                case UPDATE_IF_ABSENT: {
                    table.updateIfAbsent((BackendSession)session, entry);
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("Unsupported mutate action: %s", item.action()));
                }
            }
        }
    }

    private HstoreTable getTableByQuery(Query query) {
        HugeType tableType = HstoreTable.tableType((Query)query);
        HstoreTable table = query.olap() ? (query.resultType().isIndex() ? this.table(HugeType.SECONDARY_INDEX) : this.table(HugeType.OLAP)) : this.table(tableType);
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<BackendEntry> query(Query query) {
        Lock readLock = this.storeLock.readLock();
        readLock.lock();
        try {
            this.checkOpened();
            HstoreSessions.Session session = this.sessions.session();
            HstoreTable table = this.getTableByQuery(query);
            Iterator<BackendEntry> entries = table.query(session, query);
            Iterator<BackendEntry> iterator = entries = this.getBackendEntryIterator(entries, query);
            return iterator;
        }
        finally {
            readLock.unlock();
        }
    }

    public Iterator<Iterator<BackendEntry>> query(Iterator<Query> queries, final Function<Query, Query> queryWriter, final HugeGraph hugeGraph) {
        if (queries == null || !queries.hasNext()) {
            return Collections.emptyIterator();
        }
        Query first = queries.next();
        List typeList = this.getHugeTypes(first);
        class QueryWrapper
        implements Iterator<IdPrefixQuery> {
            Query first;
            final Iterator<Query> queries;
            Iterator<Id> subEls;
            Query preQuery;
            Iterator<IdPrefixQuery> queryListIterator;

            QueryWrapper(Iterator<Query> queries, Query first) {
                this.queries = queries;
                this.first = first;
            }

            @Override
            public boolean hasNext() {
                return this.first != null || this.subEls != null && this.subEls.hasNext() || this.queryListIterator != null && this.queryListIterator.hasNext() || this.queries.hasNext();
            }

            @Override
            public IdPrefixQuery next() {
                Query q;
                if (this.queryListIterator != null && this.queryListIterator.hasNext()) {
                    return this.queryListIterator.next();
                }
                if (this.first != null) {
                    q = this.first;
                    this.preQuery = q.copy();
                    this.first = null;
                } else if (this.subEls == null || !this.subEls.hasNext()) {
                    q = this.queries.next();
                    this.preQuery = q.copy();
                } else {
                    q = this.preQuery.copy();
                }
                assert (q instanceof ConditionQuery);
                ConditionQuery cq = (ConditionQuery)q;
                ConditionQuery originQuery = (ConditionQuery)q.copy();
                ArrayList queryList = Lists.newArrayList();
                if (hugeGraph != null) {
                    for (ConditionQuery conditionQuery : ConditionQueryFlatten.flatten((ConditionQuery)cq)) {
                        HugeType hugeType;
                        Id label = (Id)conditionQuery.condition((Object)HugeKeys.LABEL);
                        if ((this.subEls == null || !this.subEls.hasNext()) && label != null && hugeGraph.edgeLabel(label).isFather() && conditionQuery.condition((Object)HugeKeys.SUB_LABEL) == null && conditionQuery.condition((Object)HugeKeys.OWNER_VERTEX) != null && conditionQuery.condition((Object)HugeKeys.DIRECTION) != null && this.matchEdgeSortKeys(conditionQuery, false, hugeGraph)) {
                            this.subEls = this.getSubLabelsOfParentEl(hugeGraph.edgeLabels(), label);
                        }
                        if (this.subEls != null && this.subEls.hasNext()) {
                            conditionQuery.eq(HugeKeys.SUB_LABEL, (Object)this.subEls.next());
                        }
                        if ((hugeType = conditionQuery.resultType()) == null || !hugeType.isEdge() || conditionQuery.conditions().isEmpty()) continue;
                        IdPrefixQuery idPrefixQuery = (IdPrefixQuery)queryWriter.apply(conditionQuery);
                        idPrefixQuery.setOriginQuery((Query)originQuery);
                        queryList.add(idPrefixQuery);
                    }
                    this.queryListIterator = queryList.iterator();
                    if (this.queryListIterator.hasNext()) {
                        return this.queryListIterator.next();
                    }
                }
                Id ownerId = (Id)cq.condition((Object)HugeKeys.OWNER_VERTEX);
                assert (ownerId != null);
                BytesBuffer buffer = BytesBuffer.allocate((int)128);
                buffer.writeId(ownerId);
                return new IdPrefixQuery((Query)cq, (Id)new BinaryBackendEntry.BinaryId(buffer.bytes(), ownerId));
            }

            private boolean matchEdgeSortKeys(ConditionQuery query, boolean matchAll, HugeGraph graph) {
                assert (query.resultType().isEdge());
                Id label = (Id)query.condition((Object)HugeKeys.LABEL);
                if (label == null) {
                    return false;
                }
                List sortKeys = graph.edgeLabel(label).sortKeys();
                if (sortKeys.isEmpty()) {
                    return false;
                }
                Set queryKeys = query.userpropKeys();
                for (int i = sortKeys.size(); i > 0; --i) {
                    List subFields = sortKeys.subList(0, i);
                    if (!queryKeys.containsAll(subFields) || queryKeys.size() != subFields.size() && matchAll) continue;
                    return true;
                }
                return false;
            }
        }
        QueryWrapper idPrefixQueries = new QueryWrapper(queries, first);
        return this.query((List<HugeType>)typeList, idPrefixQueries);
    }

    private Iterator<Id> getSubLabelsOfParentEl(Collection<EdgeLabel> allEls, Id label) {
        ArrayList<Id> list = new ArrayList<Id>();
        for (EdgeLabel el : allEls) {
            if (!el.edgeLabelType().sub() || !el.fatherId().equals(label)) continue;
            list.add(el.id());
        }
        return list.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CIter<BackendEntry>> query(List<HugeType> typeList, List<IdPrefixQuery> queries) {
        Lock readLock = this.storeLock.readLock();
        readLock.lock();
        LinkedList<CIter<BackendEntry>> results = new LinkedList<CIter<BackendEntry>>();
        try {
            this.checkOpened();
            HstoreSessions.Session session = this.sessions.session();
            E.checkState((!CollectionUtils.isEmpty(queries) && !CollectionUtils.isEmpty(typeList) ? 1 : 0) != 0, (String)"Please check query list or type list.", (Object[])new Object[0]);
            HstoreTable table = null;
            StringBuilder builder = new StringBuilder();
            for (HugeType type : typeList) {
                table = this.table(type);
                builder.append(table.table()).append(",");
            }
            List<Iterator<BackendEntry>> iteratorList = table.query(session, queries, builder.substring(0, builder.length() - 1));
            for (int i = 0; i < iteratorList.size(); ++i) {
                Iterator<BackendEntry> entries = iteratorList.get(i);
                Query query = (Query)queries.get(i);
                if (!((entries = this.getBackendEntryIterator(entries, query)) instanceof CIter)) continue;
                results.add((CIter<BackendEntry>)((CIter)entries));
            }
            LinkedList<CIter<BackendEntry>> linkedList = results;
            return linkedList;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Iterator<BackendEntry>> query(List<HugeType> typeList, Iterator<IdPrefixQuery> queries) {
        Lock readLock = this.storeLock.readLock();
        readLock.lock();
        try {
            BackendEntry.BackendIterator<Iterator<BackendEntry>> iterators;
            this.checkOpened();
            HstoreSessions.Session session = this.sessions.session();
            E.checkState((queries.hasNext() && !CollectionUtils.isEmpty(typeList) ? 1 : 0) != 0, (String)"Please check query list or type list.", (Object[])new Object[0]);
            HstoreTable table = null;
            StringBuilder builder = new StringBuilder();
            for (HugeType type : typeList) {
                table = this.table(type);
                builder.append(table.table()).append(",");
            }
            BackendEntry.BackendIterator<Iterator<BackendEntry>> backendIterator = iterators = table.query(session, queries, builder.substring(0, builder.length() - 1));
            return backendIterator;
        }
        finally {
            readLock.unlock();
        }
    }

    private Iterator<BackendEntry> getBackendEntryIterator(Iterator<BackendEntry> entries, Query query) {
        Set olapPks = query.olapPks();
        if (this.isGraphStore && !olapPks.isEmpty()) {
            ArrayList<Iterator<BackendEntry>> iterators = new ArrayList<Iterator<BackendEntry>>();
            for (Id pk : olapPks) {
                Query q = this.constructOlapQueryCondition(pk, query);
                HstoreTable table = this.table(HugeType.OLAP);
                iterators.add(table.queryOlap(this.session(HugeType.OLAP), q));
            }
            entries = new MergeIterator(entries, iterators, BackendEntry::mergeable);
        }
        return entries;
    }

    private Query constructOlapQueryCondition(Id pk, Query query) {
        if (query instanceof IdQuery && !CollectionUtils.isEmpty((Collection)query.ids())) {
            IdQuery q = (IdQuery)query.copy();
            Iterator iterator = q.ids().iterator();
            LinkedHashSet<Id> linkedHashSet = new LinkedHashSet<Id>();
            while (iterator.hasNext()) {
                Id id = (Id)iterator.next();
                if (id instanceof BinaryBackendEntry.BinaryId) {
                    id = ((BinaryBackendEntry.BinaryId)id).origin();
                }
                BytesBuffer buffer = BytesBuffer.allocate((int)(1 + pk.length() + 1 + id.length()));
                buffer.writeId(pk);
                id = new BinaryBackendEntry.BinaryId(buffer.writeId(id).bytes(), id);
                linkedHashSet.add(id);
            }
            q.resetIds();
            q.query(linkedHashSet);
            return q;
        }
        BytesBuffer buffer = BytesBuffer.allocate((int)(1 + pk.length()));
        pk = new BinaryBackendEntry.BinaryId(buffer.writeId(pk).bytes(), pk);
        IdPrefixQuery idPrefixQuery = new IdPrefixQuery(HugeType.OLAP, pk);
        return idPrefixQuery;
    }

    public Number queryNumber(Query query) {
        this.checkOpened();
        HstoreSessions.Session session = this.sessions.session();
        HstoreTable table = this.table(HstoreTable.tableType((Query)query));
        return table.queryNumber(session, query);
    }

    public synchronized void init() {
        Lock writeLock = this.storeLock.writeLock();
        writeLock.lock();
        try {
            this.sessions.createTable(this.tableNames().toArray(new String[0]));
            LOG.debug("Store initialized: {}", (Object)this.store);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void clear(boolean clearSpace) {
        Lock writeLock = this.storeLock.writeLock();
        writeLock.lock();
        try {
            this.sessions.dropTable(this.tableNames().toArray(new String[0]));
            if (clearSpace) {
                this.sessions.clear();
            }
            LOG.debug("Store cleared: {}", (Object)this.store);
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean initialized() {
        return true;
    }

    public void truncate() {
        try {
            this.sessions.session().truncate();
        }
        catch (Exception e) {
            LOG.error("Store truncated failed", (Throwable)e);
            return;
        }
        LOG.debug("Store truncated: {}", (Object)this.store);
    }

    public void beginTx() {
        this.sessions.session().beginTx();
    }

    public void commitTx() {
        this.checkOpened();
        HstoreSessions.Session session = this.sessions.session();
        session.commit();
    }

    public void rollbackTx() {
        this.checkOpened();
        HstoreSessions.Session session = this.sessions.session();
        session.rollback();
    }

    private void checkConnectionOpened() {
    }

    public Id nextId(HugeType type) {
        long counter = 0L;
        counter = this.getCounter(type);
        E.checkState((counter != 0L ? 1 : 0) != 0, (String)"Please check whether '%s' is OK", (Object[])new Object[]{this.provider().type()});
        return IdGenerator.of((long)counter);
    }

    public void setCounterLowest(HugeType type, long lowest) {
        this.increaseCounter(type, lowest);
    }

    public String storedVersion() {
        return "1.13";
    }

    public static class HstoreGraphStore
    extends HstoreStore {
        public HstoreGraphStore(BackendStoreProvider provider, String namespace, String store) {
            super(provider, namespace, store);
            this.registerTableManager(HugeTableType.VERTEX, new HstoreTables.Vertex(store));
            this.registerTableManager(HugeTableType.OUT_EDGE, HstoreTables.Edge.out(store));
            this.registerTableManager(HugeTableType.IN_EDGE, HstoreTables.Edge.in(store));
            this.registerTableManager(HugeTableType.ALL_INDEX_TABLE, new HstoreTables.IndexTable(store));
            this.registerTableManager(HugeTableType.OLAP_TABLE, new HstoreTables.OlapTable(store));
            this.registerTableManager(HugeTableType.TASK_INFO_TABLE, new HstoreTables.TaskInfo(store));
            this.registerTableManager(HugeTableType.SERVER_INFO_TABLE, new HstoreTables.ServerInfo(store));
        }

        public boolean isSchemaStore() {
            return false;
        }

        @Override
        public Id nextId(HugeType type) {
            throw new UnsupportedOperationException("HstoreGraphStore.nextId()");
        }

        public void increaseCounter(HugeType type, long num) {
            throw new UnsupportedOperationException("HstoreGraphStore.increaseCounter()");
        }

        public long getCounter(HugeType type) {
            throw new UnsupportedOperationException("HstoreGraphStore.getCounter()");
        }

        public void createOlapTable(Id pkId) {
            HstoreTables.OlapTable table = new HstoreTables.OlapTable(this.store());
            LOG.info("Hstore create olap table {}", (Object)table.table());
            this.sessions.createTable(table.table());
            LOG.info("Hstore finish create olap table");
            this.registerTableManager(HugeTableType.OLAP_TABLE, table);
            LOG.info("OLAP table {} has been created", (Object)table.table());
        }

        public void checkAndRegisterOlapTable(Id pkId) {
            HstoreTables.OlapTable table = new HstoreTables.OlapTable(this.store());
            if (!this.sessions.existsTable(table.table())) {
                LOG.error("Found exception: Table '{}' doesn't exist, we'll recreate it now. Please carefully check the recentoperation in server and computer, then ensure the integrity of store file.", (Object)table.table());
                this.createOlapTable(pkId);
            } else {
                this.registerTableManager(HugeTableType.OLAP_TABLE, table);
            }
        }

        public void clearOlapTable(Id pkId) {
        }

        public void removeOlapTable(Id pkId) {
        }

        public boolean existOlapTable(Id pkId) {
            String tableName = this.olapTableName(pkId);
            return this.sessions.existsTable(tableName);
        }
    }

    public static class HstoreSchemaStore
    extends HstoreStore {
        public HstoreSchemaStore(BackendStoreProvider provider, String namespace, String store) {
            super(provider, namespace, store);
        }

        public boolean isSchemaStore() {
            return true;
        }

        public void increaseCounter(HugeType type, long num) {
            throw new UnsupportedOperationException("HstoreSchemaStore.increaseCounter()");
        }

        public long getCounter(HugeType type) {
            throw new UnsupportedOperationException("HstoreSchemaStore.getCounter()");
        }
    }
}

