/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.hstore;

import java.util.List;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.serializer.BinarySerializer;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.hstore.HstoreSessions;
import org.apache.hugegraph.backend.store.hstore.HstoreTable;
import org.apache.hugegraph.type.HugeTableType;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;

public class HstoreTables {

    public static class OlapTable
    extends HstoreTable {
        public static final String TABLE = HugeTableType.OLAP_TABLE.string();

        public OlapTable(String database) {
            super(database, TABLE);
        }

        @Override
        protected BackendEntry.BackendColumnIterator queryById(HstoreSessions.Session session, Id id) {
            return this.getById(session, id);
        }

        @Override
        public boolean isOlap() {
            return true;
        }
    }

    public static class IndexTable
    extends HstoreTable {
        public static final String TABLE = HugeTableType.ALL_INDEX_TABLE.string();

        public IndexTable(String database) {
            super(database, TABLE);
        }

        @Override
        public void eliminate(HstoreSessions.Session session, BackendEntry entry) {
            assert (entry.columns().size() == 1);
            super.delete(session, entry);
        }

        @Override
        public void delete(HstoreSessions.Session session, BackendEntry entry) {
            byte[] ownerKey = this.ownerDelegate.apply(entry);
            for (BackendEntry.BackendColumn column : entry.columns()) {
                session.deletePrefix(this.table(), ownerKey, column.name);
            }
        }

        @Override
        protected BackendEntry.BackendColumnIterator queryByCond(HstoreSessions.Session session, ConditionQuery query) {
            assert (!query.conditions().isEmpty());
            List conds = query.syspropConditions(HugeKeys.ID);
            E.checkArgument((!conds.isEmpty() ? 1 : 0) != 0, (String)"Please specify the index conditions", (Object[])new Object[0]);
            Id prefix = null;
            Id min = null;
            boolean minEq = false;
            Id max = null;
            boolean maxEq = false;
            block7: for (Condition c : conds) {
                Condition.Relation r = (Condition.Relation)c;
                switch (r.relation()) {
                    case PREFIX: {
                        prefix = (Id)r.value();
                        continue block7;
                    }
                    case GTE: {
                        minEq = true;
                    }
                    case GT: {
                        min = (Id)r.value();
                        continue block7;
                    }
                    case LTE: {
                        maxEq = true;
                    }
                    case LT: {
                        max = (Id)r.value();
                        continue block7;
                    }
                }
                E.checkArgument((boolean)false, (String)"Unsupported relation '%s'", (Object[])new Object[]{r.relation()});
            }
            E.checkArgumentNotNull(min, (String)"Range index begin key is missing", (Object[])new Object[0]);
            byte[] begin = min.asBytes();
            if (!minEq) {
                BinarySerializer.increaseOne((byte[])begin);
            }
            byte[] ownerStart = (byte[])this.ownerScanDelegate.get();
            byte[] ownerEnd = (byte[])this.ownerScanDelegate.get();
            if (max == null) {
                E.checkArgumentNotNull((Object)prefix, (String)"Range index prefix is missing", (Object[])new Object[0]);
                return session.scan(this.table(), ownerStart, ownerEnd, begin, prefix.asBytes(), 2);
            }
            byte[] end = max.asBytes();
            int type = maxEq ? 48 : 16;
            return session.scan(this.table(), ownerStart, ownerEnd, begin, end, type);
        }
    }

    public static class Edge
    extends HstoreTable {
        public static final String TABLE_SUFFIX = HugeType.EDGE.string();

        public Edge(boolean out, String database) {
            super(database, out ? HugeTableType.OUT_EDGE.string() : HugeTableType.IN_EDGE.string());
        }

        public static Edge out(String database) {
            return new Edge(true, database);
        }

        public static Edge in(String database) {
            return new Edge(false, database);
        }

        @Override
        protected BackendEntry.BackendColumnIterator queryById(HstoreSessions.Session session, Id id) {
            return this.getById(session, id);
        }
    }

    public static class ServerInfo
    extends HstoreTable {
        public static final String TABLE = HugeTableType.SERVER_INFO_TABLE.string();

        public ServerInfo(String database) {
            super(database, TABLE);
        }

        @Override
        protected BackendEntry.BackendColumnIterator queryById(HstoreSessions.Session session, Id id) {
            return this.getById(session, id);
        }
    }

    public static class TaskInfo
    extends HstoreTable {
        public static final String TABLE = HugeTableType.TASK_INFO_TABLE.string();

        public TaskInfo(String database) {
            super(database, TABLE);
        }

        @Override
        protected BackendEntry.BackendColumnIterator queryById(HstoreSessions.Session session, Id id) {
            return this.getById(session, id);
        }
    }

    public static class Vertex
    extends HstoreTable {
        public static final String TABLE = HugeTableType.VERTEX.string();

        public Vertex(String database) {
            super(database, TABLE);
        }

        @Override
        protected BackendEntry.BackendColumnIterator queryById(HstoreSessions.Session session, Id id) {
            return this.getById(session, id);
        }
    }
}

