/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.fury.Fury;
import org.apache.fury.collection.Tuple3;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.serializer.ImmutableSerializer;

public final class LocaleSerializer
extends ImmutableSerializer<Locale> {
    private static final Map<Tuple3<String, String, String>, Locale> LOCALE_CACHE = new HashMap<Tuple3<String, String, String>, Locale>(LocaleSerializer.createCacheMap());

    static Map<Tuple3<String, String, String>, Locale> createCacheMap() {
        HashMap<Tuple3<String, String, String>, Locale> map = new HashMap<Tuple3<String, String, String>, Locale>();
        LocaleSerializer.populateMap(map, Locale.US);
        LocaleSerializer.populateMap(map, Locale.SIMPLIFIED_CHINESE);
        LocaleSerializer.populateMap(map, Locale.CHINESE);
        LocaleSerializer.populateMap(map, Locale.TRADITIONAL_CHINESE);
        LocaleSerializer.populateMap(map, Locale.ENGLISH);
        LocaleSerializer.populateMap(map, Locale.GERMAN);
        LocaleSerializer.populateMap(map, Locale.FRENCH);
        LocaleSerializer.populateMap(map, Locale.ITALIAN);
        LocaleSerializer.populateMap(map, Locale.JAPANESE);
        LocaleSerializer.populateMap(map, Locale.KOREAN);
        LocaleSerializer.populateMap(map, Locale.CHINA);
        LocaleSerializer.populateMap(map, Locale.TAIWAN);
        LocaleSerializer.populateMap(map, Locale.UK);
        LocaleSerializer.populateMap(map, Locale.GERMANY);
        LocaleSerializer.populateMap(map, Locale.FRANCE);
        LocaleSerializer.populateMap(map, Locale.ITALY);
        LocaleSerializer.populateMap(map, Locale.JAPAN);
        LocaleSerializer.populateMap(map, Locale.KOREA);
        LocaleSerializer.populateMap(map, Locale.PRC);
        LocaleSerializer.populateMap(map, Locale.CANADA);
        LocaleSerializer.populateMap(map, Locale.CANADA_FRENCH);
        LocaleSerializer.populateMap(map, Locale.ROOT);
        LocaleSerializer.populateMap(map, new Locale("es", "", ""));
        LocaleSerializer.populateMap(map, new Locale("es", "ES", ""));
        return map;
    }

    private static void populateMap(Map<Tuple3<String, String, String>, Locale> map, Locale locale) {
        map.put(Tuple3.of(locale.getCountry(), locale.getLanguage(), locale.getVariant()), locale);
    }

    public LocaleSerializer(Fury fury) {
        super(fury, Locale.class);
    }

    @Override
    public void write(MemoryBuffer buffer, Locale l) {
        this.fury.writeJavaString(buffer, l.getLanguage());
        this.fury.writeJavaString(buffer, l.getCountry());
        this.fury.writeJavaString(buffer, l.getVariant());
    }

    @Override
    public Locale read(MemoryBuffer buffer) {
        String language = this.fury.readJavaString(buffer);
        String country = this.fury.readJavaString(buffer);
        String variant = this.fury.readJavaString(buffer);
        Locale defaultLocale = Locale.getDefault();
        if (LocaleSerializer.isSame(defaultLocale, language, country, variant)) {
            return defaultLocale;
        }
        if (defaultLocale != Locale.US && LocaleSerializer.isSame(Locale.US, language, country, variant)) {
            return Locale.US;
        }
        if (LocaleSerializer.isSame(Locale.SIMPLIFIED_CHINESE, language, country, variant)) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        Locale o = LOCALE_CACHE.get(Tuple3.of(language, country, variant));
        if (o != null) {
            return o;
        }
        return new Locale(language, country, variant);
    }

    static boolean isSame(Locale locale, String language, String country, String variant) {
        return locale.getLanguage().equals(language) && locale.getCountry().equals(country) && locale.getVariant().equals(variant);
    }
}

