/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class ZonedDateTimeSerializer
extends SimpleTypeSerializer<ZonedDateTime> {
    public ZonedDateTimeSerializer() {
        super(DataType.ZONEDATETIME);
    }

    @Override
    protected ZonedDateTime readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        LocalDateTime ldt = context.readValue(buffer, LocalDateTime.class, false);
        ZoneOffset zo = context.readValue(buffer, ZoneOffset.class, false);
        return ZonedDateTime.of(ldt, zo);
    }

    @Override
    protected void writeValue(ZonedDateTime value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue(value.toLocalDateTime(), buffer, false);
        context.writeValue(value.getOffset(), buffer, false);
    }
}

