/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.management.MBeanServerConnection;
import org.gridkit.jvmtool.JmxConnectionInfo;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.mxproxy.JmxServer;

public class MxProxyCmd
implements CommandLauncher.CmdRef {
    public String getCommandName() {
        return "mprx";
    }

    public Runnable newCommand(CommandLauncher host) {
        return new MxProxy(host);
    }

    private static void startLocalJMXEndPoint(String bindhost, int port, MBeanServerConnection conn) throws MalformedURLException, IOException {
        JmxServer mserver = new JmxServer(conn);
        mserver.setBindHost(bindhost);
        mserver.setPort(port);
        mserver.start();
        System.out.println("Open proxy JMX end point on URI - " + mserver.getJmxUri());
    }

    @Parameters(commandDescription="JMX proxy - expose target process' MBeans for remote access")
    public static class MxProxy
    implements Runnable {
        @ParametersDelegate
        private CommandLauncher host;
        @ParametersDelegate
        private JmxConnectionInfo jmxConnectionInfo;
        @Parameter(names={"-b"}, required=true, description="Bind address - HOST:PORT")
        String bindAddress = null;

        public MxProxy(CommandLauncher host) {
            this.host = host;
            this.jmxConnectionInfo = new JmxConnectionInfo(host);
        }

        @Override
        public void run() {
            try {
                String bhost = "0.0.0.0";
                int bport = 0;
                if (this.bindAddress != null) {
                    int c = this.bindAddress.indexOf(58);
                    if (c < 0) {
                        bport = Integer.valueOf(this.bindAddress);
                    } else {
                        String h = this.bindAddress.substring(0, c);
                        String p = this.bindAddress.substring(c + 1);
                        bhost = h;
                        bport = Integer.valueOf(p);
                    }
                }
                if (bport <= 0) {
                    this.host.fail(new String[]{"Valid bind port required"});
                    return;
                }
                System.setProperty("java.rmi.server.hostname", bhost);
                MBeanServerConnection connection = this.jmxConnectionInfo.getMServer();
                System.out.println("Connected to target JMX endpoint");
                MxProxyCmd.startLocalJMXEndPoint(bhost, bport, connection);
                System.out.println("JMX proxy is running - " + bhost + ":" + bport);
                System.out.println("Interrupt this command to kill proxy");
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                this.host.fail(e.toString(), e);
                return;
            }
        }
    }
}

