/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.cache;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.cache.Cache;
import org.apache.hugegraph.backend.cache.CacheManager;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.ConditionQueryFlatten;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendFeatures;
import org.apache.hugegraph.backend.store.BackendMutation;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.backend.store.SystemSchemaStore;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.iterator.ExtendableIterator;
import org.apache.hugegraph.iterator.MapperIterator;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.StringEncoding;

public class CachedBackendStore
implements BackendStore {
    private BackendStore store = null;
    private Cache<Id, Object> cache = null;

    public CachedBackendStore(BackendStore store) {
        this.store = store;
        this.cache = CacheManager.instance().cache("store-" + this.store());
        this.cache.expire(30000L);
    }

    @Override
    public String store() {
        return this.store.store();
    }

    @Override
    public String storedVersion() {
        return this.store.storedVersion();
    }

    @Override
    public String database() {
        return this.store.database();
    }

    @Override
    public BackendStoreProvider provider() {
        return this.store.provider();
    }

    @Override
    public SystemSchemaStore systemSchemaStore() {
        return this.store.systemSchemaStore();
    }

    @Override
    public void open(HugeConfig config) {
        this.store.open(config);
    }

    @Override
    public void close() {
        this.store.close();
    }

    @Override
    public boolean opened() {
        return this.store.opened();
    }

    @Override
    public void init() {
        this.store.init();
    }

    @Override
    public void clear(boolean clearSpace) {
        this.store.clear(clearSpace);
    }

    @Override
    public boolean initialized() {
        return this.store.initialized();
    }

    @Override
    public void truncate() {
        this.store.truncate();
    }

    @Override
    public void beginTx() {
        this.store.beginTx();
    }

    @Override
    public void commitTx() {
        this.store.commitTx();
    }

    @Override
    public void rollbackTx() {
        this.store.rollbackTx();
    }

    @Override
    public <R> R metadata(HugeType type, String meta, Object[] args) {
        return this.store.metadata(type, meta, args);
    }

    @Override
    public BackendFeatures features() {
        return this.store.features();
    }

    @Override
    public Id nextId(HugeType type) {
        return this.store.nextId(type);
    }

    @Override
    public void increaseCounter(HugeType type, long increment) {
        this.store.increaseCounter(type, increment);
    }

    @Override
    public long getCounter(HugeType type) {
        return this.store.getCounter(type);
    }

    @Override
    public boolean isSchemaStore() {
        return this.store.isSchemaStore();
    }

    @Override
    public void mutate(BackendMutation mutation) {
        this.store.mutate(mutation);
    }

    @Override
    public Iterator<BackendEntry> query(Query query) {
        if (query.empty()) {
            return this.store.query(query);
        }
        QueryId id = new QueryId(query);
        Object result = this.cache.get(id);
        if (result != null) {
            return (Iterator)result;
        }
        Iterator<BackendEntry> rs = this.store.query(query);
        if (rs.hasNext()) {
            this.cache.update(id, rs);
        }
        return rs;
    }

    @Override
    public Iterator<Iterator<BackendEntry>> query(Iterator<Query> queries, Function<Query, Query> queryWriter, HugeGraph hugeGraph) {
        return new MapperIterator(queries, query -> {
            assert (query instanceof ConditionQuery);
            List<ConditionQuery> flattenQueryList = ConditionQueryFlatten.flatten((ConditionQuery)query);
            if (flattenQueryList.size() > 1) {
                ExtendableIterator itExtend = new ExtendableIterator();
                flattenQueryList.forEach(cq -> {
                    Query cQuery = (Query)queryWriter.apply((Query)cq);
                    itExtend.extend(this.query(cQuery));
                });
                return itExtend;
            }
            return this.query((Query)queryWriter.apply((Query)query));
        });
    }

    @Override
    public Number queryNumber(Query query) {
        return this.store.queryNumber(query);
    }

    public static class QueryId
    implements Id {
        protected String query;
        protected int hashCode;

        public QueryId(Query q) {
            this.query = q.toString();
            this.hashCode = q.hashCode();
        }

        public QueryId(String query, int hashCode) {
            this.query = query;
            this.hashCode = hashCode;
        }

        @Override
        public Id.IdType type() {
            return Id.IdType.UNKNOWN;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (!(other instanceof QueryId)) {
                return false;
            }
            return this.query.equals(((QueryId)other).query);
        }

        @Override
        public int compareTo(Id o) {
            return this.query.compareTo(o.asString());
        }

        @Override
        public Object asObject() {
            return this.query;
        }

        @Override
        public String asString() {
            return this.query;
        }

        @Override
        public long asLong() {
            return 0L;
        }

        @Override
        public byte[] asBytes() {
            return StringEncoding.encode(this.query);
        }

        public String toString() {
            return this.query;
        }

        @Override
        public int length() {
            return this.query.length();
        }
    }
}

