/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.cache;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import org.apache.hugegraph.backend.cache.AbstractCache;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.concurrent.KeyLock;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.util.E;

public class RamCache
extends AbstractCache<Id, Object> {
    private final ConcurrentMap<Id, LinkNode<Id, Object>> map;
    private final LinkedQueueNonBigLock<Id, Object> queue;
    private final KeyLock keyLock;
    private final long halfCapacity;

    public RamCache() {
        this(0x100000L);
    }

    public RamCache(long capacity) {
        super(capacity);
        long initialCapacity;
        if (capacity < 0L) {
            capacity = 0L;
        }
        this.keyLock = new KeyLock();
        this.halfCapacity = capacity >> 1;
        long l = initialCapacity = capacity >= 0x100000L ? capacity >> 10 : 256L;
        if (initialCapacity > 0x6400000L) {
            initialCapacity = 0x6400000L;
        }
        this.map = new ConcurrentHashMap<Id, LinkNode<Id, Object>>((int)initialCapacity);
        this.queue = new LinkedQueueNonBigLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PerfUtil.Watched(prefix="ramcache")
    protected final Object access(Id id) {
        assert (id != null);
        if ((long)this.map.size() <= this.halfCapacity) {
            LinkNode node = (LinkNode)this.map.get(id);
            if (node == null) {
                return null;
            }
            assert (id.equals(node.key()));
            return node.value();
        }
        if (!this.containsKey(id)) {
            return null;
        }
        Lock lock = this.keyLock.lock((Object)id);
        try {
            LinkNode node = (LinkNode)this.map.get(id);
            if (node == null) {
                Object var4_5 = null;
                return var4_5;
            }
            if ((long)this.map.size() > this.halfCapacity) {
                if (this.queue.remove(node) == null) {
                    Object var4_6 = null;
                    return var4_6;
                }
                this.queue.enqueue(node);
            }
            assert (id.equals(node.key()));
            Object v = node.value();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PerfUtil.Watched(prefix="ramcache")
    protected final boolean write(Id id, Object value, long timeOffset) {
        assert (id != null);
        long capacity = this.capacity();
        assert (capacity > 0L);
        Lock lock = this.keyLock.lock((Object)id);
        try {
            this.removeOldestIfCacheFull(id, capacity);
            LinkNode node = (LinkNode)this.map.get(id);
            if (node != null) {
                this.queue.remove(node);
            }
            this.map.put(id, this.queue.enqueue(id, value, timeOffset));
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PerfUtil.Watched(prefix="ramcache")
    protected final void remove(Id id) {
        if (id == null) {
            return;
        }
        Lock lock = this.keyLock.lock((Object)id);
        try {
            LinkNode node = (LinkNode)this.map.remove(id);
            if (node != null) {
                this.queue.remove(node);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected Iterator<AbstractCache.CacheNode<Id, Object>> nodes() {
        Iterator<AbstractCache.CacheNode<Id, Object>> iter;
        Iterator<AbstractCache.CacheNode<Id, Object>> iterSuper = iter = this.map.values().iterator();
        return iterSuper;
    }

    @Override
    public boolean containsKey(Id id) {
        return this.map.containsKey(id);
    }

    @Override
    @PerfUtil.Watched(prefix="ramcache")
    public void traverse(Consumer<Object> consumer) {
        E.checkNotNull(consumer, (String)"consumer");
        this.map.values().forEach(node -> consumer.accept(node.value()));
    }

    @Override
    @PerfUtil.Watched(prefix="ramcache")
    public void clear() {
        if (this.capacity() <= 0L || this.map.isEmpty()) {
            return;
        }
        this.map.clear();
        this.queue.clear();
    }

    @Override
    public long size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    private void removeOldestIfCacheFull(Id id, long capacity) {
        while ((long)this.map.size() >= capacity) {
            LinkNode<Id, Object> removed = this.queue.dequeue();
            if (removed == null) {
                this.map.clear();
                break;
            }
            this.map.remove(removed.key());
            if (LOG.isDebugEnabled()) {
                LOG.debug("RamCache replaced '{}' with '{}' (capacity={})", new Object[]{removed.key(), id, capacity});
            }
            removed = null;
        }
    }

    private static final class LinkedQueueNonBigLock<K, V> {
        private final KeyLock keyLock = new KeyLock();
        private final LinkNode<K, V> empty = new LinkNode<String, Object>("<empty>", null);
        private final LinkNode<K, V> head = new LinkNode<String, Object>("<head>", null);
        private final LinkNode<K, V> rear = new LinkNode<String, Object>("<rear>", null);

        public LinkedQueueNonBigLock() {
            this.reset();
        }

        private void reset() {
            this.head.prev = this.empty;
            this.head.next = this.rear;
            this.rear.prev = this.head;
            this.rear.next = this.empty;
            assert (this.head.next == this.rear);
            assert (this.rear.prev == this.head);
        }

        private List<K> dumpKeys() {
            LinkedList keys = new LinkedList();
            LinkNode node = this.head.next;
            while (node != this.rear && node != this.empty) {
                assert (node != null);
                keys.add(node.key());
                node = node.next;
            }
            return keys;
        }

        private boolean checkNotInQueue(K key) {
            List<K> keys = this.dumpKeys();
            if (keys.contains(key)) {
                throw new RuntimeException(String.format("Expect %s should be not in %s", key, keys));
            }
            return true;
        }

        private boolean checkPrevNotInNext(LinkNode<K, V> self) {
            int selfPos;
            LinkNode prev = self.prev;
            if (prev.key() == null) {
                assert (prev == this.head || prev == this.empty) : prev;
                return true;
            }
            List<K> keys = this.dumpKeys();
            int prevPos = keys.indexOf(prev.key());
            if (prevPos > (selfPos = keys.indexOf(self.key())) && selfPos != -1) {
                throw new RuntimeException(String.format("Expect %s should be before %s, actual %s", prev.key(), self.key(), keys));
            }
            return true;
        }

        private List<Lock> lock(Object ... nodes) {
            return this.keyLock.lockAll(nodes);
        }

        private List<Lock> lock(Object node1, Object node2) {
            return this.keyLock.lockAll(node1, node2);
        }

        private void unlock(List<Lock> locks) {
            this.keyLock.unlockAll(locks);
        }

        public void clear() {
            assert (this.rear.prev != null) : this.head.next;
            while (true) {
                LinkNode last = this.rear.prev;
                List<Lock> locks = this.lock(this.head, last, this.rear);
                try {
                    if (last != this.rear.prev) continue;
                    this.reset();
                }
                finally {
                    this.unlock(locks);
                    continue;
                }
                break;
            }
        }

        public LinkNode<K, V> enqueue(K key, V value, long timeOffset) {
            return this.enqueue(new LinkNode<K, V>(key, value, timeOffset));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LinkNode<K, V> enqueue(LinkNode<K, V> node) {
            assert (node != null);
            assert (node.prev == null || node.prev == this.empty);
            assert (node.next == null || node.next == this.empty);
            while (true) {
                LinkNode last = this.rear.prev;
                assert (last != this.empty) : last;
                List<Lock> locks = this.lock((Object)last, (Object)this.rear);
                try {
                    if (last != this.rear.prev) continue;
                    node.next = this.rear;
                    assert (this.rear.prev == last) : this.rear.prev;
                    this.rear.prev = node;
                    node.prev = last;
                    last.next = node;
                    LinkNode<K, V> linkNode = node;
                    return linkNode;
                }
                finally {
                    this.unlock(locks);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LinkNode<K, V> dequeue() {
            LinkNode first;
            while ((first = this.head.next) != this.rear) {
                List<Lock> locks = this.lock((Object)this.head, (Object)first);
                try {
                    if (first != this.head.next) continue;
                    assert (first.next != null && first.next != this.empty);
                    this.head.next = first.next;
                    first.next.prev = this.head;
                    first.prev = this.empty;
                    first.next = this.empty;
                    LinkNode linkNode = first;
                    return linkNode;
                }
                finally {
                    this.unlock(locks);
                    continue;
                }
                break;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LinkNode<K, V> remove(LinkNode<K, V> node) {
            assert (node != this.empty);
            assert (node != this.head && node != this.rear);
            LinkNode prev;
            while ((prev = node.prev) != this.empty && node.next != this.empty) {
                List<Lock> locks = this.lock((Object)prev, (Object)node);
                try {
                    if (prev != node.prev) continue;
                    assert (node.next != null) : node;
                    assert (node.next != this.empty) : node.next;
                    assert (node.next != node.prev) : node.next;
                    node.prev.next = node.next;
                    node.next.prev = node.prev;
                    assert (prev == node.prev) : String.valueOf(prev.key()) + "!=" + String.valueOf(node.prev);
                    node.prev = this.empty;
                    node.next = this.empty;
                    LinkNode<K, V> linkNode = node;
                    return linkNode;
                }
                finally {
                    this.unlock(locks);
                    continue;
                }
                break;
            }
            return null;
        }
    }

    private static final class LinkNode<K, V>
    extends AbstractCache.CacheNode<K, V> {
        private LinkNode<K, V> prev = null;
        private LinkNode<K, V> next = null;

        public LinkNode(K key, V value) {
            this(key, value, 0L);
        }

        public LinkNode(K key, V value, long timeOffset) {
            super(key, value, timeOffset);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof LinkNode)) {
                return false;
            }
            LinkNode other = (LinkNode)obj;
            return this.key().equals(other.key());
        }

        @Override
        public int hashCode() {
            return this.key().hashCode();
        }
    }
}

