/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.serializer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.EdgeId;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.page.PageState;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.IdPrefixQuery;
import org.apache.hugegraph.backend.query.IdRangeQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.serializer.AbstractSerializer;
import org.apache.hugegraph.backend.serializer.BinaryBackendEntry;
import org.apache.hugegraph.backend.serializer.BytesBuffer;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.iterator.CIter;
import org.apache.hugegraph.iterator.MapperIterator;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeEdgeProperty;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeIndex;
import org.apache.hugegraph.structure.HugeProperty;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.structure.HugeVertexProperty;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.AggregateType;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.EdgeLabelType;
import org.apache.hugegraph.type.define.Frequency;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.type.define.IdStrategy;
import org.apache.hugegraph.type.define.IndexType;
import org.apache.hugegraph.type.define.SchemaStatus;
import org.apache.hugegraph.type.define.SerialEnum;
import org.apache.hugegraph.type.define.WriteType;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.NumericUtil;
import org.apache.hugegraph.util.StringEncoding;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class BinarySerializer
extends AbstractSerializer {
    private final boolean keyWithIdPrefix;
    private final boolean indexWithIdPrefix;
    private final boolean enablePartition;

    public BinarySerializer() {
        this(true, true, false);
    }

    public BinarySerializer(HugeConfig config) {
        this(true, true, false);
    }

    public BinarySerializer(boolean keyWithIdPrefix, boolean indexWithIdPrefix, boolean enablePartition) {
        this.keyWithIdPrefix = keyWithIdPrefix;
        this.indexWithIdPrefix = indexWithIdPrefix;
        this.enablePartition = enablePartition;
    }

    @Override
    protected BinaryBackendEntry newBackendEntry(HugeType type, Id id) {
        if (type.isVertex()) {
            BytesBuffer buffer = BytesBuffer.allocate(3 + id.length());
            this.writePartitionedId(HugeType.VERTEX, id, buffer);
            return new BinaryBackendEntry(type, new BinaryBackendEntry.BinaryId(buffer.bytes(), id));
        }
        if (type.isEdge()) {
            E.checkState((boolean)(id instanceof BinaryBackendEntry.BinaryId), (String)"Expect a BinaryId for BackendEntry with edge id", (Object[])new Object[0]);
            return new BinaryBackendEntry(type, (BinaryBackendEntry.BinaryId)id);
        }
        if (type.isIndex()) {
            if (this.enablePartition) {
                if (type.isStringIndex()) {
                    // empty if block
                }
                if (type.isNumericIndex()) {
                    // empty if block
                }
            }
            BytesBuffer buffer = BytesBuffer.allocate(1 + id.length());
            byte[] idBytes = buffer.writeIndexId(id, type).bytes();
            return new BinaryBackendEntry(type, new BinaryBackendEntry.BinaryId(idBytes, id));
        }
        BytesBuffer buffer = BytesBuffer.allocate(1 + id.length());
        byte[] idBytes = buffer.writeId(id).bytes();
        return new BinaryBackendEntry(type, new BinaryBackendEntry.BinaryId(idBytes, id));
    }

    protected final BinaryBackendEntry newBackendEntry(HugeVertex vertex) {
        return this.newBackendEntry(vertex.type(), vertex.id());
    }

    protected final BinaryBackendEntry newBackendEntry(HugeEdge edge) {
        BinaryBackendEntry.BinaryId id = this.writeEdgeId(edge.idWithDirection());
        return this.newBackendEntry(edge.type(), id);
    }

    protected final BinaryBackendEntry newBackendEntry(SchemaElement elem) {
        return this.newBackendEntry(elem.type(), elem.id());
    }

    @Override
    protected BinaryBackendEntry convertEntry(BackendEntry entry) {
        assert (entry instanceof BinaryBackendEntry);
        return (BinaryBackendEntry)entry;
    }

    protected byte[] formatSyspropName(Id id, HugeKeys col) {
        int idLen = this.keyWithIdPrefix ? 1 + id.length() : 0;
        BytesBuffer buffer = BytesBuffer.allocate(idLen + 1 + 1);
        byte sysprop = HugeType.SYS_PROPERTY.code();
        if (this.keyWithIdPrefix) {
            buffer.writeId(id);
        }
        return buffer.write(sysprop).write(col.code()).bytes();
    }

    protected byte[] formatSyspropName(BinaryBackendEntry.BinaryId id, HugeKeys col) {
        int idLen = this.keyWithIdPrefix ? id.length() : 0;
        BytesBuffer buffer = BytesBuffer.allocate(idLen + 1 + 1);
        byte sysprop = HugeType.SYS_PROPERTY.code();
        if (this.keyWithIdPrefix) {
            buffer.write(id.asBytes());
        }
        return buffer.write(sysprop).write(col.code()).bytes();
    }

    protected BackendEntry.BackendColumn formatLabel(HugeElement elem) {
        BackendEntry.BackendColumn col = new BackendEntry.BackendColumn();
        col.name = this.formatSyspropName(elem.id(), HugeKeys.LABEL);
        Id label = elem.schemaLabel().id();
        BytesBuffer buffer = BytesBuffer.allocate(label.length() + 1);
        col.value = buffer.writeId(label).bytes();
        return col;
    }

    protected byte[] formatPropertyName(HugeProperty<?> prop) {
        Id id = prop.element().id();
        int idLen = this.keyWithIdPrefix ? 1 + id.length() : 0;
        Id pkeyId = prop.propertyKey().id();
        BytesBuffer buffer = BytesBuffer.allocate(idLen + 2 + pkeyId.length());
        if (this.keyWithIdPrefix) {
            buffer.writeId(id);
        }
        buffer.write(prop.type().code());
        buffer.writeId(pkeyId);
        return buffer.bytes();
    }

    protected BackendEntry.BackendColumn formatProperty(HugeProperty<?> prop) {
        BytesBuffer buffer = BytesBuffer.allocate(64);
        buffer.writeProperty(prop.propertyKey(), prop.value());
        return BackendEntry.BackendColumn.of(this.formatPropertyName(prop), buffer.bytes());
    }

    protected void parseProperty(Id pkeyId, BytesBuffer buffer, HugeElement owner) {
        PropertyKey pkey = owner.graph().propertyKey(pkeyId);
        Object value = buffer.readProperty(pkey);
        if (pkey.cardinality() == Cardinality.SINGLE) {
            owner.addProperty(pkey, value);
        } else {
            if (!(value instanceof Collection)) {
                throw new BackendException("Invalid value of non-single property: %s", value);
            }
            owner.addProperty(pkey, value);
        }
    }

    protected void formatProperties(Collection<HugeProperty<?>> props, BytesBuffer buffer) {
        buffer.writeVInt(props.size());
        for (HugeProperty<?> property : props) {
            PropertyKey pkey = property.propertyKey();
            buffer.writeVInt(SchemaElement.schemaId(pkey.id()));
            buffer.writeProperty(pkey, property.value());
        }
    }

    protected void parseProperties(BytesBuffer buffer, HugeElement owner) {
        int size = buffer.readVInt();
        assert (size >= 0);
        for (int i = 0; i < size; ++i) {
            Id pkeyId = IdGenerator.of(buffer.readVInt());
            this.parseProperty(pkeyId, buffer, owner);
        }
    }

    protected void formatExpiredTime(long expiredTime, BytesBuffer buffer) {
        buffer.writeVLong(expiredTime);
    }

    protected void parseExpiredTime(BytesBuffer buffer, HugeElement element) {
        element.expiredTime(buffer.readVLong());
    }

    protected byte[] formatEdgeValue(HugeEdge edge) {
        int propsCount = edge.sizeOfProperties();
        BytesBuffer buffer = BytesBuffer.allocate(4 + 16 * propsCount);
        this.formatProperties(edge.getProperties(), buffer);
        if (edge.hasTtl()) {
            this.formatExpiredTime(edge.expiredTime(), buffer);
        }
        return buffer.bytes();
    }

    protected void parseEdge(BackendEntry.BackendColumn col, HugeVertex vertex, HugeGraph graph) {
        HugeEdge edge;
        BytesBuffer buffer = BytesBuffer.wrap(col.name);
        if (this.keyWithIdPrefix) {
            buffer.readId();
        }
        byte type = buffer.read();
        Id labelId = buffer.readId();
        Id subLabelId = buffer.readId();
        String sortValues = buffer.readStringWithEnding();
        Id otherVertexId = buffer.readId();
        boolean direction = EdgeId.isOutDirectionFromCode(type);
        if (graph == null) {
            EdgeLabel edgeLabel = new EdgeLabel(null, subLabelId, "~undefined");
            if (subLabelId != labelId) {
                edgeLabel.edgeLabelType(EdgeLabelType.SUB);
                edgeLabel.fatherId(labelId);
            }
            edge = HugeEdge.constructEdgeWithoutGraph(vertex, direction, edgeLabel, sortValues, otherVertexId);
        } else {
            EdgeLabel edgeLabel = graph.edgeLabelOrNone(subLabelId);
            edge = HugeEdge.constructEdge(vertex, direction, edgeLabel, sortValues, otherVertexId);
        }
        buffer = BytesBuffer.wrap(col.value);
        this.parseProperties(buffer, edge);
        if (edge.hasTtl()) {
            this.parseExpiredTime(buffer, edge);
        }
    }

    protected void parseVertex(byte[] value, HugeVertex vertex) {
        BytesBuffer buffer = BytesBuffer.wrap(value);
        VertexLabel label = vertex.graph().vertexLabelOrNone(buffer.readId());
        vertex.correctVertexLabel(label);
        this.parseProperties(buffer, vertex);
        if (vertex.hasTtl()) {
            this.parseExpiredTime(buffer, vertex);
        }
    }

    protected void parseColumn(BackendEntry.BackendColumn col, HugeVertex vertex) {
        BytesBuffer buffer = BytesBuffer.wrap(col.name);
        Id id = this.keyWithIdPrefix ? buffer.readId() : vertex.id();
        E.checkState((buffer.remaining() > 0 ? 1 : 0) != 0, (String)"Missing column type", (Object[])new Object[0]);
        byte type = buffer.read();
        if (type == HugeType.PROPERTY.code()) {
            Id pkeyId = buffer.readId();
            this.parseProperty(pkeyId, BytesBuffer.wrap(col.value), vertex);
        } else if (type == HugeType.EDGE_IN.code() || type == HugeType.EDGE_OUT.code()) {
            this.parseEdge(col, vertex, vertex.graph());
        } else if (type != HugeType.SYS_PROPERTY.code()) {
            E.checkState((boolean)false, (String)"Invalid entry(%s) with unknown type(%s): 0x%s", (Object[])new Object[]{id, type & 0xFF, Bytes.toHex((byte[])col.name)});
        }
    }

    protected byte[] formatIndexName(HugeIndex index) {
        BytesBuffer buffer;
        Id elemId = index.elementId();
        if (!this.indexWithIdPrefix) {
            int idLen = 1 + elemId.length();
            buffer = BytesBuffer.allocate(idLen);
        } else {
            Id indexId = index.id();
            HugeType type = index.type();
            if (!type.isNumericIndex() && BinarySerializer.indexIdLengthExceedLimit(indexId)) {
                indexId = index.hashId();
            }
            int idLen = 1 + elemId.length() + 1 + indexId.length();
            buffer = BytesBuffer.allocate(idLen);
            buffer.writeIndexId(indexId, type);
        }
        buffer.writeId(elemId);
        if (index.hasTtl()) {
            buffer.writeVLong(index.expiredTime());
        }
        return buffer.bytes();
    }

    protected void parseIndexName(HugeGraph graph, ConditionQuery query, BinaryBackendEntry entry, HugeIndex index, Object fieldValues) {
        for (BackendEntry.BackendColumn col : entry.columns()) {
            if (BinarySerializer.indexFieldValuesUnmatched(col.value, fieldValues)) continue;
            BytesBuffer buffer = BytesBuffer.wrap(col.name);
            if (this.indexWithIdPrefix) {
                buffer.readIndexId(index.type());
            }
            Id elemId = buffer.readId();
            long expiredTime = index.hasTtl() ? buffer.readVLong() : 0L;
            index.elementIds(elemId, expiredTime);
        }
    }

    @Override
    public BackendEntry writeVertex(HugeVertex vertex) {
        if (vertex.olap()) {
            return this.writeOlapVertex(vertex);
        }
        BinaryBackendEntry entry = this.newBackendEntry(vertex);
        if (vertex.removed()) {
            return entry;
        }
        int propsCount = vertex.sizeOfProperties();
        BytesBuffer buffer = BytesBuffer.allocate(8 + 16 * propsCount);
        buffer.writeId(vertex.schemaLabel().id());
        this.formatProperties(vertex.getProperties(), buffer);
        if (vertex.hasTtl()) {
            entry.ttl(vertex.ttl());
            this.formatExpiredTime(vertex.expiredTime(), buffer);
        }
        byte[] name = this.keyWithIdPrefix ? entry.id().asBytes() : BytesBuffer.BYTES_EMPTY;
        entry.column(name, buffer.bytes());
        return entry;
    }

    @Override
    public BackendEntry writeOlapVertex(HugeVertex vertex) {
        BinaryBackendEntry entry = this.newBackendEntry(HugeType.OLAP, vertex.id());
        BytesBuffer buffer = BytesBuffer.allocate(24);
        Collection<HugeProperty<?>> properties = vertex.getProperties();
        if (properties.size() != 1) {
            E.checkArgument((boolean)false, (String)"Expect 1 property for olap vertex, but got %s", (Object[])new Object[]{properties.size()});
        }
        HugeProperty<?> property = properties.iterator().next();
        PropertyKey propertyKey = property.propertyKey();
        buffer.writeVInt(SchemaElement.schemaId(propertyKey.id()));
        buffer.writeProperty(propertyKey, property.value());
        byte[] name = this.keyWithIdPrefix ? entry.id().asBytes() : BytesBuffer.BYTES_EMPTY;
        entry.column(name, buffer.bytes());
        entry.subId(propertyKey.id());
        entry.olap(true);
        return entry;
    }

    @Override
    public BackendEntry writeVertexProperty(HugeVertexProperty<?> prop) {
        throw new NotImplementedException("Unsupported writeVertexProperty()");
    }

    @Override
    public HugeVertex readVertex(HugeGraph graph, BackendEntry bytesEntry) {
        if (bytesEntry == null) {
            return null;
        }
        BinaryBackendEntry entry = this.convertEntry(bytesEntry);
        Id id = entry.id().origin();
        Id vid = id.edge() ? ((EdgeId)id).ownerVertexId() : id;
        HugeVertex vertex = new HugeVertex(graph, vid, VertexLabel.NONE);
        Iterator<BackendEntry.BackendColumn> iterator = entry.columns().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            BackendEntry.BackendColumn col = iterator.next();
            if (entry.type().isEdge()) {
                this.parseColumn(col, vertex);
            } else {
                assert (entry.type().isVertex());
                assert (entry.columnsSize() >= 1) : entry.columnsSize();
                if (index == 0) {
                    this.parseVertex(col.value, vertex);
                } else {
                    this.parseVertexOlap(col.value, vertex);
                }
            }
            ++index;
        }
        return vertex;
    }

    protected void parseVertexOlap(byte[] value, HugeVertex vertex) {
        BytesBuffer buffer = BytesBuffer.wrap(value);
        Id pkeyId = IdGenerator.of(buffer.readVInt());
        this.parseProperty(pkeyId, buffer, vertex);
    }

    @Override
    public BackendEntry writeEdge(HugeEdge edge) {
        BinaryBackendEntry entry = this.newBackendEntry(edge);
        byte[] name = this.keyWithIdPrefix ? entry.id().asBytes() : BytesBuffer.BYTES_EMPTY;
        byte[] value = this.formatEdgeValue(edge);
        entry.column(name, value);
        if (edge.hasTtl()) {
            entry.ttl(edge.ttl());
        }
        return entry;
    }

    @Override
    public BackendEntry writeEdgeProperty(HugeEdgeProperty<?> prop) {
        throw new NotImplementedException("Unsupported writeEdgeProperty()");
    }

    @Override
    public HugeEdge readEdge(HugeGraph graph, BackendEntry bytesEntry) {
        HugeVertex vertex = this.readVertex(graph, bytesEntry);
        Collection<HugeEdge> edges = vertex.getEdges();
        if (edges.size() != 1) {
            E.checkState((boolean)false, (String)"Expect 1 edge in vertex, but got %s", (Object[])new Object[]{edges.size()});
        }
        return edges.iterator().next();
    }

    @Override
    public CIter<Edge> readEdges(HugeGraph graph, BackendEntry bytesEntry) {
        BinaryBackendEntry entry = this.convertEntry(bytesEntry);
        Id id = entry.id().origin();
        Id vid = id.edge() ? ((EdgeId)id).ownerVertexId() : id;
        HugeVertex vertex = new HugeVertex(graph, vid, VertexLabel.NONE);
        Iterator<BackendEntry.BackendColumn> iterator = entry.columns().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            BackendEntry.BackendColumn col = iterator.next();
            if (entry.type().isEdge()) {
                this.parseColumn(col, vertex);
            } else {
                assert (entry.type().isVertex());
                assert (entry.columnsSize() >= 1) : entry.columnsSize();
                if (index == 0) {
                    this.parseVertex(col.value, vertex);
                } else {
                    this.parseVertexOlap(col.value, vertex);
                }
            }
            ++index;
        }
        return new MapperIterator(vertex.getEdges().iterator(), edge -> edge);
    }

    @Override
    public BackendEntry writeIndex(HugeIndex index) {
        BinaryBackendEntry entry;
        if (index.fieldValues() == null && index.elementIds().isEmpty()) {
            entry = this.formatILDeletion(index);
        } else {
            Id id = index.id();
            HugeType type = index.type();
            byte[] value = null;
            if (!type.isNumericIndex() && BinarySerializer.indexIdLengthExceedLimit(id)) {
                id = index.hashId();
                value = StringEncoding.encode(index.fieldValues().toString());
            }
            entry = this.newBackendEntry(type, id);
            if (index.indexLabel().olap()) {
                entry.olap(true);
            }
            entry.column(this.formatIndexName(index), value);
            entry.subId(index.elementId());
            if (index.hasTtl()) {
                entry.ttl(index.ttl());
            }
        }
        return entry;
    }

    @Override
    public HugeIndex readIndex(HugeGraph graph, ConditionQuery query, BackendEntry bytesEntry) {
        if (bytesEntry == null) {
            return null;
        }
        BinaryBackendEntry entry = this.convertEntry(bytesEntry);
        byte[] bytes = entry.id().asBytes();
        HugeIndex index = HugeIndex.parseIndexId(graph, entry.type(), bytes);
        Object fieldValues = null;
        if (!index.type().isRangeIndex()) {
            fieldValues = query.condition((Object)HugeKeys.FIELD_VALUES);
            if (!index.fieldValues().equals(fieldValues)) {
                index.fieldValues(fieldValues);
            }
        }
        this.parseIndexName(graph, query, entry, index, fieldValues);
        return index;
    }

    @Override
    public BackendEntry writeId(HugeType type, Id id) {
        return this.newBackendEntry(type, id);
    }

    @Override
    protected Id writeQueryId(HugeType type, Id id) {
        if (type.isEdge()) {
            id = this.writeEdgeId(id);
        } else if (type.isVertex()) {
            BytesBuffer buffer = BytesBuffer.allocate(3 + id.length());
            this.writePartitionedId(HugeType.VERTEX, id, buffer);
            id = new BinaryBackendEntry.BinaryId(buffer.bytes(), id);
        } else {
            BytesBuffer buffer = BytesBuffer.allocate(1 + id.length());
            id = new BinaryBackendEntry.BinaryId(buffer.writeId(id).bytes(), id);
        }
        return id;
    }

    @Override
    protected Query writeQueryEdgeCondition(Query query) {
        ConditionQuery cq = (ConditionQuery)query;
        if (cq.hasRangeCondition()) {
            return this.writeQueryEdgeRangeCondition(cq);
        }
        return this.writeQueryEdgePrefixCondition(cq);
    }

    private Query writeQueryEdgeRangeCondition(ConditionQuery cq) {
        List<Condition> sortValues = cq.syspropConditions(HugeKeys.SORT_VALUES);
        E.checkArgument((sortValues.size() >= 1 && sortValues.size() <= 2 ? 1 : 0) != 0, (String)"Edge range query must be with sort-values range", (Object[])new Object[0]);
        Id vertex = (Id)cq.condition((Object)HugeKeys.OWNER_VERTEX);
        Directions direction = (Directions)cq.condition((Object)HugeKeys.DIRECTION);
        if (direction == null) {
            direction = Directions.OUT;
        }
        Id label = (Id)cq.condition((Object)HugeKeys.LABEL);
        BytesBuffer start = BytesBuffer.allocate(128);
        this.writePartitionedId(HugeType.EDGE, vertex, start);
        start.write(direction.type().code());
        start.writeId(label);
        Id subLabel = (Id)cq.condition((Object)HugeKeys.SUB_LABEL);
        if (subLabel != null) {
            start.writeId(subLabel);
        }
        BytesBuffer end = BytesBuffer.allocate(128);
        end.copyFrom(start);
        Condition.RangeConditions range = new Condition.RangeConditions(sortValues);
        if (range.keyMin() != null) {
            start.writeStringRaw((String)range.keyMin());
        }
        if (range.keyMax() != null) {
            end.writeStringRaw((String)range.keyMax());
        }
        BinaryBackendEntry.BinaryId startId = new BinaryBackendEntry.BinaryId(start.bytes(), null);
        BinaryBackendEntry.BinaryId endId = new BinaryBackendEntry.BinaryId(end.bytes(), null);
        boolean includeStart = range.keyMinEq();
        if (cq.paging() && !cq.page().isEmpty()) {
            includeStart = true;
            byte[] position = PageState.fromString(cq.page()).position();
            startId = new BinaryBackendEntry.BinaryId(position, null);
        }
        if (range.keyMax() == null) {
            return new IdPrefixQuery(cq, startId, includeStart, endId);
        }
        return new IdRangeQuery(cq, startId, includeStart, endId, range.keyMaxEq());
    }

    private Query writeQueryEdgePrefixCondition(ConditionQuery cq) {
        int count = 0;
        BytesBuffer buffer = BytesBuffer.allocate(128);
        for (HugeKeys key : EdgeId.KEYS) {
            Object value = cq.condition((Object)key);
            if (value != null) {
                ++count;
            } else {
                if (key != HugeKeys.DIRECTION) break;
                value = Directions.OUT;
            }
            if (key == HugeKeys.OWNER_VERTEX || key == HugeKeys.OTHER_VERTEX) {
                this.writePartitionedId(HugeType.EDGE, (Id)value, buffer);
                continue;
            }
            if (key == HugeKeys.DIRECTION) {
                byte t = ((Directions)value).type().code();
                buffer.write(t);
                continue;
            }
            if (key == HugeKeys.LABEL) {
                assert (value instanceof Id);
                buffer.writeId((Id)value);
                continue;
            }
            if (key == HugeKeys.SUB_LABEL) {
                assert (value instanceof Id);
                buffer.writeId((Id)value);
                continue;
            }
            if (key == HugeKeys.SORT_VALUES) {
                assert (value instanceof String);
                buffer.writeStringWithEnding((String)value);
                continue;
            }
            assert (false) : key;
        }
        if (count > 0) {
            assert (count == cq.conditionsSize());
            return BinarySerializer.prefixQuery(cq, new BinaryBackendEntry.BinaryId(buffer.bytes(), null));
        }
        return null;
    }

    @Override
    protected Query writeQueryCondition(Query query) {
        HugeType type = query.resultType();
        if (!type.isIndex()) {
            return query;
        }
        ConditionQuery cq = (ConditionQuery)query;
        if (type.isNumericIndex()) {
            return this.writeRangeIndexQuery(cq);
        }
        assert (type.isSearchIndex() || type.isSecondaryIndex() || type.isUniqueIndex());
        return this.writeStringIndexQuery(cq);
    }

    private Query writeStringIndexQuery(ConditionQuery query) {
        E.checkArgument((query.allSysprop() && query.conditionsSize() == 2 ? 1 : 0) != 0, (String)"There should be two conditions: INDEX_LABEL_ID and FIELD_VALUESin secondary index query", (Object[])new Object[0]);
        Id index = (Id)query.condition((Object)HugeKeys.INDEX_LABEL_ID);
        Object key = query.condition((Object)HugeKeys.FIELD_VALUES);
        E.checkArgument((index != null ? 1 : 0) != 0, (String)"Please specify the index label", (Object[])new Object[0]);
        E.checkArgument((key != null ? 1 : 0) != 0, (String)"Please specify the index key", (Object[])new Object[0]);
        BinaryBackendEntry.BinaryId prefix = BinarySerializer.formatIndexId(query.resultType(), index, key, true);
        return BinarySerializer.prefixQuery(query, prefix);
    }

    private Query writeRangeIndexQuery(ConditionQuery query) {
        Condition.RangeConditions range;
        Id index = (Id)query.condition((Object)HugeKeys.INDEX_LABEL_ID);
        E.checkArgument((index != null ? 1 : 0) != 0, (String)"Please specify the index label", (Object[])new Object[0]);
        List<Condition> fields = query.syspropConditions(HugeKeys.FIELD_VALUES);
        E.checkArgument((!fields.isEmpty() ? 1 : 0) != 0, (String)"Please specify the index field values", (Object[])new Object[0]);
        HugeType type = query.resultType();
        BinaryBackendEntry.BinaryId start = null;
        if (query.paging() && !query.page().isEmpty()) {
            byte[] position = PageState.fromString(query.page()).position();
            start = new BinaryBackendEntry.BinaryId(position, null);
        }
        if ((range = new Condition.RangeConditions(fields)).keyEq() != null) {
            BinaryBackendEntry.BinaryId id = BinarySerializer.formatIndexId(type, index, range.keyEq(), true);
            if (start == null) {
                return new IdPrefixQuery(query, (Id)id);
            }
            return new IdPrefixQuery(query, start, id);
        }
        Object keyMin = range.keyMin();
        Object keyMax = range.keyMax();
        boolean keyMinEq = range.keyMinEq();
        boolean keyMaxEq = range.keyMaxEq();
        if (keyMin == null) {
            E.checkArgument((keyMax != null ? 1 : 0) != 0, (String)"Please specify at least one condition", (Object[])new Object[0]);
            keyMin = NumericUtil.minValueOf(keyMax.getClass());
            keyMinEq = true;
        }
        BinaryBackendEntry.BinaryId min = BinarySerializer.formatIndexId(type, index, keyMin, false);
        if (!keyMinEq) {
            BinarySerializer.increaseOne(min.asBytes());
            keyMinEq = true;
        }
        if (start == null) {
            start = min;
        }
        if (keyMax == null) {
            keyMax = NumericUtil.maxValueOf(keyMin.getClass());
            keyMaxEq = true;
        }
        BinaryBackendEntry.BinaryId max = BinarySerializer.formatIndexId(type, index, keyMax, false);
        if (keyMaxEq) {
            keyMaxEq = false;
            BinarySerializer.increaseOne(max.asBytes());
        }
        return new IdRangeQuery(query, start, keyMinEq, max, keyMaxEq);
    }

    private BinaryBackendEntry formatILDeletion(HugeIndex index) {
        Id id = index.indexLabelId();
        BinaryBackendEntry.BinaryId bid = new BinaryBackendEntry.BinaryId(id.asBytes(), id);
        BinaryBackendEntry entry = new BinaryBackendEntry(index.type(), bid);
        if (index.type().isStringIndex()) {
            byte[] idBytes = IdGenerator.of(id.asString()).asBytes();
            BytesBuffer buffer = BytesBuffer.allocate(idBytes.length);
            buffer.write(idBytes);
            entry.column(buffer.bytes(), null);
        } else {
            assert (index.type().isRangeIndex());
            BytesBuffer buffer = BytesBuffer.allocate(4);
            buffer.writeInt((int)id.asLong());
            entry.column(buffer.bytes(), null);
        }
        return entry;
    }

    private BinaryBackendEntry.BinaryId writeEdgeId(Id id) {
        EdgeId edgeId = id instanceof EdgeId ? (EdgeId)id : EdgeId.parse(id.asString());
        BytesBuffer buffer = BytesBuffer.allocate(128);
        if (this.enablePartition) {
            buffer.writeShort(this.getPartition(HugeType.EDGE, edgeId.ownerVertexId()));
            buffer.writeEdgeId(edgeId);
        } else {
            buffer.writeEdgeId(edgeId);
        }
        return new BinaryBackendEntry.BinaryId(buffer.bytes(), id);
    }

    private void writePartitionedId(HugeType type, Id id, BytesBuffer buffer) {
        if (this.enablePartition) {
            buffer.writeShort(this.getPartition(type, id));
            buffer.writeId(id);
        } else {
            buffer.writeId(id);
        }
    }

    protected short getPartition(HugeType type, Id id) {
        return 0;
    }

    public BackendEntry parse(BackendEntry originEntry) {
        byte[] bytes = originEntry.id().asBytes();
        BinaryBackendEntry parsedEntry = new BinaryBackendEntry(originEntry.type(), bytes, this.enablePartition);
        bytes = this.enablePartition ? Arrays.copyOfRange(bytes, parsedEntry.id().length() + 2, bytes.length) : Arrays.copyOfRange(bytes, parsedEntry.id().length(), bytes.length);
        BytesBuffer buffer = BytesBuffer.allocate(128);
        buffer.write(parsedEntry.id().asBytes());
        buffer.write(bytes);
        parsedEntry = new BinaryBackendEntry(originEntry.type(), new BinaryBackendEntry.BinaryId(buffer.bytes(), BytesBuffer.wrap(buffer.bytes()).readEdgeId()));
        for (BackendEntry.BackendColumn col : originEntry.columns()) {
            parsedEntry.column(buffer.bytes(), col.value);
        }
        return parsedEntry;
    }

    private static Query prefixQuery(ConditionQuery query, Id prefix) {
        IdPrefixQuery newQuery;
        if (query.paging() && !query.page().isEmpty()) {
            byte[] position = PageState.fromString(query.page()).position();
            BinaryBackendEntry.BinaryId start = new BinaryBackendEntry.BinaryId(position, null);
            newQuery = new IdPrefixQuery(query, start, prefix);
        } else {
            newQuery = new IdPrefixQuery(query, prefix);
        }
        return newQuery;
    }

    protected static BinaryBackendEntry.BinaryId formatIndexId(HugeType type, Id indexLabel, Object fieldValues, boolean equal) {
        boolean withEnding = type.isRangeIndex() || equal;
        Id id = HugeIndex.formatIndexId(type, indexLabel, fieldValues);
        if (!type.isNumericIndex() && BinarySerializer.indexIdLengthExceedLimit(id)) {
            id = HugeIndex.formatIndexHashId(type, indexLabel, fieldValues);
        }
        BytesBuffer buffer = BytesBuffer.allocate(1 + id.length());
        byte[] idBytes = buffer.writeIndexId(id, type, withEnding).bytes();
        return new BinaryBackendEntry.BinaryId(idBytes, id);
    }

    protected static boolean indexIdLengthExceedLimit(Id id) {
        return id.asBytes().length > 32;
    }

    protected static boolean indexFieldValuesUnmatched(byte[] value, Object fieldValues) {
        if (value != null && value.length > 0 && fieldValues != null) {
            return !StringEncoding.decode(value).equals(fieldValues);
        }
        return false;
    }

    public static void increaseOne(byte[] bytes) {
        int BYTE_MAX_VALUE = -1;
        boolean INCREASE_STEP = true;
        assert (bytes.length > 0);
        byte last = bytes[bytes.length - 1];
        if (last != -1) {
            int n = bytes.length - 1;
            bytes[n] = (byte)(bytes[n] + 1);
        } else {
            int i = bytes.length - 1;
            while (i > 0 && bytes[i] == -1) {
                int n = i--;
                bytes[n] = (byte)(bytes[n] + 1);
            }
            if (bytes[i] == -1) {
                assert (i == 0);
                throw new BackendException("Unable to increase bytes: %s", Bytes.toHex((byte[])bytes));
            }
            int n = i;
            bytes[n] = (byte)(bytes[n] + 1);
        }
    }

    @Override
    public BackendEntry writeVertexLabel(VertexLabel vertexLabel) {
        SchemaSerializer serializer = new SchemaSerializer();
        return serializer.writeVertexLabel(vertexLabel);
    }

    @Override
    public VertexLabel readVertexLabel(HugeGraph graph, BackendEntry backendEntry) {
        if (backendEntry == null) {
            return null;
        }
        BinaryBackendEntry entry = this.convertEntry(backendEntry);
        SchemaSerializer serializer = new SchemaSerializer();
        return serializer.readVertexLabel(graph, entry);
    }

    @Override
    public BackendEntry writeEdgeLabel(EdgeLabel edgeLabel) {
        SchemaSerializer serializer = new SchemaSerializer();
        return serializer.writeEdgeLabel(edgeLabel);
    }

    @Override
    public EdgeLabel readEdgeLabel(HugeGraph graph, BackendEntry backendEntry) {
        if (backendEntry == null) {
            return null;
        }
        BinaryBackendEntry entry = this.convertEntry(backendEntry);
        SchemaSerializer serializer = new SchemaSerializer();
        return serializer.readEdgeLabel(graph, entry);
    }

    @Override
    public BackendEntry writePropertyKey(PropertyKey propertyKey) {
        SchemaSerializer serializer = new SchemaSerializer();
        return serializer.writePropertyKey(propertyKey);
    }

    @Override
    public PropertyKey readPropertyKey(HugeGraph graph, BackendEntry backendEntry) {
        if (backendEntry == null) {
            return null;
        }
        BinaryBackendEntry entry = this.convertEntry(backendEntry);
        SchemaSerializer serializer = new SchemaSerializer();
        return serializer.readPropertyKey(graph, entry);
    }

    @Override
    public BackendEntry writeIndexLabel(IndexLabel indexLabel) {
        SchemaSerializer serializer = new SchemaSerializer();
        return serializer.writeIndexLabel(indexLabel);
    }

    @Override
    public IndexLabel readIndexLabel(HugeGraph graph, BackendEntry backendEntry) {
        if (backendEntry == null) {
            return null;
        }
        BinaryBackendEntry entry = this.convertEntry(backendEntry);
        SchemaSerializer serializer = new SchemaSerializer();
        return serializer.readIndexLabel(graph, entry);
    }

    private final class SchemaSerializer {
        private BinaryBackendEntry entry;

        private SchemaSerializer() {
        }

        public BinaryBackendEntry writeVertexLabel(VertexLabel schema) {
            this.entry = BinarySerializer.this.newBackendEntry(schema);
            this.writeString(HugeKeys.NAME, schema.name());
            this.writeEnum(HugeKeys.ID_STRATEGY, schema.idStrategy());
            this.writeIds(HugeKeys.PROPERTIES, schema.properties());
            this.writeIds(HugeKeys.PRIMARY_KEYS, schema.primaryKeys());
            this.writeIds(HugeKeys.NULLABLE_KEYS, schema.nullableKeys());
            this.writeIds(HugeKeys.INDEX_LABELS, schema.indexLabels());
            this.writeBool(HugeKeys.ENABLE_LABEL_INDEX, schema.enableLabelIndex());
            this.writeEnum(HugeKeys.STATUS, schema.status());
            this.writeLong(HugeKeys.TTL, schema.ttl());
            this.writeId(HugeKeys.TTL_START_TIME, schema.ttlStartTime());
            this.writeUserdata(schema);
            return this.entry;
        }

        public VertexLabel readVertexLabel(HugeGraph graph, BinaryBackendEntry entry) {
            E.checkNotNull((Object)entry, (String)"entry");
            this.entry = entry;
            Id id = entry.id().origin();
            String name = this.readString(HugeKeys.NAME);
            VertexLabel vertexLabel = new VertexLabel(graph, id, name);
            vertexLabel.idStrategy(this.readEnum(HugeKeys.ID_STRATEGY, IdStrategy.class));
            vertexLabel.properties(this.readIds(HugeKeys.PROPERTIES));
            vertexLabel.primaryKeys(this.readIds(HugeKeys.PRIMARY_KEYS));
            vertexLabel.nullableKeys(this.readIds(HugeKeys.NULLABLE_KEYS));
            vertexLabel.addIndexLabels(this.readIds(HugeKeys.INDEX_LABELS));
            vertexLabel.enableLabelIndex(this.readBool(HugeKeys.ENABLE_LABEL_INDEX));
            vertexLabel.status(this.readEnum(HugeKeys.STATUS, SchemaStatus.class));
            vertexLabel.ttl(this.readLong(HugeKeys.TTL));
            vertexLabel.ttlStartTime(this.readId(HugeKeys.TTL_START_TIME));
            this.readUserdata(vertexLabel);
            return vertexLabel;
        }

        public BinaryBackendEntry writeEdgeLabel(EdgeLabel schema) {
            this.entry = BinarySerializer.this.newBackendEntry(schema);
            this.writeString(HugeKeys.NAME, schema.name());
            this.writeIds(HugeKeys.LINKS, schema.linksIds());
            this.writeEnum(HugeKeys.FREQUENCY, schema.frequency());
            this.writeIds(HugeKeys.PROPERTIES, schema.properties());
            this.writeIds(HugeKeys.SORT_KEYS, schema.sortKeys());
            this.writeIds(HugeKeys.NULLABLE_KEYS, schema.nullableKeys());
            this.writeIds(HugeKeys.INDEX_LABELS, schema.indexLabels());
            this.writeBool(HugeKeys.ENABLE_LABEL_INDEX, schema.enableLabelIndex());
            this.writeEnum(HugeKeys.STATUS, schema.status());
            this.writeLong(HugeKeys.TTL, schema.ttl());
            this.writeId(HugeKeys.TTL_START_TIME, schema.ttlStartTime());
            this.writeUserdata(schema);
            return this.entry;
        }

        public EdgeLabel readEdgeLabel(HugeGraph graph, BinaryBackendEntry entry) {
            E.checkNotNull((Object)entry, (String)"entry");
            this.entry = entry;
            Id id = entry.id().origin();
            String name = this.readString(HugeKeys.NAME);
            EdgeLabel edgeLabel = new EdgeLabel(graph, id, name);
            edgeLabel.linksIds(this.readIds(HugeKeys.LINKS));
            edgeLabel.frequency(this.readEnum(HugeKeys.FREQUENCY, Frequency.class));
            edgeLabel.properties(this.readIds(HugeKeys.PROPERTIES));
            edgeLabel.sortKeys(this.readIds(HugeKeys.SORT_KEYS));
            edgeLabel.nullableKeys(this.readIds(HugeKeys.NULLABLE_KEYS));
            edgeLabel.addIndexLabels(this.readIds(HugeKeys.INDEX_LABELS));
            edgeLabel.enableLabelIndex(this.readBool(HugeKeys.ENABLE_LABEL_INDEX));
            edgeLabel.status(this.readEnum(HugeKeys.STATUS, SchemaStatus.class));
            edgeLabel.ttl(this.readLong(HugeKeys.TTL));
            edgeLabel.ttlStartTime(this.readId(HugeKeys.TTL_START_TIME));
            this.readUserdata(edgeLabel);
            return edgeLabel;
        }

        public BinaryBackendEntry writePropertyKey(PropertyKey schema) {
            this.entry = BinarySerializer.this.newBackendEntry(schema);
            this.writeString(HugeKeys.NAME, schema.name());
            this.writeEnum(HugeKeys.DATA_TYPE, schema.dataType());
            this.writeEnum(HugeKeys.CARDINALITY, schema.cardinality());
            this.writeEnum(HugeKeys.AGGREGATE_TYPE, schema.aggregateType());
            this.writeEnum(HugeKeys.WRITE_TYPE, schema.writeType());
            this.writeIds(HugeKeys.PROPERTIES, schema.properties());
            this.writeEnum(HugeKeys.STATUS, schema.status());
            this.writeUserdata(schema);
            return this.entry;
        }

        public PropertyKey readPropertyKey(HugeGraph graph, BinaryBackendEntry entry) {
            E.checkNotNull((Object)entry, (String)"entry");
            this.entry = entry;
            Id id = entry.id().origin();
            String name = this.readString(HugeKeys.NAME);
            PropertyKey propertyKey = new PropertyKey(graph, id, name);
            propertyKey.dataType(this.readEnum(HugeKeys.DATA_TYPE, DataType.class));
            propertyKey.cardinality(this.readEnum(HugeKeys.CARDINALITY, Cardinality.class));
            propertyKey.aggregateType(this.readEnum(HugeKeys.AGGREGATE_TYPE, AggregateType.class));
            propertyKey.writeType(this.readEnumOrDefault(HugeKeys.WRITE_TYPE, WriteType.class, WriteType.OLTP));
            propertyKey.properties(this.readIds(HugeKeys.PROPERTIES));
            propertyKey.status(this.readEnum(HugeKeys.STATUS, SchemaStatus.class));
            this.readUserdata(propertyKey);
            return propertyKey;
        }

        public BinaryBackendEntry writeIndexLabel(IndexLabel schema) {
            this.entry = BinarySerializer.this.newBackendEntry(schema);
            this.writeString(HugeKeys.NAME, schema.name());
            this.writeEnum(HugeKeys.BASE_TYPE, schema.baseType());
            this.writeId(HugeKeys.BASE_VALUE, schema.baseValue());
            this.writeEnum(HugeKeys.INDEX_TYPE, schema.indexType());
            this.writeIds(HugeKeys.FIELDS, schema.indexFields());
            this.writeEnum(HugeKeys.STATUS, schema.status());
            this.writeUserdata(schema);
            return this.entry;
        }

        public IndexLabel readIndexLabel(HugeGraph graph, BinaryBackendEntry entry) {
            E.checkNotNull((Object)entry, (String)"entry");
            this.entry = entry;
            Id id = entry.id().origin();
            String name = this.readString(HugeKeys.NAME);
            IndexLabel indexLabel = new IndexLabel(graph, id, name);
            indexLabel.baseType(this.readEnum(HugeKeys.BASE_TYPE, HugeType.class));
            indexLabel.baseValue(this.readId(HugeKeys.BASE_VALUE));
            indexLabel.indexType(this.readEnum(HugeKeys.INDEX_TYPE, IndexType.class));
            indexLabel.indexFields(this.readIds(HugeKeys.FIELDS));
            indexLabel.status(this.readEnum(HugeKeys.STATUS, SchemaStatus.class));
            this.readUserdata(indexLabel);
            return indexLabel;
        }

        private void writeUserdata(SchemaElement schema) {
            String userdataStr = JsonUtil.toJson(schema.userdata());
            this.writeString(HugeKeys.USER_DATA, userdataStr);
        }

        private void readUserdata(SchemaElement schema) {
            byte[] userdataBytes = this.column(HugeKeys.USER_DATA);
            String userdataStr = StringEncoding.decode(userdataBytes);
            Map userdata = JsonUtil.fromJson(userdataStr, Map.class);
            for (Map.Entry e : userdata.entrySet()) {
                schema.userdata((String)e.getKey(), e.getValue());
            }
        }

        private void writeString(HugeKeys key, String value) {
            this.entry.column(this.formatColumnName(key), StringEncoding.encode(value));
        }

        private String readString(HugeKeys key) {
            return StringEncoding.decode(this.column(key));
        }

        private void writeEnum(HugeKeys key, SerialEnum value) {
            this.entry.column(this.formatColumnName(key), new byte[]{value.code()});
        }

        private <T extends SerialEnum> T readEnum(HugeKeys key, Class<T> clazz) {
            byte[] value = this.column(key);
            E.checkState((value.length == 1 ? 1 : 0) != 0, (String)"The length of column '%s' must be 1, but is '%s'", (Object[])new Object[]{key, value.length});
            return SerialEnum.fromCode(clazz, value[0]);
        }

        private <T extends SerialEnum> T readEnumOrDefault(HugeKeys key, Class<T> clazz, T defaultValue) {
            BackendEntry.BackendColumn column = this.entry.column(this.formatColumnName(key));
            if (column == null) {
                return defaultValue;
            }
            E.checkNotNull((Object)column.value, (String)"column.value");
            return SerialEnum.fromCode(clazz, column.value[0]);
        }

        private void writeLong(HugeKeys key, long value) {
            BytesBuffer buffer = new BytesBuffer(8);
            buffer.writeVLong(value);
            this.entry.column(this.formatColumnName(key), buffer.bytes());
        }

        private long readLong(HugeKeys key) {
            byte[] value = this.column(key);
            BytesBuffer buffer = BytesBuffer.wrap(value);
            return buffer.readVLong();
        }

        private void writeId(HugeKeys key, Id value) {
            this.entry.column(this.formatColumnName(key), this.writeId(value));
        }

        private Id readId(HugeKeys key) {
            return this.readId(this.column(key));
        }

        private void writeIds(HugeKeys key, Collection<Id> value) {
            this.entry.column(this.formatColumnName(key), this.writeIds(value));
        }

        private Id[] readIds(HugeKeys key) {
            return this.readIds(this.column(key));
        }

        private void writeBool(HugeKeys key, boolean value) {
            this.entry.column(this.formatColumnName(key), new byte[]{(byte)(value ? 1 : 0)});
        }

        private boolean readBool(HugeKeys key) {
            byte[] value = this.column(key);
            E.checkState((value.length == 1 ? 1 : 0) != 0, (String)"The length of column '%s' must be 1, but is '%s'", (Object[])new Object[]{key, value.length});
            return value[0] != 0;
        }

        private byte[] writeId(Id id) {
            int size = 1 + id.length();
            BytesBuffer buffer = BytesBuffer.allocate(size);
            buffer.writeId(id);
            return buffer.bytes();
        }

        private Id readId(byte[] value) {
            BytesBuffer buffer = BytesBuffer.wrap(value);
            return buffer.readId();
        }

        private byte[] writeIds(Collection<Id> ids) {
            E.checkState((ids.size() <= 65535 ? 1 : 0) != 0, (String)"The number of properties of vertex/edge label can't exceed '%s'", (Object[])new Object[]{65535});
            int size = 2;
            for (Id id : ids) {
                size += 1 + id.length();
            }
            BytesBuffer buffer = BytesBuffer.allocate(size);
            buffer.writeUInt16(ids.size());
            for (Id id : ids) {
                buffer.writeId(id);
            }
            return buffer.bytes();
        }

        private Id[] readIds(byte[] value) {
            BytesBuffer buffer = BytesBuffer.wrap(value);
            int size = buffer.readUInt16();
            Id[] ids = new Id[size];
            for (int i = 0; i < size; ++i) {
                Id id;
                ids[i] = id = buffer.readId();
            }
            return ids;
        }

        private byte[] column(HugeKeys key) {
            BackendEntry.BackendColumn column = this.entry.column(this.formatColumnName(key));
            E.checkState((column != null ? 1 : 0) != 0, (String)"Not found key '%s' from entry %s", (Object[])new Object[]{key, this.entry});
            E.checkNotNull((Object)column.value, (String)"column.value");
            return column.value;
        }

        private byte[] formatColumnName(HugeKeys key) {
            Id id = this.entry.id().origin();
            int size = 1 + id.length() + 1;
            BytesBuffer buffer = BytesBuffer.allocate(size);
            buffer.writeId(id);
            buffer.write(key.code());
            return buffer.bytes();
        }
    }
}

