/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.computer;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.hugegraph.job.computer.AbstractComputer;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.ParameterUtil;

public class LouvainComputer
extends AbstractComputer {
    public static final String LOUVAIN = "louvain";
    public static final String KEY_STABLE_TIMES = "stable_times";
    public static final String KEY_PRECISION = "precision";
    public static final String KEY_SHOW_MOD = "show_modularity";
    public static final String KEY_SHOW_COMM = "show_community";
    public static final String KEY_EXPORT_COMM = "export_community";
    public static final String KEY_SKIP_ISOLATED = "skip_isolated";
    public static final String KEY_CLEAR = "clear";
    public static final long DEFAULT_STABLE_TIMES = 3L;
    private static final int MAX_TIMES = 2048;

    @Override
    public String name() {
        return LOUVAIN;
    }

    @Override
    public String category() {
        return "community";
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        LouvainComputer.times(parameters);
        LouvainComputer.stableTimes(parameters);
        LouvainComputer.precision(parameters);
        LouvainComputer.degree(parameters);
        LouvainComputer.showModularity(parameters);
        LouvainComputer.showCommunity(parameters);
        LouvainComputer.exportCommunity(parameters);
        LouvainComputer.skipIsolated(parameters);
        LouvainComputer.clearPass(parameters);
    }

    @Override
    protected Map<String, Object> checkAndCollectParameters(Map<String, Object> parameters) {
        return ImmutableMap.of((Object)"times", (Object)LouvainComputer.times(parameters), (Object)KEY_PRECISION, (Object)LouvainComputer.precision(parameters), (Object)"direction", (Object)LouvainComputer.direction(parameters), (Object)"degree", (Object)LouvainComputer.degree(parameters));
    }

    protected static int stableTimes(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_STABLE_TIMES)) {
            return 3;
        }
        int times = ParameterUtil.parameterInt(parameters, KEY_STABLE_TIMES);
        HugeTraverser.checkPositiveOrNoLimit(times, KEY_STABLE_TIMES);
        E.checkArgument((times <= 2048 ? 1 : 0) != 0, (String)"The maximum number of stable iterations is %s, but got %s", (Object[])new Object[]{2048, times});
        return times;
    }

    protected static Long showModularity(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_SHOW_MOD)) {
            return null;
        }
        long pass = ParameterUtil.parameterLong(parameters, KEY_SHOW_MOD);
        HugeTraverser.checkNonNegative(pass, KEY_SHOW_MOD);
        return pass;
    }

    protected static String showCommunity(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_SHOW_COMM)) {
            return null;
        }
        return ParameterUtil.parameterString(parameters, KEY_SHOW_COMM);
    }

    protected static Long exportCommunity(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_EXPORT_COMM)) {
            return null;
        }
        long pass = ParameterUtil.parameterLong(parameters, KEY_EXPORT_COMM);
        HugeTraverser.checkNonNegative(pass, KEY_EXPORT_COMM);
        return pass;
    }

    protected static boolean skipIsolated(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_SKIP_ISOLATED)) {
            return true;
        }
        return ParameterUtil.parameterBoolean(parameters, KEY_SKIP_ISOLATED);
    }

    protected static Long clearPass(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_CLEAR)) {
            return null;
        }
        long pass = ParameterUtil.parameterLong(parameters, KEY_CLEAR);
        HugeTraverser.checkNonNegativeOrNoLimit(pass, KEY_CLEAR);
        return pass;
    }
}

