/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.system;

import java.util.Iterator;
import java.util.Set;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.query.IdQuery;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.job.system.DeleteExpiredJob;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeIndex;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class DeleteExpiredIndexJob<V>
extends DeleteExpiredJob<V> {
    private static final String JOB_TYPE = "delete_expired_index";
    private final Set<HugeIndex> indexes;

    public DeleteExpiredIndexJob(Set<HugeIndex> indexes) {
        E.checkArgument((indexes != null && !indexes.isEmpty() ? 1 : 0) != 0, (String)"The indexes can't be null or empty", (Object[])new Object[0]);
        this.indexes = indexes;
    }

    @Override
    public String type() {
        return JOB_TYPE;
    }

    @Override
    public V execute() throws Exception {
        LOG.debug("Delete expired indexes: {}", this.indexes);
        HugeGraphParams graph = this.params();
        GraphTransaction tx = graph.graphTransaction();
        try {
            for (HugeIndex index : this.indexes) {
                this.deleteExpiredIndex(graph, index);
            }
            tx.commit();
        }
        catch (Throwable e) {
            tx.rollback();
            LOG.warn("Failed to delete expired indexes: {}", this.indexes);
            throw e;
        }
        finally {
            JOB_COUNTERS.jobCounter(graph.graph()).decrement();
        }
        return null;
    }

    private void deleteExpiredIndex(HugeGraphParams graph, HugeIndex index) {
        Iterator<Vertex> elements;
        GraphTransaction tx = graph.graphTransaction();
        HugeType type = index.indexLabel().queryType().isVertex() ? HugeType.VERTEX : HugeType.EDGE;
        IdQuery query = new IdQuery(type);
        query.query(index.elementId());
        query.showExpired(true);
        Iterator<Object> iterator = elements = type.isVertex() ? tx.queryVertices(query) : tx.queryEdges(query);
        if (elements.hasNext()) {
            HugeElement element = (HugeElement)elements.next();
            if (element.expiredTime() == index.expiredTime()) {
                element.remove();
            } else {
                tx.removeIndex(index);
            }
        } else {
            tx.removeIndex(index);
        }
    }
}

