/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.k8s;

import com.google.common.base.Strings;
import io.fabric8.kubernetes.api.model.Namespace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.k8s.K8sDriver;
import org.apache.hugegraph.space.GraphSpace;
import org.apache.hugegraph.space.Service;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class K8sManager {
    private static final Logger LOG = Log.logger(K8sManager.class);
    private static final K8sManager INSTANCE = new K8sManager();
    private static final String TEMPLATE_NAME = "name: hugegraph-computer-operator-system";
    private static final String TEMPLATE_CLUSTER_ROLE_BINDING_NAME = "name: hugegraph-computer-operator-manager-rolebinding";
    private static final String TEMPLATE_NAMESPACE = "namespace: hugegraph-computer-operator-system";
    private static final String TEMPLATE_WATCH_NAMESPACE = "value: hugegraph-computer-operator-system";
    private static final String TEMPLATE_OPERATOR_IMAGE = "image: hugegraph/hugegraph-computer-operator:latest";
    private K8sDriver k8sDriver;
    private String operatorTemplate;

    private K8sManager() {
    }

    public static K8sManager instance() {
        return INSTANCE;
    }

    public void connect(String oltpImage, String olapImage, String storageImage, K8sDriver.CA ca) {
        this.k8sDriver = new K8sDriver();
        this.k8sDriver.ca(ca);
        this.k8sDriver.oltpImage(oltpImage);
        this.k8sDriver.olapImage(olapImage);
        this.k8sDriver.storageImage(storageImage);
    }

    private void loadOperatorTemplate() {
        if (!Strings.isNullOrEmpty((String)this.operatorTemplate)) {
            return;
        }
        try {
            File file = new File((String)CoreOptions.K8S_OPERATOR_TEMPLATE.defaultValue());
            FileReader reader = new FileReader(file);
            int length = (int)file.length();
            char[] buffer = new char[length];
            reader.read(buffer, 0, length);
            this.operatorTemplate = new String(buffer);
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Namespace namespace(String ns) {
        return this.k8sDriver.namespace(ns);
    }

    public Namespace createNamespace(String namespace, Map<String, String> labelMap) {
        return this.k8sDriver.createNamespace(namespace, labelMap);
    }

    public Set<String> createOltpService(GraphSpace graphSpace, Service service, List<String> metaServers, String cluster) {
        if (null == this.k8sDriver) {
            return Collections.EMPTY_SET;
        }
        return this.k8sDriver.createOltpService(graphSpace, service, metaServers, cluster);
    }

    public Set<String> startOltpService(GraphSpace graphSpace, Service service, List<String> metaServers, String cluster) {
        if (null == this.k8sDriver) {
            return Collections.EMPTY_SET;
        }
        return this.k8sDriver.startOltpService(graphSpace, service, metaServers, cluster);
    }

    public Set<String> createService(GraphSpace graphSpace, Service service, List<String> metaServers, String cluster) {
        switch (service.type()) {
            case OLTP: {
                return this.createOltpService(graphSpace, service, metaServers, cluster);
            }
        }
        throw new AssertionError((Object)String.format("Invalid service type '%s'", new Object[]{service.type()}));
    }

    public Set<String> startService(GraphSpace graphSpace, Service service, List<String> metaServers, String cluster) {
        switch (service.type()) {
            case OLTP: {
                return this.startOltpService(graphSpace, service, metaServers, cluster);
            }
        }
        throw new AssertionError((Object)String.format("Invalid service type '%s'", new Object[]{service.type()}));
    }

    public void stopService(GraphSpace graphSpace, Service service) {
        if (null == this.k8sDriver) {
            return;
        }
        switch (service.type()) {
            case OLTP: {
                this.k8sDriver.stopOltpService(graphSpace, service);
            }
        }
    }

    public void deleteService(GraphSpace graphSpace, Service service) {
        if (null == this.k8sDriver) {
            return;
        }
        switch (service.type()) {
            case OLTP: {
                this.k8sDriver.deleteOltpService(graphSpace, service);
                break;
            }
        }
    }

    public int podsRunning(GraphSpace graphSpace, Service service) {
        if (null == this.k8sDriver) {
            throw new HugeException("k8sDriver is not initialized!");
        }
        return this.k8sDriver.podsRunning(graphSpace, service);
    }

    public void createOperatorPod(String namespace, String imagePath) {
        if (Strings.isNullOrEmpty((String)imagePath)) {
            return;
        }
        this.loadOperator(namespace, imagePath);
    }

    public void loadOperator(String namespace, String imagePath) throws HugeException {
        try {
            this.loadOperatorTemplate();
            if (Strings.isNullOrEmpty((String)this.operatorTemplate)) {
                throw new HugeException("Cannot generate yaml config for operator: template load failed");
            }
            namespace = namespace.replace("_", "-").toLowerCase();
            String nextNamespace = "namespace: " + namespace;
            String content = this.operatorTemplate.replaceAll(TEMPLATE_NAMESPACE, nextNamespace);
            String watchNamespace = "value: " + namespace;
            content = content.replace(TEMPLATE_WATCH_NAMESPACE, watchNamespace);
            String nextName = "name: " + namespace;
            content = content.replaceAll(TEMPLATE_NAME, nextName);
            String nextRoleBinding = "name: " + namespace + "-manager-role-binding";
            content = content.replaceAll(TEMPLATE_CLUSTER_ROLE_BINDING_NAME, nextRoleBinding);
            String image = "image: " + imagePath;
            content = content.replaceAll(TEMPLATE_OPERATOR_IMAGE, image);
            LOG.info("Create or replace by yaml to create operator for namespace {} with image {}", (Object)namespace, (Object)imagePath);
            this.k8sDriver.createOrReplaceByYaml(content);
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadResourceQuota(String namespace, int cpuLimit, int memoryLimit) throws HugeException {
        Yaml yaml = new Yaml();
        FileInputStream inputStream = null;
        namespace = namespace.replace("_", "-").toLowerCase();
        try {
            String fileName = (String)CoreOptions.K8S_QUOTA_TEMPLATE.defaultValue();
            inputStream = new FileInputStream(fileName);
            Map quotaMap = (Map)yaml.load((InputStream)inputStream);
            Map metaData = (Map)quotaMap.get("metadata");
            Map spec = (Map)quotaMap.get("spec");
            Map hard = (Map)spec.get("hard");
            metaData.put("name", namespace + "-resource-quota");
            String cpuLimitStr = String.valueOf(cpuLimit);
            String memLimitStr = memoryLimit + "Gi";
            hard.put("requests.cpu", cpuLimitStr);
            hard.put("limits.cpu", cpuLimitStr);
            hard.put("requests.memory", memLimitStr);
            hard.put("limits.memory", memLimitStr);
            StringWriter writer = new StringWriter();
            yaml.dump((Object)quotaMap, (Writer)writer);
            String yamlStr = writer.toString();
            this.k8sDriver.createOrReplaceResourceQuota(namespace, yamlStr);
        }
        catch (Exception exception) {
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

