/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.masterelection;

import java.util.Objects;

public class ClusterRole {
    private final String node;
    private long clock;
    private final int epoch;
    private final String url;

    public ClusterRole(String node, String url, int epoch) {
        this(node, url, epoch, 1L);
    }

    public ClusterRole(String node, String url, int epoch, long clock) {
        this.node = node;
        this.url = url;
        this.epoch = epoch;
        this.clock = clock;
    }

    public void increaseClock() {
        ++this.clock;
    }

    public boolean isMaster(String node) {
        return Objects.equals(this.node, node);
    }

    public int epoch() {
        return this.epoch;
    }

    public long clock() {
        return this.clock;
    }

    public void clock(long clock) {
        this.clock = clock;
    }

    public String node() {
        return this.node;
    }

    public String url() {
        return this.url;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClusterRole)) {
            return false;
        }
        ClusterRole clusterRole = (ClusterRole)obj;
        return this.clock == clusterRole.clock && this.epoch == clusterRole.epoch && Objects.equals(this.node, clusterRole.node);
    }

    public int hashCode() {
        return Objects.hash(this.node, this.clock, this.epoch);
    }

    public String toString() {
        return "RoleStateData{node='" + this.node + "', clock=" + this.clock + ", epoch=" + this.epoch + "}";
    }
}

