/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.pool.impl;

public class MemoryPoolStats {
    private final String memoryPoolName;
    private final MemoryPoolType memoryPoolType;
    private long maxCapacity;
    private long usedBytes;
    private long cumulativeBytes;
    private long allocatedBytes;
    private long numShrinks;
    private long numExpands;
    private long numAborts;

    public MemoryPoolStats(String MemoryPoolName, MemoryPoolType memoryPoolType) {
        this.memoryPoolName = MemoryPoolName;
        this.memoryPoolType = memoryPoolType;
    }

    public String toString() {
        switch (this.memoryPoolType) {
            case TASK: {
                return String.format("%s: {usedBytes[%d], cumulativeBytes[%d], allocatedBytes[%d], numShrinks[%d], numAborts[%d]}.", this.memoryPoolName, this.usedBytes, this.cumulativeBytes, this.allocatedBytes, this.numShrinks, this.numAborts);
            }
            case OPERATOR: {
                return String.format("%s: {usedBytes[%d], cumulativeBytes[%d], allocatedBytes[%d], numShrinks[%d], numExpands[%d], numAborts[%d]}.", this.memoryPoolName, this.usedBytes, this.cumulativeBytes, this.allocatedBytes, this.numShrinks, this.numExpands, this.numAborts);
            }
        }
        return String.format("%s: {maxCapacity[%d], usedBytes[%d],cumulativeBytes[%d], allocatedBytes[%d], numShrinks[%d], numExpands[%d], numAborts[%d]}.", this.memoryPoolName, this.maxCapacity, this.usedBytes, this.cumulativeBytes, this.allocatedBytes, this.numShrinks, this.numExpands, this.numAborts);
    }

    public String getMemoryPoolName() {
        return this.memoryPoolName;
    }

    public long getUsedBytes() {
        return this.usedBytes;
    }

    public void setUsedBytes(long usedBytes) {
        this.usedBytes = usedBytes;
    }

    public long getCumulativeBytes() {
        return this.cumulativeBytes;
    }

    public void setCumulativeBytes(long cumulativeBytes) {
        this.cumulativeBytes = cumulativeBytes;
    }

    public long getAllocatedBytes() {
        return this.allocatedBytes;
    }

    public void setAllocatedBytes(long allocatedBytes) {
        this.allocatedBytes = allocatedBytes;
    }

    public long getNumShrinks() {
        return this.numShrinks;
    }

    public void setNumShrinks(long numShrinks) {
        this.numShrinks = numShrinks;
    }

    public long getNumExpands() {
        return this.numExpands;
    }

    public void setNumExpands(long numExpands) {
        this.numExpands = numExpands;
    }

    public long getNumAborts() {
        return this.numAborts;
    }

    public void setNumAborts(long numAborts) {
        this.numAborts = numAborts;
    }

    public long getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(long maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public static enum MemoryPoolType {
        QUERY(0),
        TASK(1),
        OPERATOR(2),
        UNKNOWN(3);

        private final int code;

        private MemoryPoolType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

