/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public class OffHeapMemoryUtil {
    private static final Logger LOG;
    private static final Unsafe UNSAFE;

    public static long allocateObjectToOffHeap(Object obj) {
        long size = OffHeapMemoryUtil.sizeOf(obj);
        System.out.println(size);
        long address = OffHeapMemoryUtil.getUnsafe().allocateMemory(size);
        OffHeapMemoryUtil.getUnsafe().copyMemory(obj, 0L, null, address, size);
        return address;
    }

    public static <T> T retrieveObjectFromOffHeap(Class<T> clazz, long address) throws NoSuchFieldException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        T pointer = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        long offset = OffHeapMemoryUtil.getUnsafe().objectFieldOffset(clazz.getDeclaredField("pointer"));
        OffHeapMemoryUtil.getUnsafe().putLong(pointer, offset, address);
        return pointer;
    }

    public static void freeOffHeapMemory(long address) {
        OffHeapMemoryUtil.getUnsafe().freeMemory(address);
    }

    private static Unsafe getUnsafe() {
        return UNSAFE;
    }

    private static long sizeOf(Object object) {
        Unsafe unsafe = OffHeapMemoryUtil.getUnsafe();
        return unsafe.getAddress(OffHeapMemoryUtil.normalize(unsafe.getInt(object, 4L)) + 8L);
    }

    private static long normalize(int value) {
        if (value >= 0) {
            return value;
        }
        return 0xFFFFFFFFL & (long)value;
    }

    static {
        Unsafe unsafe;
        LOG = LoggerFactory.getLogger(OffHeapMemoryUtil.class);
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            unsafe = (Unsafe)unsafeField.get(null);
        }
        catch (Throwable cause) {
            LOG.warn("sun.misc.Unsafe.theUnsafe: unavailable.", cause);
            throw new UnsupportedOperationException("Unsafe is not supported in this platform.");
        }
        UNSAFE = unsafe;
    }
}

