/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.task;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.job.EphemeralJob;
import org.apache.hugegraph.job.EphemeralJobBuilder;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class EphemeralJobQueue {
    private static final Logger LOG = Log.logger(EphemeralJobQueue.class);
    private static final long CAPACITY = 50000L;
    private final BlockingQueue<EphemeralJob<?>> pendingQueue;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final HugeGraphParams graph;

    public EphemeralJobQueue(HugeGraphParams graph) {
        this.graph = graph;
        this.pendingQueue = new ArrayBlockingQueue(50000);
    }

    public boolean add(EphemeralJob<?> job) {
        if (job == null) {
            return false;
        }
        if (!this.pendingQueue.offer(job)) {
            LOG.warn("The pending queue of EphemeralJobQueue is full, {} job will be ignored", (Object)job.type());
            return false;
        }
        this.reScheduleIfNeeded();
        return true;
    }

    protected HugeGraphParams params() {
        return this.graph;
    }

    protected void clear() {
        this.pendingQueue.clear();
    }

    protected EphemeralJob<?> poll() {
        return (EphemeralJob)this.pendingQueue.poll();
    }

    public void consumeComplete() {
        this.state.compareAndSet(State.EXECUTE, State.INIT);
    }

    public void reScheduleIfNeeded() {
        if (this.state.compareAndSet(State.INIT, State.EXECUTE)) {
            try {
                BatchEphemeralJob job = new BatchEphemeralJob(this);
                EphemeralJobBuilder.of(this.graph.graph()).name("batch-ephemeral-job").job(job).schedule();
            }
            catch (Throwable e) {
                LOG.warn("Failed to schedule BatchEphemeralJob", e);
                this.pendingQueue.clear();
                this.state.compareAndSet(State.EXECUTE, State.INIT);
            }
        }
    }

    public boolean isEmpty() {
        return this.pendingQueue.isEmpty();
    }

    public static interface Reduce<T> {
        public T reduce(T var1, T var2);
    }

    public static class BatchEphemeralJob
    extends EphemeralJob<Object> {
        private static final long PAGE_SIZE = 500L;
        private static final String BATCH_EPHEMERAL_JOB = "batch-ephemeral-job";
        private static final long MAX_CONSUME_COUNT = 1000L;
        private WeakReference<EphemeralJobQueue> queueWeakReference;

        public BatchEphemeralJob(EphemeralJobQueue queue) {
            this.queueWeakReference = new WeakReference<EphemeralJobQueue>(queue);
        }

        @Override
        public String type() {
            return BATCH_EPHEMERAL_JOB;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute() throws Exception {
            boolean stop = false;
            Object result = null;
            int consumeCount = 0;
            InterruptedException interruptedException = null;
            ArrayList batchJobs = new ArrayList();
            while (!stop) {
                EphemeralJobQueue queue;
                if (interruptedException == null && Thread.currentThread().isInterrupted()) {
                    interruptedException = new InterruptedException();
                }
                if ((queue = (EphemeralJobQueue)this.queueWeakReference.get()) == null) {
                    stop = true;
                    continue;
                }
                if (queue.isEmpty() || (long)consumeCount > 1000L || interruptedException != null) {
                    queue.consumeComplete();
                    stop = true;
                    if (queue.isEmpty()) continue;
                    queue.reScheduleIfNeeded();
                    continue;
                }
                try {
                    while (!queue.isEmpty() && (long)batchJobs.size() < 500L) {
                        EphemeralJob<?> job = queue.poll();
                        if (job == null) continue;
                        batchJobs.add(job);
                    }
                    if (batchJobs.isEmpty()) continue;
                    consumeCount += batchJobs.size();
                    result = this.executeBatchJob(batchJobs, result);
                }
                catch (InterruptedException e) {
                    interruptedException = e;
                }
                finally {
                    batchJobs.clear();
                }
            }
            if (interruptedException != null) {
                Thread.currentThread().interrupt();
                throw interruptedException;
            }
            return result;
        }

        private Object executeBatchJob(List<EphemeralJob<?>> jobs, Object prevResult) throws Exception {
            GraphTransaction graphTx = this.params().systemTransaction();
            GraphTransaction systemTx = this.params().graphTransaction();
            Object result = prevResult;
            for (EphemeralJob<?> job : jobs) {
                this.initJob(job);
                Object obj = job.call();
                if (!(job instanceof Reduce)) continue;
                result = ((Reduce)((Object)job)).reduce(result, obj);
            }
            graphTx.commit();
            systemTx.commit();
            return result;
        }

        private void initJob(EphemeralJob<?> job) {
            job.graph(this.graph());
            job.params(this.params());
        }

        @Override
        public Object call() throws Exception {
            try {
                return super.call();
            }
            catch (Throwable e) {
                LOG.warn("Failed to execute BatchEphemeralJob", e);
                EphemeralJobQueue queue = (EphemeralJobQueue)this.queueWeakReference.get();
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    if (queue != null) {
                        queue.clear();
                        queue.consumeComplete();
                    }
                    throw e;
                }
                if (queue != null) {
                    queue.consumeComplete();
                    if (!queue.isEmpty()) {
                        queue.reScheduleIfNeeded();
                    }
                }
                throw e;
            }
        }
    }

    private static enum State {
        INIT,
        EXECUTE;

    }
}

