/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import com.alipay.remoting.rpc.RpcServer;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotAuthorizedException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.security.sasl.AuthenticationException;
import org.apache.commons.configuration2.Configuration;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.auth.AuthContext;
import org.apache.hugegraph.auth.AuthManager;
import org.apache.hugegraph.auth.HugeAccess;
import org.apache.hugegraph.auth.HugeAuthenticator;
import org.apache.hugegraph.auth.HugeBelong;
import org.apache.hugegraph.auth.HugeGroup;
import org.apache.hugegraph.auth.HugePermission;
import org.apache.hugegraph.auth.HugeProject;
import org.apache.hugegraph.auth.HugeResource;
import org.apache.hugegraph.auth.HugeTarget;
import org.apache.hugegraph.auth.HugeUser;
import org.apache.hugegraph.auth.ResourceObject;
import org.apache.hugegraph.auth.ResourceType;
import org.apache.hugegraph.auth.RolePermission;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.auth.StandardAuthManager;
import org.apache.hugegraph.auth.UserWithRole;
import org.apache.hugegraph.backend.cache.Cache;
import org.apache.hugegraph.backend.cache.CacheManager;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.store.BackendFeatures;
import org.apache.hugegraph.backend.store.BackendStoreInfo;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.backend.store.raft.RaftGroupManager;
import org.apache.hugegraph.config.AuthOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.iterator.FilterIterator;
import org.apache.hugegraph.iterator.MapperIterator;
import org.apache.hugegraph.kvstore.KvStore;
import org.apache.hugegraph.masterelection.GlobalMasterInfo;
import org.apache.hugegraph.masterelection.RoleElectionStateMachine;
import org.apache.hugegraph.rpc.RpcServiceConfig4Client;
import org.apache.hugegraph.rpc.RpcServiceConfig4Server;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.schema.SchemaLabel;
import org.apache.hugegraph.schema.SchemaManager;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeFeatures;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.task.ServerInfoManager;
import org.apache.hugegraph.task.TaskManager;
import org.apache.hugegraph.task.TaskScheduler;
import org.apache.hugegraph.task.TaskStatus;
import org.apache.hugegraph.traversal.optimize.HugeScriptTraversal;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.Nameable;
import org.apache.hugegraph.type.define.GraphMode;
import org.apache.hugegraph.type.define.GraphReadMode;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.RateLimiter;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Script;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.translator.GroovyTranslator;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.slf4j.Logger;

public final class HugeGraphAuthProxy
implements HugeGraph {
    private static final Logger LOG = Log.logger(HugeGraphAuthProxy.class);
    private static final ThreadLocal<Context> CONTEXTS = new InheritableThreadLocal<Context>();
    private static final ThreadLocal<String> REQUEST_GRAPH_SPACE = new ThreadLocal();
    private final Cache<Id, UserWithRole> usersRoleCache;
    private final Cache<Id, RateLimiter> auditLimiters;
    private final double auditLogMaxRate;
    private final HugeGraph hugegraph;
    private final TaskSchedulerProxy taskScheduler;
    private final AuthManagerProxy authManager;

    public HugeGraphAuthProxy(HugeGraph hugegraph) {
        LOG.info("Wrap graph '{}' with HugeGraphAuthProxy", (Object)hugegraph.spaceGraphName());
        HugeConfig config = (HugeConfig)hugegraph.configuration();
        long expired = (Long)config.get((TypedOption)AuthOptions.AUTH_CACHE_EXPIRE);
        long capacity = (Long)config.get((TypedOption)AuthOptions.AUTH_CACHE_CAPACITY);
        this.hugegraph = hugegraph;
        this.taskScheduler = new TaskSchedulerProxy(hugegraph.taskScheduler());
        this.authManager = new AuthManagerProxy(hugegraph.authManager());
        this.auditLimiters = this.cache("audit-log-limiter", capacity, -1L);
        this.usersRoleCache = this.cache("users-role", capacity, expired);
        this.hugegraph.proxy((HugeGraph)this);
        this.auditLogMaxRate = (Double)config.get((TypedOption)AuthOptions.AUTH_AUDIT_LOG_RATE);
        LOG.info("Audit log rate limit is {}/s", (Object)this.auditLogMaxRate);
    }

    static Context setContext(Context context) {
        Context old = CONTEXTS.get();
        CONTEXTS.set(context);
        return old;
    }

    public static void resetContext() {
        CONTEXTS.remove();
        REQUEST_GRAPH_SPACE.remove();
    }

    public static void resetSpaceContext() {
        CONTEXTS.remove();
        REQUEST_GRAPH_SPACE.remove();
    }

    public static String getRequestGraphSpace() {
        return REQUEST_GRAPH_SPACE.get();
    }

    public static void setRequestGraphSpace(String graphSpace) {
        REQUEST_GRAPH_SPACE.set(graphSpace);
    }

    public static Context setAdmin() {
        Context old = HugeGraphAuthProxy.getContext();
        AuthContext.useAdmin();
        return old;
    }

    public static Context getContext() {
        String taskContext = TaskManager.getContext();
        HugeAuthenticator.User user = HugeAuthenticator.User.fromJson(taskContext);
        if (user != null) {
            return new Context(user);
        }
        return CONTEXTS.get();
    }

    private static String getContextString() {
        Context context = HugeGraphAuthProxy.getContext();
        if (context == null) {
            return null;
        }
        return context.user().toJson();
    }

    static void logUser(HugeAuthenticator.User user, String path) {
        LOG.info("User '{}' login from client [{}] with path '{}'", new Object[]{user.username(), user.client(), path});
    }

    public HugeGraph hugegraph() {
        this.verifyAdminPermission();
        return this.hugegraph;
    }

    public KvStore kvStore() {
        return this.hugegraph.kvStore();
    }

    public void kvStore(KvStore kvStore) {
        this.hugegraph.kvStore(kvStore);
    }

    public <C extends GraphComputer> C compute(Class<C> clazz) throws IllegalArgumentException {
        this.verifyAnyPermission();
        return (C)this.hugegraph.compute(clazz);
    }

    public GraphComputer compute() throws IllegalArgumentException {
        this.verifyAnyPermission();
        return this.hugegraph.compute();
    }

    public GraphTraversalSource traversal() {
        return new GraphTraversalSourceProxy((Graph)this);
    }

    public <I extends Io> I io(Io.Builder<I> builder) {
        this.verifyAnyPermission();
        return (I)this.hugegraph.io(builder);
    }

    public SchemaManager schema() {
        SchemaManager schema = this.hugegraph.schema();
        schema.proxy((HugeGraph)this);
        return schema;
    }

    public BackendStoreProvider storeProvider() {
        return this.hugegraph.storeProvider();
    }

    public Id getNextId(HugeType type) {
        if (type == HugeType.TASK) {
            this.verifyPermission(HugePermission.WRITE, ResourceType.TASK);
        } else {
            this.verifyAdminPermission();
        }
        return this.hugegraph.getNextId(type);
    }

    public Id addPropertyKey(PropertyKey key) {
        this.verifySchemaPermission(HugePermission.WRITE, (SchemaElement)key);
        return this.hugegraph.addPropertyKey(key);
    }

    public void updatePropertyKey(PropertyKey key) {
        this.verifySchemaPermission(HugePermission.WRITE, (SchemaElement)key);
        this.hugegraph.updatePropertyKey(key);
    }

    public Id removePropertyKey(Id key) {
        PropertyKey pkey = this.hugegraph.propertyKey(key);
        this.verifySchemaPermission(HugePermission.DELETE, (SchemaElement)pkey);
        return this.hugegraph.removePropertyKey(key);
    }

    public Id clearPropertyKey(PropertyKey propertyKey) {
        this.verifySchemaPermission(HugePermission.DELETE, (SchemaElement)propertyKey);
        return this.hugegraph.clearPropertyKey(propertyKey);
    }

    public Collection<PropertyKey> propertyKeys() {
        Collection pkeys = this.hugegraph.propertyKeys();
        return this.verifySchemaPermission(HugePermission.READ, pkeys);
    }

    public PropertyKey propertyKey(String key) {
        return this.verifySchemaPermission(HugePermission.READ, () -> this.hugegraph.propertyKey(key));
    }

    public PropertyKey propertyKey(Id key) {
        return this.verifySchemaPermission(HugePermission.READ, () -> this.hugegraph.propertyKey(key));
    }

    public boolean existsPropertyKey(String key) {
        this.verifyNameExistsPermission(ResourceType.PROPERTY_KEY, key);
        return this.hugegraph.existsPropertyKey(key);
    }

    public void addVertexLabel(VertexLabel label) {
        this.verifySchemaPermission(HugePermission.WRITE, (SchemaElement)label);
        this.hugegraph.addVertexLabel(label);
    }

    public void updateVertexLabel(VertexLabel label) {
        this.verifySchemaPermission(HugePermission.WRITE, (SchemaElement)label);
        this.hugegraph.updateVertexLabel(label);
    }

    public Id removeVertexLabel(Id id) {
        VertexLabel label = this.hugegraph.vertexLabel(id);
        this.verifySchemaPermission(HugePermission.DELETE, (SchemaElement)label);
        return this.hugegraph.removeVertexLabel(id);
    }

    public Collection<VertexLabel> vertexLabels() {
        Collection labels = this.hugegraph.vertexLabels();
        return this.verifySchemaPermission(HugePermission.READ, labels);
    }

    public VertexLabel vertexLabel(String label) {
        return this.verifySchemaPermission(HugePermission.READ, () -> this.hugegraph.vertexLabel(label));
    }

    public VertexLabel vertexLabel(Id label) {
        return this.verifySchemaPermission(HugePermission.READ, () -> this.hugegraph.vertexLabel(label));
    }

    public VertexLabel vertexLabelOrNone(Id label) {
        return this.verifySchemaPermission(HugePermission.READ, () -> this.hugegraph.vertexLabelOrNone(label));
    }

    public boolean existsVertexLabel(String label) {
        this.verifyNameExistsPermission(ResourceType.VERTEX_LABEL, label);
        return this.hugegraph.existsVertexLabel(label);
    }

    public boolean existsLinkLabel(Id vertexLabel) {
        this.verifyNameExistsPermission(ResourceType.VERTEX_LABEL, this.vertexLabel(vertexLabel).name());
        return this.hugegraph.existsLinkLabel(vertexLabel);
    }

    public void addEdgeLabel(EdgeLabel label) {
        this.verifySchemaPermission(HugePermission.WRITE, (SchemaElement)label);
        this.hugegraph.addEdgeLabel(label);
    }

    public void updateEdgeLabel(EdgeLabel label) {
        this.verifySchemaPermission(HugePermission.WRITE, (SchemaElement)label);
        this.hugegraph.updateEdgeLabel(label);
    }

    public Id removeEdgeLabel(Id id) {
        EdgeLabel label = this.hugegraph.edgeLabel(id);
        this.verifySchemaPermission(HugePermission.DELETE, (SchemaElement)label);
        return this.hugegraph.removeEdgeLabel(id);
    }

    public Collection<EdgeLabel> edgeLabels() {
        Collection labels = this.hugegraph.edgeLabels();
        return this.verifySchemaPermission(HugePermission.READ, labels);
    }

    public EdgeLabel edgeLabel(String label) {
        return this.verifySchemaPermission(HugePermission.READ, () -> this.hugegraph.edgeLabel(label));
    }

    public EdgeLabel edgeLabel(Id label) {
        return this.verifySchemaPermission(HugePermission.READ, () -> this.hugegraph.edgeLabel(label));
    }

    public EdgeLabel edgeLabelOrNone(Id label) {
        return this.verifySchemaPermission(HugePermission.READ, () -> this.hugegraph.edgeLabelOrNone(label));
    }

    public boolean existsEdgeLabel(String label) {
        this.verifyNameExistsPermission(ResourceType.EDGE_LABEL, label);
        return this.hugegraph.existsEdgeLabel(label);
    }

    public void addIndexLabel(SchemaLabel schemaLabel, IndexLabel indexLabel) {
        this.verifySchemaPermission(HugePermission.WRITE, (SchemaElement)indexLabel);
        this.hugegraph.addIndexLabel(schemaLabel, indexLabel);
    }

    public void updateIndexLabel(IndexLabel label) {
        this.verifySchemaPermission(HugePermission.WRITE, (SchemaElement)label);
        this.hugegraph.updateIndexLabel(label);
    }

    public Id removeIndexLabel(Id id) {
        IndexLabel label = this.hugegraph.indexLabel(id);
        this.verifySchemaPermission(HugePermission.DELETE, (SchemaElement)label);
        return this.hugegraph.removeIndexLabel(id);
    }

    public Id rebuildIndex(SchemaElement schema) {
        if (schema.type() == HugeType.INDEX_LABEL) {
            this.verifySchemaPermission(HugePermission.WRITE, schema);
        } else {
            SchemaLabel label = (SchemaLabel)schema;
            for (Id il : label.indexLabels()) {
                IndexLabel indexLabel = this.hugegraph.indexLabel(il);
                this.verifySchemaPermission(HugePermission.WRITE, (SchemaElement)indexLabel);
            }
        }
        return this.hugegraph.rebuildIndex(schema);
    }

    public Collection<IndexLabel> indexLabels() {
        Collection labels = this.hugegraph.indexLabels();
        return this.verifySchemaPermission(HugePermission.READ, labels);
    }

    public IndexLabel indexLabel(String label) {
        return this.verifySchemaPermission(HugePermission.READ, () -> this.hugegraph.indexLabel(label));
    }

    public IndexLabel indexLabel(Id label) {
        return this.verifySchemaPermission(HugePermission.READ, () -> this.hugegraph.indexLabel(label));
    }

    public boolean existsIndexLabel(String label) {
        this.verifyNameExistsPermission(ResourceType.INDEX_LABEL, label);
        return this.hugegraph.existsIndexLabel(label);
    }

    public Vertex addVertex(Object ... keyValues) {
        return (Vertex)this.verifyElemPermission(HugePermission.WRITE, () -> (HugeVertex)this.hugegraph.addVertex(keyValues));
    }

    public void removeVertex(Vertex vertex) {
        this.verifyElemPermission(HugePermission.DELETE, (Element)vertex);
        this.hugegraph.removeVertex(vertex);
    }

    public void removeVertex(String label, Object id) {
        this.removeVertex(this.vertex(id));
    }

    public <V> void addVertexProperty(VertexProperty<V> property) {
        this.verifyElemPermission(HugePermission.WRITE, (Element)property.element());
        this.hugegraph.addVertexProperty(property);
    }

    public <V> void removeVertexProperty(VertexProperty<V> property) {
        this.verifyElemPermission(HugePermission.WRITE, (Element)property.element());
        this.hugegraph.removeVertexProperty(property);
    }

    public Edge addEdge(Edge edge) {
        return (Edge)this.verifyElemPermission(HugePermission.WRITE, () -> (HugeEdge)this.hugegraph.addEdge(edge));
    }

    public void canAddEdge(Edge edge) {
        this.verifyElemPermission(HugePermission.WRITE, () -> (HugeEdge)edge);
    }

    public void removeEdge(Edge edge) {
        this.verifyElemPermission(HugePermission.DELETE, (Element)edge);
        this.hugegraph.removeEdge(edge);
    }

    public void removeEdge(String label, Object id) {
        this.removeEdge(this.edge(id));
    }

    public <V> void addEdgeProperty(Property<V> property) {
        this.verifyElemPermission(HugePermission.WRITE, property.element());
        this.hugegraph.addEdgeProperty(property);
    }

    public <V> void removeEdgeProperty(Property<V> property) {
        this.verifyElemPermission(HugePermission.WRITE, property.element());
        this.hugegraph.removeEdgeProperty(property);
    }

    public Iterator<Vertex> vertices(Query query) {
        return this.verifyElemPermission(HugePermission.READ, this.hugegraph.vertices(query));
    }

    public Iterator<Vertex> vertices(Object ... objects) {
        return this.verifyElemPermission(HugePermission.READ, this.hugegraph.vertices(objects));
    }

    public Vertex vertex(Object object) {
        Vertex vertex = this.hugegraph.vertex(object);
        this.verifyElemPermission(HugePermission.READ, (Element)vertex);
        return vertex;
    }

    public Iterator<Vertex> adjacentVertex(Object id) {
        return this.verifyElemPermission(HugePermission.READ, this.hugegraph.adjacentVertex(id));
    }

    public Iterator<Vertex> adjacentVertices(Iterator<Edge> edges) {
        Iterator vertices = this.hugegraph.adjacentVertices(edges);
        return this.verifyElemPermission(HugePermission.READ, vertices);
    }

    public boolean checkAdjacentVertexExist() {
        this.verifyAnyPermission();
        return this.hugegraph.checkAdjacentVertexExist();
    }

    public Iterator<Edge> edges(Query query) {
        return this.verifyElemPermission(HugePermission.READ, this.hugegraph.edges(query));
    }

    public Iterator<Edge> edges(Object ... objects) {
        return this.verifyElemPermission(HugePermission.READ, this.hugegraph.edges(objects));
    }

    public Edge edge(Object id) {
        Edge edge = this.hugegraph.edge(id);
        this.verifyElemPermission(HugePermission.READ, (Element)edge);
        return edge;
    }

    public Iterator<Edge> adjacentEdges(Id vertexId) {
        Iterator edges = this.hugegraph.adjacentEdges(vertexId);
        return this.verifyElemPermission(HugePermission.READ, edges);
    }

    public Number queryNumber(Query query) {
        ResourceType resType;
        if (query.resultType().isVertex()) {
            resType = ResourceType.VERTEX_AGGR;
        } else {
            assert (query.resultType().isEdge());
            resType = ResourceType.EDGE_AGGR;
        }
        this.verifyPermission(HugePermission.READ, resType);
        return this.hugegraph.queryNumber(query);
    }

    public String graphSpace() {
        return this.hugegraph.graphSpace();
    }

    public void graphSpace(String graphSpace) {
        this.hugegraph.graphSpace(graphSpace);
    }

    public Transaction tx() {
        return this.hugegraph.tx();
    }

    public void close() throws Exception {
        this.verifyAdminPermission();
        this.hugegraph.close();
    }

    public HugeFeatures features() {
        return this.hugegraph.features();
    }

    public Graph.Variables variables() {
        return new VariablesProxy(this.hugegraph.variables());
    }

    public HugeConfig configuration() {
        this.verifyAdminPermission();
        return (HugeConfig)this.hugegraph.configuration();
    }

    public String toString() {
        this.verifyAnyPermission();
        return this.hugegraph.toString();
    }

    public void proxy(HugeGraph graph) {
        throw new NotSupportException("Graph.proxy()");
    }

    public boolean sameAs(HugeGraph graph) {
        if (graph instanceof HugeGraphAuthProxy) {
            graph = ((HugeGraphAuthProxy)graph).hugegraph;
        }
        return this.hugegraph.sameAs(graph);
    }

    public long now() {
        return this.hugegraph.now();
    }

    public <K, V> V option(TypedOption<K, V> option) {
        this.verifyAnyPermission();
        return (V)this.hugegraph.option(option);
    }

    public String name() {
        this.verifyAnyPermission();
        return this.hugegraph.name();
    }

    public String spaceGraphName() {
        return this.hugegraph.spaceGraphName();
    }

    public String backend() {
        this.verifyAnyPermission();
        return this.hugegraph.backend();
    }

    public BackendStoreInfo backendStoreInfo() {
        this.verifyAdminPermission();
        return this.hugegraph.backendStoreInfo();
    }

    public BackendFeatures backendStoreFeatures() {
        this.verifyAnyPermission();
        return this.hugegraph.backendStoreFeatures();
    }

    public GraphMode mode() {
        this.verifyStatusPermission();
        return this.hugegraph.mode();
    }

    public void mode(GraphMode mode) {
        this.verifyPermission(HugePermission.WRITE, ResourceType.STATUS);
        this.hugegraph.mode(mode);
    }

    public GraphReadMode readMode() {
        this.verifyStatusPermission();
        return this.hugegraph.readMode();
    }

    public void readMode(GraphReadMode readMode) {
        this.verifyPermission(HugePermission.WRITE, ResourceType.STATUS);
        this.hugegraph.readMode(readMode);
    }

    public void waitReady(RpcServer rpcServer) {
        this.verifyAnyPermission();
        this.hugegraph.waitReady(rpcServer);
    }

    public void waitStarted() {
        this.verifyAnyPermission();
        this.hugegraph.waitStarted();
    }

    public void serverStarted(GlobalMasterInfo nodeInfo) {
        this.verifyAdminPermission();
        this.hugegraph.serverStarted(nodeInfo);
    }

    public boolean started() {
        this.verifyAdminPermission();
        return this.hugegraph.started();
    }

    public void started(boolean started) {
        this.verifyAdminPermission();
        this.hugegraph.started(started);
    }

    public boolean closed() {
        this.verifyAdminPermission();
        return this.hugegraph.closed();
    }

    public <R> R metadata(HugeType type, String meta, Object ... args) {
        this.verifyNamePermission(HugePermission.EXECUTE, ResourceType.META, meta);
        return (R)this.hugegraph.metadata(type, meta, args);
    }

    public TaskScheduler taskScheduler() {
        return this.taskScheduler;
    }

    public AuthManager authManager() {
        return this.authManager;
    }

    public RoleElectionStateMachine roleElectionStateMachine() {
        this.verifyAdminPermission();
        return this.hugegraph.roleElectionStateMachine();
    }

    public void switchAuthManager(AuthManager authManager) {
        this.verifyAdminPermission();
        this.authManager.switchAuthManager(authManager);
    }

    public RaftGroupManager raftGroupManager() {
        this.verifyAdminPermission();
        return this.hugegraph.raftGroupManager();
    }

    public void registerRpcServices(RpcServiceConfig4Server serverConfig, RpcServiceConfig4Client clientConfig) {
        this.verifyAdminPermission();
        this.hugegraph.registerRpcServices(serverConfig, clientConfig);
    }

    public void initBackend() {
        this.verifyAdminPermission();
        this.hugegraph.initBackend();
    }

    public void clearBackend() {
        this.verifyAdminPermission();
        this.hugegraph.clearBackend();
    }

    public void truncateBackend() {
        this.verifyAdminPermission();
        AuthManager userManager = this.hugegraph.authManager();
        HugeUser admin = userManager.findUser("admin");
        try {
            this.hugegraph.truncateBackend();
        }
        finally {
            if (admin != null && userManager.findUser("admin") == null && StandardAuthManager.isLocal((AuthManager)userManager)) {
                userManager.createUser(admin);
            }
        }
    }

    public void initSystemInfo() {
        this.verifyAdminPermission();
        this.hugegraph.initSystemInfo();
    }

    public void createSnapshot() {
        this.verifyPermission(HugePermission.WRITE, ResourceType.STATUS);
        this.hugegraph.createSnapshot();
    }

    public void resumeSnapshot() {
        this.verifyPermission(HugePermission.WRITE, ResourceType.STATUS);
        this.hugegraph.resumeSnapshot();
    }

    public void create(String configPath, GlobalMasterInfo nodeInfo) {
        this.verifyPermission(HugePermission.WRITE, ResourceType.STATUS);
        this.hugegraph.create(configPath, nodeInfo);
    }

    public void drop() {
        this.verifyPermission(HugePermission.WRITE, ResourceType.STATUS);
        this.hugegraph.drop();
    }

    public HugeConfig cloneConfig(String newGraph) {
        this.verifyPermission(HugePermission.WRITE, ResourceType.STATUS);
        return this.hugegraph.cloneConfig(newGraph);
    }

    public String nickname() {
        return this.hugegraph.nickname();
    }

    public void nickname(String nickname) {
        this.verifyAnyPermission();
        this.hugegraph.nickname(nickname);
    }

    public String creator() {
        this.verifyAnyPermission();
        return this.hugegraph.creator();
    }

    public void creator(String creator) {
        this.verifyAnyPermission();
        this.hugegraph.creator(creator);
    }

    public Date createTime() {
        this.verifyAnyPermission();
        return this.hugegraph.createTime();
    }

    public void createTime(Date createTime) {
        this.verifyAnyPermission();
        this.hugegraph.createTime(createTime);
    }

    public Date updateTime() {
        this.verifyAnyPermission();
        return this.hugegraph.updateTime();
    }

    public void updateTime(Date updateTime) {
        this.verifyAnyPermission();
        this.hugegraph.updateTime(updateTime);
    }

    private <V> Cache<Id, V> cache(String prefix, long capacity, long expiredTime) {
        String name = prefix + "-" + this.hugegraph.spaceGraphName();
        Cache cache = CacheManager.instance().cache(name, capacity);
        if (expiredTime > 0L) {
            cache.expire(Duration.ofSeconds(expiredTime).toMillis());
        } else {
            cache.expire(expiredTime);
        }
        return cache;
    }

    private void verifyAdminPermission() {
        this.verifyPermission(HugePermission.ADMIN, ResourceType.ROOT);
    }

    private void verifyStatusPermission() {
        this.verifyPermission(HugePermission.READ, ResourceType.STATUS);
    }

    private void verifyAnyPermission() {
        this.verifyPermission(HugePermission.READ, ResourceType.NONE);
    }

    private void verifyPermission(HugePermission actionPerm, ResourceType resType) {
        this.verifyResPermission(actionPerm, true, () -> {
            String graph = this.hugegraph.name();
            String graphSpace = this.graphSpace();
            String requestGraphSpace = HugeGraphAuthProxy.getRequestGraphSpace();
            if (requestGraphSpace != null) {
                graphSpace = requestGraphSpace;
                LOG.debug("Using requestGraphSpace: {}", (Object)graphSpace);
            }
            HugeResource.NameObject elem = HugeResource.NameObject.ANY;
            return ResourceObject.of((String)graphSpace, (String)graph, (ResourceType)resType, (Nameable)elem);
        });
    }

    private <V extends SchemaDefine.AuthElement> V verifyUserPermission(HugePermission actionPerm, V elementFetcher) {
        return (V)this.verifyUserPermission(actionPerm, true, () -> elementFetcher);
    }

    private <V extends SchemaDefine.AuthElement> List<V> verifyUserPermission(HugePermission actionPerm, List<V> elems) {
        ArrayList<SchemaDefine.AuthElement> results = new ArrayList<SchemaDefine.AuthElement>();
        for (SchemaDefine.AuthElement elem : elems) {
            SchemaDefine.AuthElement r = this.verifyUserPermission(actionPerm, false, () -> elem);
            if (r == null) continue;
            results.add(r);
        }
        return results;
    }

    private <V extends SchemaDefine.AuthElement> V verifyUserPermission(HugePermission actionPerm, boolean throwIfNoPerm, Supplier<V> elementFetcher) {
        return (V)((SchemaDefine.AuthElement)this.verifyResPermission(actionPerm, throwIfNoPerm, () -> {
            String graph = this.hugegraph.name();
            SchemaDefine.AuthElement elem = (SchemaDefine.AuthElement)elementFetcher.get();
            String graphSpace = this.graphSpace();
            String requestGraphSpace = HugeGraphAuthProxy.getRequestGraphSpace();
            LOG.debug("verifyUserPermission: elem.type()={}, graphSpace={}, requestGraphSpace={}, isGrantOrUser={}", new Object[]{elem.type(), graphSpace, requestGraphSpace, elem.type().isGrantOrUser()});
            if (requestGraphSpace != null) {
                graphSpace = requestGraphSpace;
                LOG.debug("Using requestGraphSpace: {}", (Object)graphSpace);
            }
            ResourceObject r = ResourceObject.of((String)graphSpace, (String)graph, (SchemaDefine.AuthElement)elem);
            return r;
        }));
    }

    private void verifyElemPermission(HugePermission actionPerm, Element elem) {
        this.verifyElemPermission(actionPerm, true, () -> elem);
    }

    private <V extends HugeElement> V verifyElemPermission(HugePermission actionPerm, Supplier<V> elementFetcher) {
        return (V)((HugeElement)this.verifyElemPermission(actionPerm, true, elementFetcher));
    }

    private <V extends Element> Iterator<V> verifyElemPermission(HugePermission actionPerm, Iterator<V> elems) {
        return new FilterIterator(elems, elem -> {
            Element r = this.verifyElemPermission(actionPerm, false, () -> elem);
            return r != null;
        });
    }

    private <V extends Element> V verifyElemPermission(HugePermission actionPerm, boolean throwIfNoPerm, Supplier<V> elementFetcher) {
        return (V)((Element)this.verifyResPermission(actionPerm, throwIfNoPerm, () -> {
            String graph = this.hugegraph.name();
            HugeElement elem = (HugeElement)elementFetcher.get();
            ResourceObject r = ResourceObject.of((String)this.graphSpace(), (String)graph, (HugeElement)elem);
            return r;
        }));
    }

    private void verifyNameExistsPermission(ResourceType resType, String name) {
        this.verifyNamePermission(HugePermission.READ, resType, name);
    }

    private void verifyNamePermission(HugePermission actionPerm, ResourceType resType, String name) {
        this.verifyResPermission(actionPerm, true, () -> {
            String graph = this.hugegraph.name();
            HugeResource.NameObject elem = HugeResource.NameObject.of((String)name);
            String graphSpace = this.graphSpace();
            String requestGraphSpace = HugeGraphAuthProxy.getRequestGraphSpace();
            if (requestGraphSpace != null) {
                graphSpace = requestGraphSpace;
            }
            return ResourceObject.of((String)graphSpace, (String)graph, (ResourceType)resType, (Nameable)elem);
        });
    }

    private void verifySchemaPermission(HugePermission actionPerm, SchemaElement schema) {
        this.verifySchemaPermission(actionPerm, true, () -> schema);
    }

    private <V extends SchemaElement> Collection<V> verifySchemaPermission(HugePermission actionPerm, Collection<V> schemas) {
        ArrayList<SchemaElement> results = new ArrayList<SchemaElement>();
        for (SchemaElement schema : schemas) {
            SchemaElement r = this.verifySchemaPermission(actionPerm, false, () -> schema);
            if (r == null) continue;
            results.add(r);
        }
        return results;
    }

    private <V extends SchemaElement> V verifySchemaPermission(HugePermission actionPerm, Supplier<V> schemaFetcher) {
        return this.verifySchemaPermission(actionPerm, true, schemaFetcher);
    }

    private <V extends SchemaElement> V verifySchemaPermission(HugePermission actionPerm, boolean throwIfNoPerm, Supplier<V> schemaFetcher) {
        return (V)((SchemaElement)this.verifyResPermission(actionPerm, throwIfNoPerm, () -> {
            String graph = this.hugegraph.name();
            SchemaElement elem = (SchemaElement)schemaFetcher.get();
            ResourceObject r = ResourceObject.of((String)this.graphSpace(), (String)graph, (SchemaElement)elem);
            return r;
        }));
    }

    private <V> V verifyResPermission(HugePermission actionPerm, boolean throwIfNoPerm, Supplier<ResourceObject<V>> fetcher) {
        return this.verifyResPermission(actionPerm, throwIfNoPerm, fetcher, null);
    }

    private <V> V verifyResPermission(HugePermission actionPerm, boolean throwIfNoPerm, Supplier<ResourceObject<V>> fetcher, Supplier<Boolean> checker) {
        Context context = HugeGraphAuthProxy.getContext();
        E.checkState((context != null ? 1 : 0) != 0, (String)"Missing authentication context when verifying resource permission", (Object[])new Object[0]);
        String username = context.user().username();
        RolePermission role = context.user().role();
        ResourceObject<V> ro = fetcher.get();
        String action = actionPerm.string();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verify permission {} {} for user '{}' with role {}", new Object[]{action, ro, username, role});
        }
        Object result = ro.operated();
        if (!HugeAuthenticator.RolePerm.match((Object)role, actionPerm, ro)) {
            result = null;
        } else if (ro.type().isGrantOrUser()) {
            SchemaDefine.AuthElement element = (SchemaDefine.AuthElement)ro.operated();
            RolePermission grant = this.hugegraph.authManager().rolePermission(element);
            if (!HugeAuthenticator.RolePerm.match((Object)role, grant, ro)) {
                result = null;
            }
        }
        if (result != null && checker != null && !checker.get().booleanValue()) {
            result = null;
        }
        Id usrId = context.user().userId();
        RateLimiter auditLimiter = (RateLimiter)this.auditLimiters.getOrFetch((Object)usrId, id -> RateLimiter.create((double)this.auditLogMaxRate));
        if ((actionPerm != HugePermission.READ || !ro.type().isSchema()) && auditLimiter.tryAcquire()) {
            String status = result == null ? "denied" : "allowed";
            LOG.info("User '{}' is {} to {} {}", new Object[]{username, status, action, ro});
        }
        if (result == null && throwIfNoPerm) {
            String error = String.format("Permission denied: %s %s", action, ro);
            throw new ForbiddenException(error);
        }
        return (V)result;
    }

    static {
        HugeGraph.registerTraversalStrategies(HugeGraphAuthProxy.class);
    }

    private final class TraversalStrategyProxy<T extends TraversalStrategy<?>>
    implements TraversalStrategy<T> {
        private static final long serialVersionUID = 2071829024642435735L;
        private final TraversalStrategy<T> origin;

        public TraversalStrategyProxy(TraversalStrategy<?> origin) {
            TraversalStrategy<?> strategy = origin;
            this.origin = strategy;
        }

        public void apply(Traversal.Admin<?, ?> traversal) {
            GroovyTranslator translator;
            Script script1;
            String script = traversal instanceof HugeScriptTraversal ? ((HugeScriptTraversal)traversal).script() : ((script1 = (translator = GroovyTranslator.of((String)"g")).translate(traversal.getBytecode())) != null ? script1.getScript() : "");
            String caller = Thread.currentThread().getName();
            if (!caller.contains("grizzly-http-server")) {
                HugeGraphAuthProxy.this.verifyNamePermission(HugePermission.EXECUTE, ResourceType.GREMLIN, script);
            }
            this.origin.apply(traversal);
        }

        public Set<Class<? extends T>> applyPrior() {
            return this.origin.applyPrior();
        }

        public Set<Class<? extends T>> applyPost() {
            return this.origin.applyPost();
        }

        public Class<T> getTraversalCategory() {
            return this.origin.getTraversalCategory();
        }

        public Configuration getConfiguration() {
            return this.origin.getConfiguration();
        }

        public int compareTo(Class<? extends TraversalStrategy> other) {
            return this.origin.compareTo(other);
        }

        public int hashCode() {
            return this.origin.hashCode();
        }

        public boolean equals(Object obj) {
            return this.origin.equals(obj);
        }

        public String toString() {
            return this.origin.toString();
        }
    }

    class TraversalStrategiesProxy
    implements TraversalStrategies {
        private static final String REST_WORKER = "grizzly-http-server";
        private static final long serialVersionUID = -5424364720492307019L;
        private final TraversalStrategies strategies;

        public TraversalStrategiesProxy(TraversalStrategies strategies) {
            this.strategies = strategies;
        }

        public List<TraversalStrategy<?>> toList() {
            return this.strategies.toList();
        }

        public Iterator<TraversalStrategy<?>> iterator() {
            if (this.strategies == null) {
                return Collections.emptyIterator();
            }
            return new MapperIterator(this.strategies.iterator(), x$0 -> new TraversalStrategyProxy((TraversalStrategy<?>)x$0));
        }

        public TraversalStrategies addStrategies(TraversalStrategy<?> ... strategies) {
            return this.strategies.addStrategies(strategies);
        }

        public TraversalStrategies removeStrategies(Class<? extends TraversalStrategy> ... strategyClasses) {
            return this.strategies.removeStrategies((Class[])strategyClasses);
        }

        public TraversalStrategies clone() {
            return this.strategies.clone();
        }

        private String translate(Bytecode bytecode) {
            List steps = bytecode.getStepInstructions();
            StringBuilder sb = new StringBuilder();
            sb.append("g");
            int stepsPrint = Math.min(10, steps.size());
            for (int i = 0; i < stepsPrint; ++i) {
                Bytecode.Instruction step = (Bytecode.Instruction)steps.get(i);
                sb.append('.').append(step);
            }
            if (stepsPrint < steps.size()) {
                sb.append("..");
            }
            return sb.toString();
        }
    }

    class GraphTraversalSourceProxy
    extends GraphTraversalSource {
        public GraphTraversalSourceProxy(Graph graph) {
            super(graph);
        }

        public GraphTraversalSourceProxy(Graph graph, TraversalStrategies strategies) {
            super(graph, strategies);
        }

        public TraversalStrategies getStrategies() {
            return new TraversalStrategiesProxy(super.getStrategies());
        }
    }

    class VariablesProxy
    implements Graph.Variables {
        private final Graph.Variables variables;

        public VariablesProxy(Graph.Variables variables) {
            this.variables = variables;
        }

        public <R> Optional<R> get(String key) {
            HugeGraphAuthProxy.this.verifyPermission(HugePermission.READ, ResourceType.VAR);
            return this.variables.get(key);
        }

        public Set<String> keys() {
            HugeGraphAuthProxy.this.verifyPermission(HugePermission.READ, ResourceType.VAR);
            return this.variables.keys();
        }

        public void set(String key, Object value) {
            HugeGraphAuthProxy.this.verifyPermission(HugePermission.WRITE, ResourceType.VAR);
            this.variables.set(key, value);
        }

        public void remove(String key) {
            HugeGraphAuthProxy.this.verifyPermission(HugePermission.DELETE, ResourceType.VAR);
            this.variables.remove(key);
        }
    }

    class AuthManagerProxy
    implements AuthManager {
        private AuthManager authManager;

        public AuthManagerProxy(AuthManager origin) {
            this.authManager = origin;
        }

        private SchemaDefine.AuthElement updateCreator(SchemaDefine.AuthElement elem) {
            String username = this.currentUsername();
            if (username != null && elem.creator() == null) {
                elem.creator(username);
            }
            return elem;
        }

        private String currentUsername() {
            Context context = HugeGraphAuthProxy.getContext();
            if (context != null) {
                return context.user().username();
            }
            return null;
        }

        public void init() {
            HugeGraphAuthProxy.this.verifyAdminPermission();
            this.authManager.init();
        }

        public boolean close() {
            HugeGraphAuthProxy.this.verifyAdminPermission();
            return this.authManager.close();
        }

        public Id createUser(HugeUser user) {
            E.checkArgument((!"admin".equals(user.name()) ? 1 : 0) != 0, (String)"Invalid user name '%s'", (Object[])new Object[]{user.name()});
            this.updateCreator((SchemaDefine.AuthElement)user);
            return this.authManager.createUser(user);
        }

        public Id updateUser(HugeUser updatedUser) {
            String username = this.currentUsername();
            HugeUser user = this.authManager.getUser(updatedUser.id());
            if (!user.name().equals(username)) {
                E.checkArgument((boolean)"admin".equals(username), (String)"Only the user themselves or the admin can change this user", (Object[])new Object[]{user.name()});
                this.updateCreator((SchemaDefine.AuthElement)updatedUser);
            }
            this.invalidRoleCache();
            return this.authManager.updateUser(updatedUser);
        }

        public HugeUser deleteUser(Id id) {
            HugeUser user = this.authManager.getUser(id);
            E.checkArgument((!"admin".equals(user.name()) ? 1 : 0) != 0, (String)"Can't delete user '%s'", (Object[])new Object[]{user.name()});
            E.checkArgument((boolean)"admin".equals(this.currentUsername()), (String)"only admin can delete user", (Object[])new Object[]{user.name()});
            HugeGraphAuthProxy.this.auditLimiters.invalidate((Object)user.id());
            this.invalidRoleCache();
            return this.authManager.deleteUser(id);
        }

        public HugeUser findUser(String name) {
            HugeUser user = this.authManager.findUser(name);
            return user;
        }

        public HugeUser getUser(Id id) {
            HugeUser user = this.authManager.getUser(id);
            String username = this.currentUsername();
            if (!user.name().equals(username)) {
                HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, user);
            }
            return user;
        }

        public List<HugeUser> listUsers(List<Id> ids) {
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, this.authManager.listUsers(ids));
        }

        public List<HugeUser> listAllUsers(long limit) {
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, this.authManager.listAllUsers(limit));
        }

        public Id createGroup(HugeGroup group) {
            this.updateCreator((SchemaDefine.AuthElement)group);
            this.invalidRoleCache();
            return this.authManager.createGroup(group);
        }

        public Id updateGroup(HugeGroup group) {
            this.updateCreator((SchemaDefine.AuthElement)group);
            this.invalidRoleCache();
            return this.authManager.updateGroup(group);
        }

        public HugeGroup deleteGroup(Id id) {
            this.invalidRoleCache();
            return this.authManager.deleteGroup(id);
        }

        public HugeGroup getGroup(Id id) {
            return this.authManager.getGroup(id);
        }

        public List<HugeGroup> listGroups(List<Id> ids) {
            return this.authManager.listGroups(ids);
        }

        public List<HugeGroup> listAllGroups(long limit) {
            return this.authManager.listAllGroups(limit);
        }

        public Id createTarget(HugeTarget target) {
            this.updateCreator((SchemaDefine.AuthElement)target);
            HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.WRITE, target);
            this.invalidRoleCache();
            return this.authManager.createTarget(target);
        }

        public Id updateTarget(HugeTarget target) {
            this.updateCreator((SchemaDefine.AuthElement)target);
            HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.WRITE, target);
            this.invalidRoleCache();
            return this.authManager.updateTarget(target);
        }

        public HugeTarget deleteTarget(Id id) {
            HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.DELETE, this.authManager.getTarget(id));
            this.invalidRoleCache();
            return this.authManager.deleteTarget(id);
        }

        public HugeTarget getTarget(Id id) {
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, this.authManager.getTarget(id));
        }

        public List<HugeTarget> listTargets(List<Id> ids) {
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, this.authManager.listTargets(ids));
        }

        public List<HugeTarget> listAllTargets(long limit) {
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, this.authManager.listAllTargets(limit));
        }

        public Id createBelong(HugeBelong belong) {
            this.updateCreator((SchemaDefine.AuthElement)belong);
            HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.WRITE, belong);
            this.invalidRoleCache();
            return this.authManager.createBelong(belong);
        }

        public Id updateBelong(HugeBelong belong) {
            this.updateCreator((SchemaDefine.AuthElement)belong);
            HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.WRITE, belong);
            this.invalidRoleCache();
            return this.authManager.updateBelong(belong);
        }

        public HugeBelong deleteBelong(Id id) {
            HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.DELETE, this.authManager.getBelong(id));
            this.invalidRoleCache();
            return this.authManager.deleteBelong(id);
        }

        public HugeBelong getBelong(Id id) {
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, this.authManager.getBelong(id));
        }

        public List<HugeBelong> listBelong(List<Id> ids) {
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, this.authManager.listBelong(ids));
        }

        public List<HugeBelong> listAllBelong(long limit) {
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, this.authManager.listAllBelong(limit));
        }

        public List<HugeBelong> listBelongByUser(Id user, long limit) {
            List r = this.authManager.listBelongByUser(user, limit);
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, r);
        }

        public List<HugeBelong> listBelongByGroup(Id group, long limit) {
            List r = this.authManager.listBelongByGroup(group, limit);
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, r);
        }

        public Id createAccess(HugeAccess access) {
            this.updateCreator((SchemaDefine.AuthElement)access);
            HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.WRITE, access);
            this.invalidRoleCache();
            return this.authManager.createAccess(access);
        }

        public Id updateAccess(HugeAccess access) {
            this.updateCreator((SchemaDefine.AuthElement)access);
            HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.WRITE, access);
            this.invalidRoleCache();
            return this.authManager.updateAccess(access);
        }

        public HugeAccess deleteAccess(Id id) {
            HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.DELETE, this.authManager.getAccess(id));
            this.invalidRoleCache();
            return this.authManager.deleteAccess(id);
        }

        public HugeAccess getAccess(Id id) {
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, this.authManager.getAccess(id));
        }

        public List<HugeAccess> listAccess(List<Id> ids) {
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, this.authManager.listAccess(ids));
        }

        public List<HugeAccess> listAllAccess(long limit) {
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, this.authManager.listAllAccess(limit));
        }

        public List<HugeAccess> listAccessByGroup(Id group, long limit) {
            List r = this.authManager.listAccessByGroup(group, limit);
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, r);
        }

        public List<HugeAccess> listAccessByTarget(Id target, long limit) {
            List r = this.authManager.listAccessByTarget(target, limit);
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, r);
        }

        public Id createProject(HugeProject project) {
            this.updateCreator((SchemaDefine.AuthElement)project);
            HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.WRITE, project);
            return this.authManager.createProject(project);
        }

        public HugeProject deleteProject(Id id) {
            HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.DELETE, this.authManager.getProject(id));
            return this.authManager.deleteProject(id);
        }

        public Id updateProject(HugeProject project) {
            this.updateCreator((SchemaDefine.AuthElement)project);
            HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.WRITE, project);
            return this.authManager.updateProject(project);
        }

        public Id projectAddGraphs(Id id, Set<String> graphs) {
            HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.WRITE, this.authManager.getProject(id));
            return this.authManager.projectAddGraphs(id, graphs);
        }

        public Id projectRemoveGraphs(Id id, Set<String> graphs) {
            HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.WRITE, this.authManager.getProject(id));
            return this.authManager.projectRemoveGraphs(id, graphs);
        }

        public HugeProject getProject(Id id) {
            HugeProject project = this.authManager.getProject(id);
            HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, project);
            return project;
        }

        public List<HugeProject> listAllProject(long limit) {
            List projects = this.authManager.listAllProject(limit);
            return HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, projects);
        }

        public HugeUser matchUser(String name, String password) {
            return this.authManager.matchUser(name, password);
        }

        public RolePermission rolePermission(SchemaDefine.AuthElement element) {
            String username = this.currentUsername();
            if (!(element instanceof HugeUser) || !((HugeUser)element).name().equals(username)) {
                HugeGraphAuthProxy.this.verifyUserPermission(HugePermission.READ, element);
            }
            return this.authManager.rolePermission(element);
        }

        public UserWithRole validateUser(String username, String password) {
            Context context = HugeGraphAuthProxy.setContext(Context.admin());
            try {
                Id userKey = IdGenerator.of((String)(username + password));
                UserWithRole userWithRole = (UserWithRole)HugeGraphAuthProxy.this.usersRoleCache.getOrFetch((Object)userKey, id -> this.authManager.validateUser(username, password));
                return userWithRole;
            }
            catch (Exception e) {
                LOG.error("Failed to validate user {} with error: ", (Object)username, (Object)e);
                throw e;
            }
            finally {
                HugeGraphAuthProxy.setContext(context);
            }
        }

        public UserWithRole validateUser(String token) {
            Context context = HugeGraphAuthProxy.setContext(Context.admin());
            try {
                Id userKey = IdGenerator.of((String)token);
                UserWithRole userWithRole = (UserWithRole)HugeGraphAuthProxy.this.usersRoleCache.getOrFetch((Object)userKey, id -> this.authManager.validateUser(token));
                return userWithRole;
            }
            catch (Exception e) {
                LOG.error("Failed to validate token {} with error: ", (Object)token, (Object)e);
                throw e;
            }
            finally {
                HugeGraphAuthProxy.setContext(context);
            }
        }

        public Set<String> listWhiteIPs() {
            return this.authManager.listWhiteIPs();
        }

        public void setWhiteIPs(Set<String> whiteIpList) {
            this.authManager.setWhiteIPs(whiteIpList);
        }

        public boolean getWhiteIpStatus() {
            return this.authManager.getWhiteIpStatus();
        }

        public void enabledWhiteIpList(boolean status) {
            this.authManager.enabledWhiteIpList(status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Id createSpaceManager(String graphSpace, String owner) {
            String username = this.currentUsername();
            if (username != null) {
                TaskManager.setContext((String)String.format("{\"username\":\"%s\"}", username));
            }
            try {
                Id id = this.authManager.createSpaceManager(graphSpace, owner);
                return id;
            }
            finally {
                if (username != null) {
                    TaskManager.resetContext();
                }
            }
        }

        public void deleteSpaceManager(String graphSpace, String owner) {
            this.authManager.deleteSpaceManager(graphSpace, owner);
            this.invalidRoleCache();
        }

        public List<String> listSpaceManager(String graphSpace) {
            return this.authManager.listSpaceManager(graphSpace);
        }

        public boolean isSpaceManager(String owner) {
            return this.authManager.isSpaceManager(owner);
        }

        public boolean isSpaceManager(String graphSpace, String owner) {
            return this.authManager.isSpaceManager(graphSpace, owner);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Id createSpaceMember(String graphSpace, String user) {
            String username = this.currentUsername();
            if (username != null) {
                TaskManager.setContext((String)String.format("{\"username\":\"%s\"}", username));
            }
            try {
                Id id = this.authManager.createSpaceMember(graphSpace, user);
                return id;
            }
            finally {
                if (username != null) {
                    TaskManager.resetContext();
                }
            }
        }

        public void deleteSpaceMember(String graphSpace, String user) {
            this.authManager.deleteSpaceMember(graphSpace, user);
            this.invalidRoleCache();
        }

        public List<String> listSpaceMember(String graphSpace) {
            return this.authManager.listSpaceMember(graphSpace);
        }

        public boolean isSpaceMember(String graphSpace, String user) {
            return this.authManager.isSpaceMember(graphSpace, user);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Id createAdminManager(String user) {
            String username = this.currentUsername();
            if (username != null) {
                TaskManager.setContext((String)String.format("{\"username\":\"%s\"}", username));
            }
            try {
                Id id = this.authManager.createAdminManager(user);
                return id;
            }
            finally {
                if (username != null) {
                    TaskManager.resetContext();
                }
            }
        }

        public void deleteAdminManager(String user) {
            this.authManager.deleteAdminManager(user);
            this.invalidRoleCache();
        }

        public List<String> listAdminManager() {
            return this.authManager.listAdminManager();
        }

        public boolean isAdminManager(String user) {
            return this.authManager.isAdminManager(user);
        }

        public HugeGroup findGroup(String name) {
            return this.authManager.findGroup(name);
        }

        public String loginUser(String username, String password) {
            return this.loginUser(username, password, -1L);
        }

        public String loginUser(String username, String password, long expire) {
            try {
                return this.authManager.loginUser(username, password, expire);
            }
            catch (AuthenticationException e) {
                throw new NotAuthorizedException(e.getMessage(), (Object)e, new Object[0]);
            }
        }

        public void logoutUser(String token) {
            this.authManager.logoutUser(token);
        }

        private void switchAuthManager(AuthManager authManager) {
            this.authManager = authManager;
            HugeGraphAuthProxy.this.hugegraph.switchAuthManager(authManager);
        }

        private void invalidRoleCache() {
            HugeGraphAuthProxy.this.usersRoleCache.clear();
        }
    }

    class TaskSchedulerProxy
    implements TaskScheduler {
        private final TaskScheduler taskScheduler;

        public TaskSchedulerProxy(TaskScheduler origin) {
            this.taskScheduler = origin;
        }

        public HugeGraph graph() {
            return this.taskScheduler.graph();
        }

        public void init() {
            HugeGraphAuthProxy.this.verifyAdminPermission();
            this.taskScheduler.init();
        }

        public int pendingTasks() {
            this.verifyTaskPermission(HugePermission.READ);
            return this.taskScheduler.pendingTasks();
        }

        public <V> void restoreTasks() {
            this.verifyTaskPermission(HugePermission.WRITE);
            this.taskScheduler.restoreTasks();
        }

        public <V> Future<?> schedule(HugeTask<V> task) {
            this.verifyTaskPermission(HugePermission.EXECUTE);
            task.context(HugeGraphAuthProxy.getContextString());
            return this.taskScheduler.schedule(task);
        }

        public <V> void cancel(HugeTask<V> task) {
            this.verifyTaskPermission(HugePermission.WRITE, task);
            this.taskScheduler.cancel(task);
        }

        public <V> void save(HugeTask<V> task) {
            this.verifyTaskPermission(HugePermission.WRITE, task);
            this.taskScheduler.save(task);
        }

        public <V> HugeTask<V> task(Id id) {
            return this.verifyTaskPermission(HugePermission.READ, this.taskScheduler.task(id));
        }

        public <V> Iterator<HugeTask<V>> tasks(List<Id> ids) {
            return this.verifyTaskPermission(HugePermission.READ, this.taskScheduler.tasks(ids));
        }

        public <V> Iterator<HugeTask<V>> tasks(TaskStatus status, long limit, String page) {
            Iterator tasks = this.taskScheduler.tasks(status, limit, page);
            return this.verifyTaskPermission(HugePermission.READ, tasks);
        }

        public <V> HugeTask<V> delete(Id id, boolean force) {
            this.verifyTaskPermission(HugePermission.DELETE, this.taskScheduler.task(id));
            return this.taskScheduler.delete(id, force);
        }

        public boolean close() {
            HugeGraphAuthProxy.this.verifyAdminPermission();
            return this.taskScheduler.close();
        }

        public <V> HugeTask<V> waitUntilTaskCompleted(Id id, long seconds) throws TimeoutException {
            HugeGraphAuthProxy.this.verifyAnyPermission();
            return this.taskScheduler.waitUntilTaskCompleted(id, seconds);
        }

        public <V> HugeTask<V> waitUntilTaskCompleted(Id id) throws TimeoutException {
            HugeGraphAuthProxy.this.verifyAnyPermission();
            return this.taskScheduler.waitUntilTaskCompleted(id);
        }

        public void waitUntilAllTasksCompleted(long seconds) throws TimeoutException {
            HugeGraphAuthProxy.this.verifyAnyPermission();
            this.taskScheduler.waitUntilAllTasksCompleted(seconds);
        }

        public void checkRequirement(String op) {
            HugeGraphAuthProxy.this.verifyAnyPermission();
            this.taskScheduler.checkRequirement(op);
        }

        public <V> V call(Callable<V> callable) {
            HugeGraphAuthProxy.this.verifyAnyPermission();
            return (V)this.taskScheduler.call(callable);
        }

        public <V> V call(Runnable runnable) {
            HugeGraphAuthProxy.this.verifyAnyPermission();
            return (V)this.taskScheduler.call(runnable);
        }

        public ServerInfoManager serverManager() {
            HugeGraphAuthProxy.this.verifyAnyPermission();
            return this.taskScheduler.serverManager();
        }

        public String graphName() {
            HugeGraphAuthProxy.this.verifyAnyPermission();
            return this.taskScheduler.graphName();
        }

        public String spaceGraphName() {
            return this.taskScheduler.spaceGraphName();
        }

        public void taskDone(HugeTask<?> task) {
            HugeGraphAuthProxy.this.verifyAnyPermission();
            this.taskScheduler.taskDone(task);
        }

        private void verifyTaskPermission(HugePermission actionPerm) {
            HugeGraphAuthProxy.this.verifyPermission(actionPerm, ResourceType.TASK);
        }

        private <V> HugeTask<V> verifyTaskPermission(HugePermission actionPerm, HugeTask<V> task) {
            return this.verifyTaskPermission(actionPerm, true, task);
        }

        private <V> Iterator<HugeTask<V>> verifyTaskPermission(HugePermission actionPerm, Iterator<HugeTask<V>> tasks) {
            return new FilterIterator(tasks, task -> this.verifyTaskPermission(actionPerm, false, (HugeTask)task) != null);
        }

        private <V> HugeTask<V> verifyTaskPermission(HugePermission actionPerm, boolean throwIfNoPerm, HugeTask<V> task) {
            Object r = HugeGraphAuthProxy.this.verifyResPermission(actionPerm, throwIfNoPerm, () -> {
                String graph = HugeGraphAuthProxy.this.hugegraph.name();
                String name = task.id().toString();
                HugeResource.NameObject elem = HugeResource.NameObject.of((String)name);
                return ResourceObject.of((String)HugeGraphAuthProxy.this.graphSpace(), (String)graph, (ResourceType)ResourceType.TASK, (Nameable)elem);
            }, () -> this.hasTaskPermission(task));
            return r == null ? null : task;
        }

        private boolean hasTaskPermission(HugeTask<?> task) {
            Context context = HugeGraphAuthProxy.getContext();
            if (context == null) {
                return false;
            }
            HugeAuthenticator.User currentUser = context.user();
            HugeAuthenticator.User taskUser = HugeAuthenticator.User.fromJson(task.context());
            if (taskUser == null) {
                return HugeAuthenticator.User.ADMIN.equals((Object)currentUser);
            }
            return Objects.equals(currentUser.getName(), taskUser.getName()) || HugeAuthenticator.RolePerm.match((Object)currentUser.role(), taskUser.role(), null);
        }
    }

    public static class ContextThreadPoolExecutor
    extends ThreadPoolExecutor {
        public ContextThreadPoolExecutor(int corePoolSize, int maxPoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, maxPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        }

        @Override
        public void execute(Runnable command) {
            super.execute(new ContextTask(command));
        }
    }

    static class ContextTask
    implements Runnable {
        private final Runnable runner;
        private final Context context = HugeGraphAuthProxy.getContext();

        public ContextTask(Runnable runner) {
            this.runner = runner;
        }

        @Override
        public void run() {
            HugeGraphAuthProxy.setContext(this.context);
            try {
                this.runner.run();
            }
            finally {
                HugeGraphAuthProxy.resetContext();
            }
        }
    }

    public static class Context {
        private static final Context ADMIN = new Context(HugeAuthenticator.User.ADMIN);
        private final HugeAuthenticator.User user;

        public Context(HugeAuthenticator.User user) {
            E.checkNotNull((Object)((Object)user), (String)"user");
            this.user = user;
        }

        public static Context admin() {
            return ADMIN;
        }

        public HugeAuthenticator.User user() {
            return this.user;
        }
    }
}

