/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.rocksdb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.page.PageState;
import org.apache.hugegraph.backend.query.Aggregate;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.IdPrefixQuery;
import org.apache.hugegraph.backend.query.IdRangeQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.serializer.BinaryBackendEntry;
import org.apache.hugegraph.backend.serializer.BinaryEntryIterator;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendEntryIterator;
import org.apache.hugegraph.backend.store.BackendSession;
import org.apache.hugegraph.backend.store.BackendTable;
import org.apache.hugegraph.backend.store.Shard;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBSessions;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.iterator.FlatMapperIterator;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.StringEncoding;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.slf4j.Logger;

public class RocksDBTable
extends BackendTable<RocksDBSessions.Session, BackendEntry> {
    private static final Logger LOG = Log.logger(RocksDBTable.class);
    private final RocksDBShardSplitter shardSplitter = new RocksDBShardSplitter(this.table());

    public RocksDBTable(String database, String table) {
        super(String.format("%s+%s", database, table));
    }

    protected void registerMetaHandlers() {
        this.registerMetaHandler("splits", (session, meta, args) -> {
            E.checkArgument((args.length == 1 ? 1 : 0) != 0, (String)"The args count of %s must be 1", (Object[])new Object[]{meta});
            long splitSize = (Long)args[0];
            return this.shardSplitter.getSplits((RocksDBSessions.Session)session, splitSize);
        });
    }

    public void init(RocksDBSessions.Session session) {
    }

    public void clear(RocksDBSessions.Session session) {
    }

    public void insert(RocksDBSessions.Session session, BackendEntry entry) {
        assert (!entry.columns().isEmpty());
        for (BackendEntry.BackendColumn col : entry.columns()) {
            assert (entry.belongToMe(col)) : entry;
            session.put(this.table(), col.name, col.value);
        }
    }

    public void delete(RocksDBSessions.Session session, BackendEntry entry) {
        if (entry.columns().isEmpty()) {
            session.delete(this.table(), entry.id().asBytes());
        } else {
            for (BackendEntry.BackendColumn col : entry.columns()) {
                assert (entry.belongToMe(col)) : entry;
                session.delete(this.table(), col.name);
            }
        }
    }

    public void append(RocksDBSessions.Session session, BackendEntry entry) {
        assert (entry.columns().size() == 1);
        this.insert(session, entry);
    }

    public void eliminate(RocksDBSessions.Session session, BackendEntry entry) {
        assert (entry.columns().size() == 1);
        this.delete(session, entry);
    }

    public boolean queryExist(RocksDBSessions.Session session, BackendEntry entry) {
        Id id = entry.id();
        try (BackendEntry.BackendColumnIterator iter = this.queryById(session, id);){
            boolean bl = iter.hasNext();
            return bl;
        }
    }

    public Number queryNumber(RocksDBSessions.Session session, Query query) {
        Aggregate aggregate = query.aggregateNotNull();
        if (aggregate.func() != Aggregate.AggregateFunc.COUNT) {
            throw new NotSupportException(aggregate.toString());
        }
        assert (aggregate.func() == Aggregate.AggregateFunc.COUNT);
        assert (query.noLimit());
        try (BackendEntry.BackendColumnIterator results = this.queryBy(session, query);){
            if (results instanceof RocksDBSessions.Countable) {
                Long l = ((RocksDBSessions.Countable)results).count();
                return l;
            }
            Long l = IteratorUtils.count((Iterator)results);
            return l;
        }
    }

    public Iterator<BackendEntry> query(RocksDBSessions.Session session, Query query) {
        if (query.limit() == 0L && !query.noLimit()) {
            LOG.debug("Return empty result(limit=0) for query {}", (Object)query);
            return Collections.emptyIterator();
        }
        return RocksDBTable.newEntryIterator(this.queryBy(session, query), query);
    }

    public Iterator<BackendEntry> queryOlap(RocksDBSessions.Session session, Query query) {
        if (query.limit() == 0L && !query.noLimit()) {
            return Collections.emptyIterator();
        }
        return RocksDBTable.newEntryIteratorOlap(this.queryBy(session, query), query, true);
    }

    protected BackendEntry.BackendColumnIterator queryBy(RocksDBSessions.Session session, Query query) {
        if (query.empty()) {
            return this.queryAll(session, query);
        }
        if (query instanceof IdPrefixQuery) {
            IdPrefixQuery pq = (IdPrefixQuery)query;
            return this.queryByPrefix(session, pq);
        }
        if (query instanceof IdRangeQuery) {
            IdRangeQuery rq = (IdRangeQuery)query;
            return this.queryByRange(session, rq);
        }
        if (query.conditionsSize() == 0) {
            assert (query.idsSize() > 0);
            return this.queryByIds(session, query.ids());
        }
        ConditionQuery cq = (ConditionQuery)query;
        return this.queryByCond(session, cq);
    }

    protected BackendEntry.BackendColumnIterator queryAll(RocksDBSessions.Session session, Query query) {
        if (query.paging()) {
            PageState page = PageState.fromString((String)query.page());
            byte[] begin = page.position();
            return session.scan(this.table(), begin, null, 128);
        }
        return session.scan(this.table());
    }

    protected BackendEntry.BackendColumnIterator queryById(RocksDBSessions.Session session, Id id) {
        return session.scan(this.table(), id.asBytes());
    }

    protected BackendEntry.BackendColumnIterator queryByIds(RocksDBSessions.Session session, Collection<Id> ids) {
        if (ids.size() == 1) {
            return this.queryById(session, ids.iterator().next());
        }
        return BackendEntry.BackendColumnIterator.wrap((Iterator)new FlatMapperIterator(ids.iterator(), id -> this.queryById(session, (Id)id)));
    }

    protected BackendEntry.BackendColumnIterator getById(RocksDBSessions.Session session, Id id) {
        byte[] value = session.get(this.table(), id.asBytes());
        if (value == null) {
            return BackendEntry.BackendColumnIterator.empty();
        }
        BackendEntry.BackendColumn col = BackendEntry.BackendColumn.of((byte[])id.asBytes(), (byte[])value);
        return BackendEntry.BackendColumnIterator.iterator((BackendEntry.BackendColumn)col);
    }

    protected BackendEntry.BackendColumnIterator getByIds(RocksDBSessions.Session session, Set<Id> ids) {
        if (ids.size() == 1) {
            return this.getById(session, ids.iterator().next());
        }
        ArrayList<byte[]> keys = new ArrayList<byte[]>(ids.size());
        for (Id id : ids) {
            keys.add(id.asBytes());
        }
        return session.get(this.table(), keys);
    }

    protected BackendEntry.BackendColumnIterator queryByPrefix(RocksDBSessions.Session session, IdPrefixQuery query) {
        int type = query.inclusiveStart() ? 12 : 4;
        return session.scan(this.table(), query.start().asBytes(), query.prefix().asBytes(), type |= 2);
    }

    protected BackendEntry.BackendColumnIterator queryByRange(RocksDBSessions.Session session, IdRangeQuery query) {
        int type;
        byte[] start = query.start().asBytes();
        byte[] end = query.end() == null ? null : query.end().asBytes();
        int n = type = query.inclusiveStart() ? 12 : 4;
        if (end != null) {
            type |= query.inclusiveEnd() ? 48 : 16;
        }
        return session.scan(this.table(), start, end, type);
    }

    protected BackendEntry.BackendColumnIterator queryByCond(RocksDBSessions.Session session, ConditionQuery query) {
        if (query.containsScanRelation()) {
            E.checkArgument((query.relations().size() == 1 ? 1 : 0) != 0, (String)"Invalid scan with multi conditions: %s", (Object[])new Object[]{query});
            Condition.Relation scan = (Condition.Relation)query.relations().iterator().next();
            Shard shard = (Shard)scan.value();
            return this.queryByRange(session, shard, query.page());
        }
        throw new NotSupportException("query: %s", new Object[]{query});
    }

    protected BackendEntry.BackendColumnIterator queryByRange(RocksDBSessions.Session session, Shard shard, String page) {
        byte[] start = this.shardSplitter.position(shard.start());
        byte[] end = this.shardSplitter.position(shard.end());
        if (page != null && !page.isEmpty()) {
            byte[] position = PageState.fromString((String)page).position();
            E.checkArgument((start == null || Bytes.compare((byte[])position, (byte[])start) >= 0 ? 1 : 0) != 0, (String)"Invalid page out of lower bound", (Object[])new Object[0]);
            start = position;
        }
        if (start == null) {
            start = BackendTable.ShardSplitter.START_BYTES;
        }
        int type = 12;
        if (end != null) {
            type |= 0x10;
        }
        return session.scan(this.table(), start, end, type);
    }

    public boolean isOlap() {
        return false;
    }

    protected static BackendEntryIterator newEntryIterator(BackendEntry.BackendColumnIterator cols, Query query) {
        return new BinaryEntryIterator((BackendEntry.BackendIterator)cols, query, (entry, col) -> {
            if (entry == null || !entry.belongToMe(col)) {
                HugeType type = query.resultType();
                entry = new BinaryBackendEntry(type, col.name);
            } else assert (!Bytes.equals((byte[])entry.id().asBytes(), (byte[])col.name));
            entry.columns(col);
            return entry;
        });
    }

    protected static BackendEntryIterator newEntryIteratorOlap(BackendEntry.BackendColumnIterator cols, Query query, boolean isOlap) {
        return new BinaryEntryIterator((BackendEntry.BackendIterator)cols, query, (entry, col) -> {
            if (entry == null || !entry.belongToMe(col)) {
                HugeType type = query.resultType();
                entry = new BinaryBackendEntry(type, col.name, false, isOlap);
            }
            entry.columns(col);
            return entry;
        });
    }

    protected static long sizeOfBackendEntry(BackendEntry entry) {
        return BinaryEntryIterator.sizeOfEntry((BackendEntry)entry);
    }

    private static class RocksDBShardSplitter
    extends BackendTable.ShardSplitter<RocksDBSessions.Session> {
        private static final String MEM_SIZE = "rocksdb.size-all-mem-tables";
        private static final String SST_SIZE = "rocksdb.total-sst-files-size";
        private static final String NUM_KEYS = "rocksdb.estimate-num-keys";

        public RocksDBShardSplitter(String table) {
            super(table);
        }

        public List<Shard> getSplits(RocksDBSessions.Session session, long splitSize) {
            double count;
            E.checkArgument((splitSize >= 0x100000L ? 1 : 0) != 0, (String)"The split-size must be >= %s bytes, but got %s", (Object[])new Object[]{0x100000, splitSize});
            Pair<byte[], byte[]> keyRange = session.keyRange(this.table());
            if (keyRange == null || keyRange.getRight() == null) {
                return super.getSplits((BackendSession)session, splitSize);
            }
            long size = this.estimateDataSize(session);
            if (size <= 0L) {
                size = this.estimateNumKeys(session) * 100L;
            }
            if ((count = Math.ceil((double)size / (double)splitSize)) <= 0.0) {
                count = 1.0;
            }
            BackendTable.ShardSplitter.Range range = new BackendTable.ShardSplitter.Range((byte[])keyRange.getLeft(), BackendTable.ShardSplitter.Range.increase((byte[])((byte[])keyRange.getRight())));
            ArrayList<Shard> splits = new ArrayList<Shard>((int)count);
            splits.addAll(range.splitEven((int)count));
            return splits;
        }

        public long estimateDataSize(RocksDBSessions.Session session) {
            long mem = Long.parseLong(session.property(this.table(), MEM_SIZE));
            long sst = Long.parseLong(session.property(this.table(), SST_SIZE));
            return mem + sst;
        }

        public long estimateNumKeys(RocksDBSessions.Session session) {
            return Long.parseLong(session.property(this.table(), NUM_KEYS));
        }

        public byte[] position(String position) {
            if ("".equals(position) || "".equals(position)) {
                return null;
            }
            return StringEncoding.decodeBase64((String)position);
        }
    }
}

