/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ToDoubleFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.pd.StoreNodeService;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.model.GraphStatistics;
import org.apache.hugegraph.pd.service.PDRestService;
import org.apache.hugegraph.pd.service.PDService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PDMetrics {
    private static final Logger log = LoggerFactory.getLogger(PDMetrics.class);
    public static final String PREFIX = "hg";
    private static AtomicLong graphs = new AtomicLong(0L);
    private static Map<String, Counter> lastTerms = new ConcurrentHashMap();
    @Autowired
    PDRestService pdRestService;
    @Autowired
    private PDService pdService;
    private MeterRegistry registry;
    private Map<String, Pair<Long, Long>> lasts = new ConcurrentHashMap();
    private int interval = 120000;

    public synchronized void init(MeterRegistry meterRegistry) {
        if (this.registry == null) {
            this.registry = meterRegistry;
            this.registerMeters();
        }
    }

    private void registerMeters() {
        Gauge.builder((String)"hg.up", () -> 1).register(this.registry);
        Gauge.builder((String)"hg.graphs", () -> this.updateGraphs()).description("Number of graphs registered in PD").register(this.registry);
        Gauge.builder((String)"hg.stores", () -> this.updateStores()).description("Number of stores registered in PD").register(this.registry);
        Gauge.builder((String)"hg.terms", () -> this.setTerms()).description("term of partitions in PD").register(this.registry);
    }

    private long updateGraphs() {
        long buf = this.getGraphs();
        if (buf != graphs.get()) {
            graphs.set(buf);
            this.registerGraphMetrics();
        }
        return buf;
    }

    private long updateStores() {
        return this.getStores();
    }

    private long getGraphs() {
        return this.getGraphMetas().size();
    }

    private long getStores() {
        try {
            return this.pdService.getStoreNodeService().getStores(null).size();
        }
        catch (PDException e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return 0L;
        }
    }

    private long setTerms() {
        List groups = null;
        try {
            groups = this.pdRestService.getShardGroups();
            StoreNodeService nodeService = this.pdService.getStoreNodeService();
            for (Metapb.ShardGroup g : groups) {
                String id = String.valueOf(g.getId());
                Metapb.ShardGroup group = nodeService.getShardGroup(g.getId());
                long version = group.getVersion();
                Counter lastTerm = (Counter)lastTerms.get(id);
                if (lastTerm == null) {
                    lastTerm = Counter.builder((String)"hg.partition.terms").description("term of partition").tag("id", id).register(this.registry);
                    lastTerm.increment((double)version);
                    lastTerms.put(id, lastTerm);
                    continue;
                }
                lastTerm.increment((double)version - lastTerm.count());
            }
        }
        catch (Exception e) {
            log.info("get partition term with error :", (Throwable)e);
        }
        if (groups == null) {
            return 0L;
        }
        return groups.size();
    }

    private List<Metapb.Graph> getGraphMetas() {
        try {
            return this.pdService.getPartitionService().getGraphs();
        }
        catch (PDException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    private void registerGraphMetrics() {
        this.getGraphMetas().forEach(meta -> {
            Gauge.builder((String)"hg.partitions", (Object)this.pdService.getPartitionService(), e -> e.getPartitions(meta.getGraphName()).size()).description("Number of partitions assigned to a graph").tag("graph", meta.getGraphName()).register(this.registry);
            ToDoubleFunction<Metapb.Graph> getGraphSize = e -> {
                try {
                    Long lastTime;
                    String graphName = e.getGraphName();
                    Pair last = (Pair)this.lasts.get(graphName);
                    if (last == null || (lastTime = (Long)last.getLeft()) == null || System.currentTimeMillis() - lastTime >= (long)this.interval) {
                        long dataSize = new GraphStatistics(e, this.pdRestService, this.pdService).getDataSize();
                        this.lasts.put(graphName, Pair.of((Object)System.currentTimeMillis(), (Object)dataSize));
                        return dataSize;
                    }
                    return ((Long)last.getRight()).longValue();
                }
                catch (PDException ex) {
                    log.error("get graph size with error", e);
                    return 0.0;
                }
            };
            Gauge.builder((String)"hg.graph.size", (Object)meta, getGraphSize).description("data size of graph").tag("graph", meta.getGraphName()).register(this.registry);
        });
    }
}

