/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.notice;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hugegraph.pd.common.HgAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoticeBroadcaster {
    private static final Logger log = LoggerFactory.getLogger(NoticeBroadcaster.class);
    private Supplier<Long> noticeSupplier;
    private long noticeId;
    private String durableId;
    private Supplier<String> durableSupplier;
    private Function<String, Boolean> removeFunction;
    private int state;
    private int counter;
    private long timestamp;

    private NoticeBroadcaster(Supplier<Long> noticeSupplier) {
        this.noticeSupplier = noticeSupplier;
        this.timestamp = System.currentTimeMillis();
    }

    public static NoticeBroadcaster of(Supplier<Long> noticeSupplier) {
        HgAssert.isArgumentNotNull(noticeSupplier, (String)"noticeSupplier");
        return new NoticeBroadcaster(noticeSupplier);
    }

    public NoticeBroadcaster setDurableSupplier(Supplier<String> durableSupplier) {
        this.durableSupplier = durableSupplier;
        return this;
    }

    public NoticeBroadcaster setRemoveFunction(Function<String, Boolean> removeFunction) {
        this.removeFunction = removeFunction;
        return this;
    }

    public NoticeBroadcaster notifying() {
        if (this.state >= 2) {
            log.warn("Aborted notifying as ack has done. notice: {}", (Object)this);
            return this;
        }
        ++this.counter;
        if (this.durableId == null && this.durableSupplier != null) {
            try {
                this.durableId = (String)this.durableSupplier.get();
            }
            catch (Throwable t) {
                log.error("Failed to invoke durableSupplier, cause by:", t);
            }
        }
        try {
            this.noticeId = (Long)this.noticeSupplier.get();
            this.state = 1;
        }
        catch (Throwable t) {
            this.state = -1;
            log.error("Failed to invoke noticeSupplier: {}; cause by: " + this.noticeSupplier.toString(), t);
        }
        return this;
    }

    public boolean checkAck(long ackNoticeId) {
        boolean flag = false;
        if (this.noticeId == ackNoticeId) {
            flag = true;
            this.state = 2;
        }
        if (flag) {
            this.doRemoveDurable();
        }
        return flag;
    }

    public boolean doRemoveDurable() {
        log.info("Removing NoticeBroadcaster is stating, noticeId:{}, durableId: {}", (Object)this.noticeId, (Object)this.durableId);
        boolean flag = false;
        if (this.removeFunction == null) {
            log.warn("The remove-function hasn't been set.");
            return false;
        }
        if (this.durableId == null) {
            log.warn("The durableId hasn't been set.");
            return false;
        }
        try {
            flag = (Boolean)this.removeFunction.apply(this.durableId);
            if (!flag) {
                log.error("Removing NoticeBroadcaster was not complete, noticeId: {}, durableId: {}", (Object)this.noticeId, (Object)this.durableId);
            }
        }
        catch (Throwable t) {
            log.error("Failed to remove NoticeBroadcaster, noticeId: " + this.noticeId + ", durableId: " + this.durableId + ". Cause by:", t);
        }
        return flag;
    }

    public long getNoticeId() {
        return this.noticeId;
    }

    public int getState() {
        return this.state;
    }

    public int getCounter() {
        return this.counter;
    }

    public String getDurableId() {
        return this.durableId;
    }

    public void setDurableId(String durableId) {
        if (HgAssert.isInvalid((String[])new String[]{durableId})) {
            log.warn("Set an invalid durable-id to NoticeBroadcaster.");
        }
        this.durableId = durableId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String toString() {
        return "NoticeBroadcaster{noticeId=" + this.noticeId + ", durableId='" + this.durableId + "', state=" + this.state + ", counter=" + this.counter + ", timestamp=" + this.timestamp + "}";
    }
}

