/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.pulse;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hugegraph.pd.common.HgAssert;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.pulse.PartitionHeartbeatRequest;
import org.apache.hugegraph.pd.grpc.pulse.PartitionHeartbeatResponse;
import org.apache.hugegraph.pd.grpc.pulse.PdInstructionResponse;
import org.apache.hugegraph.pd.grpc.pulse.PulseRequest;
import org.apache.hugegraph.pd.grpc.pulse.PulseResponse;
import org.apache.hugegraph.pd.grpc.pulse.PulseType;
import org.apache.hugegraph.pd.notice.NoticeBroadcaster;
import org.apache.hugegraph.pd.pulse.AbstractObserverSubject;
import org.apache.hugegraph.pd.pulse.PDPulseSubject;
import org.apache.hugegraph.pd.pulse.PartitionHeartbeatSubject;
import org.apache.hugegraph.pd.pulse.PdInstructionSubject;
import org.apache.hugegraph.pd.pulse.PulseListener;
import org.apache.hugegraph.pd.util.IdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@ThreadSafe
public class PDPulseSubject {
    private static final Logger log = LoggerFactory.getLogger(PDPulseSubject.class);
    private static final long NOTICE_EXPIRATION_TIME = 1800000L;
    private static final int RETRYING_PERIOD_SECONDS = 60;
    private static final Map<String, AbstractObserverSubject> subjectHolder = new ConcurrentHashMap();
    private static final ConcurrentLinkedQueue<NoticeBroadcaster> broadcasterQueue = new ConcurrentLinkedQueue();
    private static final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1);
    private static Supplier<List<Metapb.QueueItem>> queueRetrieveFunction = () -> Collections.emptyList();
    private static Function<Metapb.QueueItem, Boolean> queueDurableFunction = e -> true;
    private static Function<String, Boolean> queueRemoveFunction = e -> true;

    private static void doSchedule() {
        PDPulseSubject.appendQueue();
        PDPulseSubject.expireQueue();
        broadcasterQueue.forEach(e -> e.notifying());
    }

    private static void appendQueue() {
        broadcasterQueue.addAll(PDPulseSubject.getQueueItems().parallelStream().filter(e -> !broadcasterQueue.stream().anyMatch(b -> e.getItemId().equals(b.getDurableId()))).map(e -> PDPulseSubject.createBroadcaster((Metapb.QueueItem)e)).peek(e -> log.info("Appending notice: {}", e)).filter(e -> e != null).collect(Collectors.toList()));
    }

    private static void expireQueue() {
        broadcasterQueue.removeIf(e -> {
            if (System.currentTimeMillis() - e.getTimestamp() >= 1800000L) {
                log.info("Notice was expired, trying to remove, notice: {}", e);
                return e.doRemoveDurable();
            }
            return false;
        });
    }

    private static List<Metapb.QueueItem> getQueueItems() {
        try {
            return (List)queueRetrieveFunction.get();
        }
        catch (Throwable t) {
            log.error("Failed to retrieve queue from queueRetrieveFunction, cause by:", t);
            return Collections.emptyList();
        }
    }

    public static void setQueueRetrieveFunction(Supplier<List<Metapb.QueueItem>> queueRetrieveFunction) {
        HgAssert.isArgumentNotNull(queueRetrieveFunction, (String)"queueRetrieveFunction");
        PDPulseSubject.queueRetrieveFunction = queueRetrieveFunction;
    }

    public static void setQueueDurableFunction(Function<Metapb.QueueItem, Boolean> queueDurableFunction) {
        HgAssert.isArgumentNotNull(queueDurableFunction, (String)"queueDurableFunction");
        PDPulseSubject.queueDurableFunction = queueDurableFunction;
    }

    public static void setQueueRemoveFunction(Function<String, Boolean> queueRemoveFunction) {
        HgAssert.isArgumentNotNull(queueRemoveFunction, (String)"queueRemoveFunction");
        PDPulseSubject.queueRemoveFunction = queueRemoveFunction;
    }

    public static StreamObserver<PulseRequest> addObserver(StreamObserver<PulseResponse> responseObserver) {
        HgAssert.isArgumentNotNull(responseObserver, (String)"responseObserver");
        return new PDPulseStreamObserver(responseObserver);
    }

    public static void notifyClient(PartitionHeartbeatResponse.Builder responseBuilder) {
        HgAssert.isArgumentNotNull((Object)responseBuilder, (String)"responseBuilder");
        PDPulseSubject.notifyClient((PartitionHeartbeatResponse)responseBuilder.build());
    }

    private static void notifyClient(PartitionHeartbeatResponse response) {
        PDPulseSubject.doBroadcast((NoticeBroadcaster)PDPulseSubject.createBroadcaster((PartitionHeartbeatResponse)response));
    }

    public static void notifyClient(PdInstructionResponse response) {
        PDPulseSubject.doBroadcast((NoticeBroadcaster)PDPulseSubject.createBroadcaster((PdInstructionResponse)response));
    }

    private static void doBroadcast(NoticeBroadcaster broadcaster) {
        broadcasterQueue.add(broadcaster.notifying());
    }

    private static AbstractObserverSubject getSubject(PulseType pulseType) {
        return (AbstractObserverSubject)subjectHolder.get(pulseType.name());
    }

    private static NoticeBroadcaster createBroadcaster(Metapb.QueueItem item) {
        PartitionHeartbeatResponse notice = PDPulseSubject.toNotice((Metapb.QueueItem)item);
        if (notice == null) {
            return null;
        }
        NoticeBroadcaster res = PDPulseSubject.createBroadcaster((PartitionHeartbeatResponse)notice);
        res.setDurableId(item.getItemId());
        res.setTimestamp(item.getTimestamp());
        return res;
    }

    private static NoticeBroadcaster createBroadcaster(PartitionHeartbeatResponse notice) {
        return NoticeBroadcaster.of((Supplier)PDPulseSubject.getNoticeSupplier((GeneratedMessageV3)notice)).setDurableSupplier(PDPulseSubject.getDurableSupplier((GeneratedMessageV3)notice)).setRemoveFunction(PDPulseSubject.getRemoveFunction());
    }

    private static NoticeBroadcaster createBroadcaster(PdInstructionResponse notice) {
        return NoticeBroadcaster.of((Supplier)PDPulseSubject.getNoticeSupplier((GeneratedMessageV3)notice)).setDurableSupplier(PDPulseSubject.getDurableSupplier((GeneratedMessageV3)notice)).setRemoveFunction(PDPulseSubject.getRemoveFunction());
    }

    public static <T extends GeneratedMessageV3> Supplier<Long> getNoticeSupplier(T notice) {
        PulseType type;
        if (notice instanceof PdInstructionResponse) {
            type = PulseType.PULSE_TYPE_PD_INSTRUCTION;
        } else if (notice instanceof PartitionHeartbeatResponse) {
            type = PulseType.PULSE_TYPE_PARTITION_HEARTBEAT;
        } else {
            throw new IllegalArgumentException("Unknown pulse type " + notice.getClass().getName());
        }
        return () -> PDPulseSubject.getSubject((PulseType)type).notifyClient(notice);
    }

    private static Supplier<String> getDurableSupplier(GeneratedMessageV3 notice) {
        return () -> {
            Metapb.QueueItem queueItem = PDPulseSubject.toQueueItem((GeneratedMessageV3)notice);
            String res = null;
            try {
                if (((Boolean)queueDurableFunction.apply(queueItem)).booleanValue()) {
                    res = queueItem.getItemId();
                } else {
                    log.error("Failed to persist queue-item that contained PartitionHeartbeatResponse: {}", (Object)notice);
                }
            }
            catch (Throwable t) {
                log.error("Failed to invoke queueDurableFunction, cause by:", t);
            }
            return res;
        };
    }

    private static Function<String, Boolean> getRemoveFunction() {
        return s -> {
            boolean flag = false;
            try {
                flag = (Boolean)queueRemoveFunction.apply(s);
            }
            catch (Throwable t) {
                log.error("Failed to invoke queueRemoveFunction, cause by:", t);
            }
            return flag;
        };
    }

    private static Metapb.QueueItem toQueueItem(GeneratedMessageV3 notice) {
        return Metapb.QueueItem.newBuilder().setItemId(IdUtil.createMillisStr()).setItemClass(notice.getClass().getTypeName()).setItemContent(notice.toByteString()).setTimestamp(System.currentTimeMillis()).build();
    }

    private static PartitionHeartbeatResponse toNotice(Metapb.QueueItem item) {
        Parser parser = PartitionHeartbeatResponse.parser();
        PartitionHeartbeatResponse buf = null;
        try {
            buf = (PartitionHeartbeatResponse)parser.parseFrom(item.getItemContent());
        }
        catch (InvalidProtocolBufferException t) {
            log.error("Failed to parse queue-item to PartitionHeartbeatResponse, cause by:", (Throwable)t);
        }
        return buf;
    }

    public static void notifyError(int code, String message) {
        subjectHolder.forEach((k, v) -> v.notifyError(code, message));
    }

    public static void listenPartitionHeartbeat(PulseListener<PartitionHeartbeatRequest> listener) {
        ((AbstractObserverSubject)subjectHolder.get(PulseType.PULSE_TYPE_PARTITION_HEARTBEAT.name())).addListener(PDPulseSubject.createListenerId(), listener);
    }

    private static Long createListenerId() {
        return PDPulseSubject.createObserverId();
    }

    private static Long createObserverId() {
        return IdUtil.createMillisId();
    }

    static {
        subjectHolder.put(PulseType.PULSE_TYPE_PARTITION_HEARTBEAT.name(), new PartitionHeartbeatSubject());
        subjectHolder.put(PulseType.PULSE_TYPE_PD_INSTRUCTION.name(), new PdInstructionSubject());
        scheduledExecutor.scheduleAtFixedRate(() -> PDPulseSubject.doSchedule(), 0L, 60L, TimeUnit.SECONDS);
    }
}

