/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.rest;

import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.model.RestApiResponse;
import org.apache.hugegraph.pd.raft.RaftEngine;
import org.apache.hugegraph.pd.rest.API;
import org.apache.hugegraph.pd.rest.IndexAPI;
import org.apache.hugegraph.pd.rest.MemberAPI;
import org.apache.hugegraph.pd.service.PDRestService;
import org.apache.hugegraph.pd.service.PDService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class IndexAPI
extends API {
    private static final Logger log = LoggerFactory.getLogger(IndexAPI.class);
    @Autowired
    PDService pdService;
    @Autowired
    PDRestService pdRestService;

    @GetMapping(value={"/"}, produces={"application/json"})
    @ResponseBody
    public BriefStatistics index() throws PDException, ExecutionException, InterruptedException {
        BriefStatistics statistics = new BriefStatistics(this);
        statistics.leader = RaftEngine.getInstance().getLeaderGrpcAddress();
        statistics.state = this.pdService.getStoreNodeService().getClusterStats().getState().toString();
        statistics.storeSize = this.pdService.getStoreNodeService().getActiveStores().size();
        statistics.graphSize = this.pdService.getPartitionService().getGraphs().size();
        statistics.partitionSize = this.pdService.getStoreNodeService().getShardGroups().size();
        return statistics;
    }

    @GetMapping(value={"/v1/cluster"}, produces={"application/json"})
    @ResponseBody
    public RestApiResponse cluster() throws InterruptedException, ExecutionException {
        Statistics statistics = new Statistics(this);
        try {
            statistics.state = String.valueOf(this.pdService.getStoreNodeService().getClusterStats().getState());
            String leaderGrpcAddress = RaftEngine.getInstance().getLeaderGrpcAddress();
            MemberAPI.CallStreamObserverWrap response = new MemberAPI.CallStreamObserverWrap();
            this.pdService.getMembers(Pdpb.GetMembersRequest.newBuilder().build(), (StreamObserver)response);
            ArrayList<Member> pdList = new ArrayList<Member>();
            for (Object member : ((Pdpb.GetMembersResponse)response.get().get(0)).getMembersList()) {
                Member member1 = new Member(this, (Metapb.Member)member);
                if (leaderGrpcAddress != null && leaderGrpcAddress.equals(member.getGrpcUrl())) {
                    member1.role = "Leader";
                    statistics.pdLeader = member1;
                } else {
                    member1.role = "Follower";
                }
                pdList.add(member1);
            }
            statistics.pdList = pdList;
            statistics.memberSize = pdList.size();
            ArrayList<Store> stores = new ArrayList<Store>();
            for (Object store : this.pdService.getStoreNodeService().getStores()) {
                stores.add(new Store(this, (Metapb.Store)store));
            }
            statistics.stores = stores;
            statistics.storeSize = statistics.stores.size();
            statistics.onlineStoreSize = this.pdService.getStoreNodeService().getActiveStores().size();
            statistics.offlineStoreSize = statistics.storeSize - statistics.onlineStoreSize;
            List graphs = this.pdRestService.getGraphs();
            statistics.graphSize = graphs.stream().filter(g -> g.getGraphName() != null && g.getGraphName().endsWith("/g")).count();
            statistics.partitionSize = this.pdService.getStoreNodeService().getShardGroups().size();
            statistics.shardCount = this.pdService.getConfigService().getPDConfig().getShardCount();
            for (Metapb.Store store : this.pdService.getStoreNodeService().getStores()) {
                List graphStatsList = store.getStats().getGraphStatsList();
                for (Metapb.GraphStats graphStats : graphStatsList) {
                    statistics.keyCount += graphStats.getApproximateKeys();
                    statistics.dataSize += graphStats.getApproximateSize();
                }
            }
            Metapb.PartitionState dataState = Metapb.PartitionState.PState_Normal;
            for (Metapb.Graph graph : this.pdRestService.getGraphs()) {
                if (graph.getState() == Metapb.PartitionState.UNRECOGNIZED || graph.getState() == null || graph.getState().getNumber() <= dataState.getNumber()) continue;
                dataState = graph.getState();
            }
            statistics.dataState = dataState.name();
            return new RestApiResponse((Object)statistics, Pdpb.ErrorType.OK, Pdpb.ErrorType.OK.name());
        }
        catch (PDException e) {
            log.error("PD Exception: ", (Throwable)e);
            return new RestApiResponse(null, e.getErrorCode(), e.getMessage());
        }
    }
}

