/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.rest;

import java.util.List;
import java.util.Map;
import org.apache.hugegraph.pd.common.KVPair;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.rest.API;
import org.apache.hugegraph.pd.service.PDRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/task"})
public class TaskAPI
extends API {
    private static final Logger log = LoggerFactory.getLogger(TaskAPI.class);
    @Autowired
    PDRestService pdRestService;

    @GetMapping(value={"/patrolStores"}, produces={"application/json"})
    @ResponseBody
    public String patrolStores() {
        try {
            List stores = this.pdRestService.patrolStores();
            return this.toJSON(stores, "stores");
        }
        catch (PDException e) {
            e.printStackTrace();
            return this.toJSON(e);
        }
    }

    @GetMapping(value={"/patrolPartitions"}, produces={"application/json"})
    @ResponseBody
    public String patrolPartitions() {
        try {
            List partitions = this.pdRestService.patrolPartitions();
            return this.toJSON(partitions, "partitions");
        }
        catch (PDException e) {
            e.printStackTrace();
            return this.toJSON(e);
        }
    }

    @GetMapping(value={"/balancePartitions"}, produces={"application/json"})
    @ResponseBody
    public Map<Integer, KVPair<Long, Long>> balancePartitions() {
        try {
            Map partitions = this.pdRestService.balancePartitions();
            return partitions;
        }
        catch (PDException e) {
            e.printStackTrace();
            return null;
        }
    }

    @GetMapping(value={"/splitPartitions"}, produces={"application/json"})
    @ResponseBody
    public String splitPartitions() {
        try {
            List partitions = this.pdRestService.splitPartitions();
            return this.toJSON(partitions, "partitions");
        }
        catch (PDException e) {
            e.printStackTrace();
            return this.toJSON(e);
        }
    }

    @GetMapping(value={"/balanceLeaders"})
    public Map<Integer, Long> balanceLeaders() throws PDException {
        return this.pdRestService.balancePartitionLeader();
    }

    @GetMapping(value={"/compact"})
    public String dbCompaction() throws PDException {
        this.pdRestService.dbCompaction();
        return "compact ok";
    }
}

