/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.rest.interceptor;

import java.io.IOException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hugegraph.pd.rest.API;
import org.apache.hugegraph.pd.service.interceptor.Authentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Service
public class RestAuthentication
extends Authentication
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RestAuthentication.class);
    private static final String TOKEN_KEY = "Pd-Token";
    private static final Supplier<Boolean> DEFAULT_HANDLE = () -> true;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        try {
            String token = request.getHeader(TOKEN_KEY);
            String authority = request.getHeader("Authorization");
            if (authority == null) {
                throw new Exception("Unauthorized!");
            }
            Function<String, Boolean> tokenCall = t -> {
                response.addHeader(TOKEN_KEY, t);
                return true;
            };
            authority = authority.replace("Basic ", "");
            return (Boolean)this.authenticate(authority, token, tokenCall, DEFAULT_HANDLE);
        }
        catch (Exception e) {
            response.setContentType("application/json");
            response.getWriter().println(new API().toJSON((Throwable)e));
            response.getWriter().flush();
            return false;
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) {
    }
}

