/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pinyin4j;

import com.hp.hpl.sparta.Document;
import com.hp.hpl.sparta.Element;
import com.hp.hpl.sparta.ParseException;
import net.sourceforge.pinyin4j.GwoyeuRomatzyhResource;
import net.sourceforge.pinyin4j.PinyinRomanizationType;
import net.sourceforge.pinyin4j.TextHelper;

class GwoyeuRomatzyhTranslator {
    private static String[] tones = new String[]{"_I", "_II", "_III", "_IV", "_V"};

    GwoyeuRomatzyhTranslator() {
    }

    static String convertHanyuPinyinToGwoyeuRomatzyh(String hanyuPinyinStr) {
        String pinyinString = TextHelper.extractPinyinString(hanyuPinyinStr);
        String toneNumberStr = TextHelper.extractToneNumber(hanyuPinyinStr);
        String gwoyeuStr = null;
        try {
            String xpathQuery1 = "//" + PinyinRomanizationType.HANYU_PINYIN.getTagName() + "[text()='" + pinyinString + "']";
            Document pinyinToGwoyeuMappingDoc = GwoyeuRomatzyhResource.getInstance().getPinyinToGwoyeuMappingDoc();
            Element hanyuNode = pinyinToGwoyeuMappingDoc.xpathSelectElement(xpathQuery1);
            if (null != hanyuNode) {
                String targetPinyinStrWithoutToneNumber;
                String xpathQuery2 = "../" + PinyinRomanizationType.GWOYEU_ROMATZYH.getTagName() + tones[Integer.parseInt(toneNumberStr) - 1] + "/text()";
                gwoyeuStr = targetPinyinStrWithoutToneNumber = hanyuNode.xpathSelectString(xpathQuery2);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return gwoyeuStr;
    }
}

