/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.reader.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.SnappyCodec;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.parser.CsvLineParser;
import org.apache.hugegraph.loader.parser.JsonLineParser;
import org.apache.hugegraph.loader.parser.LineParser;
import org.apache.hugegraph.loader.parser.TextLineParser;
import org.apache.hugegraph.loader.reader.Readable;
import org.apache.hugegraph.loader.reader.line.Line;
import org.apache.hugegraph.loader.reader.line.LineFetcher;
import org.apache.hugegraph.loader.source.file.Compression;
import org.apache.hugegraph.loader.source.file.FileFormat;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class FileLineFetcher
extends LineFetcher {
    private static final Logger LOG = Log.logger(FileLineFetcher.class);
    private static final long BUF_SIZE = 0x400000L;
    private static final int FIRST_LINE_OFFSET = 1;
    private BufferedReader reader = null;
    private final LineParser parser;

    public FileLineFetcher(FileSource source) {
        super(source);
        this.parser = FileLineFetcher.createLineParser(source);
    }

    @Override
    public FileSource source() {
        return (FileSource)super.source();
    }

    @Override
    public boolean ready() {
        return this.reader != null;
    }

    @Override
    public void resetReader() {
        LOG.debug("resetReader called, reader reset to null, offset={}", (Object)this.offset());
        this.reader = null;
    }

    @Override
    public boolean needReadHeader() {
        return this.source().format().needHeader() && this.source().header() == null;
    }

    @Override
    public String[] readHeader(List<Readable> readables) {
        String[] header = null;
        for (Readable readable : readables) {
            LOG.debug("try to read header from {}", (Object)readable.name());
            this.openReader(readable);
            assert (this.reader != null);
            try {
                String line = this.reader.readLine();
                if (StringUtils.isEmpty((CharSequence)line)) continue;
                header = this.parser.split(line);
                break;
            }
            catch (IOException e) {
                throw new LoadException("Failed to read header from '%s'", (Throwable)e, readable);
            }
            finally {
                try {
                    this.closeReader();
                }
                catch (IOException e) {
                    LOG.warn("Failed to close reader of '{}'", (Object)readable);
                }
            }
        }
        return header;
    }

    @Override
    public void openReader(Readable readable) {
        InputStream stream = null;
        try {
            stream = readable.open();
            this.reader = FileLineFetcher.createBufferedReader(stream, this.source());
        }
        catch (IOException e) {
            throw new LoadException("Failed to open stream for '%s'", (Throwable)e, readable);
        }
        catch (Exception e) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ignored) {
                    LOG.warn("Failed to close stream of '{}'", (Object)readable);
                }
            }
            throw new LoadException("Failed to create reader for '%s'", (Throwable)e, readable);
        }
        this.resetStatus();
    }

    @Override
    public void closeReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public Line fetch() throws IOException {
        String rawLine;
        do {
            if ((rawLine = this.reader.readLine()) == null) {
                return null;
            }
            this.increaseOffset();
        } while (this.needSkipLine(rawLine) || this.checkMatchHeader(rawLine));
        return this.parser.parse(this.source().header(), rawLine);
    }

    public void readHeaderIfNeeded(List<Readable> readables) {
        if (!this.needReadHeader()) {
            return;
        }
        E.checkArgument((!CollectionUtils.isEmpty(readables) ? 1 : 0) != 0, (String)"Must contain at least one readable file", (Object[])new Object[0]);
        String[] header = this.readHeader(readables);
        this.resetReader();
        this.resetStatus();
        if (header == null) {
            throw new LoadException("Failed to read header from file source '%s'", this.source());
        }
        this.source().header(header);
    }

    public void skipOffset(Readable readable, long offset) {
        if (offset <= 0L) {
            return;
        }
        E.checkState((this.reader != null ? 1 : 0) != 0, (String)"The reader shouldn't be null", (Object[])new Object[0]);
        try {
            for (long i = 0L; i < offset; ++i) {
                this.reader.readLine();
            }
        }
        catch (IOException e) {
            throw new LoadException("Failed to skip the first %s lines of file %s, please ensure the file must have at least %s lines", (Throwable)e, offset, readable, offset);
        }
        this.addOffset(offset);
    }

    private void resetStatus() {
        super.resetOffset();
    }

    private boolean needSkipLine(String line) {
        if (this.source().skippedLine() != null) {
            return this.source().skippedLine().matches(line);
        }
        return false;
    }

    private boolean checkMatchHeader(String line) {
        if (!this.source().format().needHeader() || this.offset() != 1L) {
            return false;
        }
        assert (this.source().header() != null);
        Object[] columns = this.parser.split(line);
        return Arrays.equals(this.source().header(), columns);
    }

    private static BufferedReader createBufferedReader(InputStream stream, FileSource source) throws Exception {
        E.checkNotNull((Object)stream, (String)"stream");
        try {
            Reader csr = FileLineFetcher.createCompressReader(stream, source);
            return new BufferedReader(csr, 0x400000);
        }
        catch (IOException e) {
            try {
                stream.close();
            }
            catch (IOException ignored) {
                LOG.warn("Failed to close file {}", (Object)source.path());
            }
            throw e;
        }
    }

    private static Reader createCompressReader(InputStream stream, FileSource source) throws Exception {
        Compression compression = source.compression();
        String charset = source.charset();
        switch (compression) {
            case NONE: {
                return new InputStreamReader(stream, charset);
            }
            case SNAPPY_RAW: {
                Configuration config = new Configuration();
                CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(SnappyCodec.class, (Configuration)config);
                CompressionInputStream sis = codec.createInputStream(stream, codec.createDecompressor());
                return new InputStreamReader((InputStream)sis, charset);
            }
            case GZIP: 
            case BZ2: 
            case XZ: 
            case LZMA: 
            case SNAPPY_FRAMED: 
            case Z: 
            case DEFLATE: 
            case LZ4_BLOCK: 
            case LZ4_FRAMED: {
                CompressorStreamFactory factory = new CompressorStreamFactory();
                CompressorInputStream cis = factory.createCompressorInputStream(compression.string(), stream);
                return new InputStreamReader((InputStream)cis, charset);
            }
        }
        throw new LoadException("Unsupported compression format '%s'", new Object[]{compression});
    }

    private static LineParser createLineParser(FileSource source) {
        FileFormat format = source.format();
        switch (format) {
            case CSV: {
                return new CsvLineParser();
            }
            case TEXT: {
                return new TextLineParser(source.delimiter());
            }
            case JSON: {
                return new JsonLineParser();
            }
        }
        throw new AssertionError((Object)String.format("Unsupported file format '%s' of source '%s'", new Object[]{format, source}));
    }
}

